/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringLineToLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.ACCreateAnchoringLine;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ACCreateAnchoringLineToLine
extends ACCreateAnchoringLine {
    private final IPMLineRW targetLine;
    private IPMAnchoringLineToLineRW anchoringLineToLine;

    public ACCreateAnchoringLineToLine(ActionContext context, IPMLineRW line, IPMLineRW targetLine) {
        super(context, line);
        assert (targetLine != null) : "ref to targetLine is null";
        this.targetLine = targetLine;
    }

    @Override
    public boolean isDupe(Action a) {
        ACCreateAnchoringLineToLine dupeA;
        boolean isDupe = false;
        if (a instanceof ACCreateAnchoringLineToLine && (dupeA = (ACCreateAnchoringLineToLine)a).getLine() == this.getLine() && dupeA.getTargetLine() == this.getTargetLine()) {
            isDupe = true;
        }
        return isDupe;
    }

    @Override
    protected void initializeState() {
        this.anchoringLineToLine = this.getIPlanModelObjectFactoryRW().createPMAnchoringLineToLineRW();
        super.initializeState();
        this.anchoringLineToLine.setTargetLine(this.targetLine);
    }

    @Override
    protected void setStateToPre() {
        super.setStateToPre();
        assert (this.targetLine.getLineToLineAnchoringIndex(this.anchoringLineToLine) == this.targetLine.getLineToLineAnchoringCount() - 1) : "anchoring is not at the expected index";
        this.targetLine.removeLineToLineAnchoring(this.targetLine.getLineToLineAnchoringCount() - 1);
    }

    @Override
    protected void setStateToPost() {
        super.setStateToPost();
        this.targetLine.addLineToLineAnchoring(this.anchoringLineToLine, this.targetLine.getPointToLineAnchoringCount());
    }

    public Set getChanges() {
        HashSet<IModelChangeRW> changes = new HashSet<IModelChangeRW>(1);
        changes.add(this.getIPlanModelObjectFactoryRW().createModelChange(this.anchoringLineToLine, 1));
        return changes;
    }

    @Override
    public Collection getEntriesForCompressedReactionList() {
        return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionCreateAnchoringAgent().getEntryForCompressedList(this.getAnchoringLine(), this.getActionContext()));
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        assert (this.getLine().getPlanElementRW().getPlanRW() == this.targetLine.getPlanElementRW().getPlanRW()) : "the plan should be unique";
        return this.getLine().getPlanElementRW().getPlanRW();
    }

    public IPMLineRW getTargetLine() {
        return this.targetLine;
    }

    @Override
    public IPMAnchoringLineRW getAnchoringLine() {
        return this.anchoringLineToLine;
    }

    public String toString() {
        return "ACCreateAnchoringLineToLine (target line " + this.targetLine + ")";
    }
}

