/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ActionTypeManager;
import com.arcway.planagent.planmodel.appearance.IAppearance;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ACApplyAppearanceTpl
extends Action {
    private final IPMPlanObjectRW planObject;
    private final IAppearanceTpl template;
    private final IAppearance appearanceToChange;
    private IAppearanceRO oldAppearance;
    private boolean changed;

    public ACApplyAppearanceTpl(ActionContext actionContext, IPMPlanObjectRO planObject, IAppearanceRO appearanceToChange, IAppearanceTpl template) {
        super(actionContext);
        assert (planObject != null) : "ref to figure is null";
        assert (appearanceToChange != null) : "ref to appearanceToChange  is null";
        assert (template != null) : "ref to template is null";
        this.planObject = (IPMPlanObjectRW)((Object)planObject);
        this.appearanceToChange = (IAppearance)appearanceToChange;
        this.template = template;
    }

    @Override
    public boolean isDupe(Action a) {
        return false;
    }

    @Override
    public boolean isNop() {
        return this.template.isEmpty();
    }

    @Override
    public ActionIterator getPreActionIterator() {
        return ActionIterator.EMPTY_ACTION_ITERATOR;
    }

    @Override
    protected void initializeState() {
        this.oldAppearance = this.appearanceToChange.getAppearanceAsCopy();
        this.changed = this.template.applyTo(this.appearanceToChange);
    }

    @Override
    protected void setStateToPost() {
        if (this.changed) {
            this.template.applyTo(this.appearanceToChange);
        }
    }

    @Override
    protected void setStateToPre() {
        if (this.changed) {
            this.appearanceToChange.setAppearanceFrom(this.oldAppearance);
        }
    }

    public Set getChanges() {
        if (this.changed) {
            return Collections.singleton(this.planObject.getIPlanModelMgrRW().getPlanModelObjectFactoryRW().createModelChange(this.planObject, 2));
        }
        return Collections.EMPTY_SET;
    }

    public Collection getEntriesForCompressedReactionList() {
        HashSet<IEntryOfCompressedList> actions = new HashSet<IEntryOfCompressedList>();
        if (this.planObject instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)this.planObject, null);
            actions.add(ActionTypeManager.getInstance().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        if (this.planObject instanceof IPMFigureRW) {
            ArrayList<IPMPlanObjectRW> changedFigures = new ArrayList<IPMPlanObjectRW>(1);
            changedFigures.add(this.planObject);
            actions.add(ActionTypeManager.getInstance().getReactionChangeGeometryAttributeFigureAgent().getEntryForCompressedList((IPMFigureRW)this.planObject, this.getActionContext()));
        }
        return actions;
    }

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.planObject.getPlanElementRW();
    }

    public String toString() {
        return "ACApplyTemplateAction " + this.template + " on object " + this.planObject + "/" + this.appearanceToChange;
    }
}

