/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.actions;

import com.arcway.lib.java.New;
import com.arcway.planagent.planmodel.access.readwrite.IModelChangeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMSemanticalUnitRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.anchoring.AnchoringAgent;
import com.arcway.planagent.planmodel.reactions.IEntryOfCompressedList;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public abstract class ACAbstractModifyGeometry
extends Action {
    private final IPMPlanObjectRW planObject;
    private final boolean removeSourceAnchorings;

    public ACAbstractModifyGeometry(IPMPlanObjectRW planObject, boolean removeSourceAnchorings, ActionContext actionContext) {
        super(actionContext);
        this.planObject = planObject;
        this.removeSourceAnchorings = removeSourceAnchorings;
    }

    public IPMPlanObjectRW getPlanObject() {
        return this.planObject;
    }

    @Override
    public ActionIterator getPreActionIterator() {
        ActionIterator preActionIterator;
        if (!this.isNop()) {
            ActionIterator removeAnchoringActionIterator;
            AnchoringAgent anchoringAgent = this.getPlanModelMgr().getAnchoringAgent();
            ArrayList sourceContributors = new ArrayList();
            if (this.removeSourceAnchorings) {
                sourceContributors.addAll(this.getPrimaryAnchoringSourceContributors());
            }
            Collection destinationContribturos = this.getAnchoringDestinationContributors();
            preActionIterator = removeAnchoringActionIterator = anchoringAgent.removeAnchorings(sourceContributors, destinationContribturos, this.getActionContext());
        } else {
            preActionIterator = ActionIterator.EMPTY_ACTION_ITERATOR;
        }
        return preActionIterator;
    }

    public Set getChanges() {
        IModelChangeRW modelChange = this.getIPlanModelObjectFactoryRW().createModelChange(this.getPlanObject().getPointListRW(), 2);
        Set<IModelChangeRW> changes = Collections.singleton(modelChange);
        return changes;
    }

    @Override
    public Collection<IEntryOfCompressedList> getEntriesForCompressedReactionList() {
        IPMPlanObjectRW planObj = this.getPlanObject();
        if (planObj instanceof IPMFigureRW) {
            IPMFigureRW figure = (IPMFigureRW)planObj;
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionChangeGeometryFigureAgent().getEntryForCompressedList(figure, this.getPreStateGeometry(), this.getActionContext()));
        }
        if (planObj instanceof IPMGraphicalSupplementRW) {
            HashMap changedSupplements = New.hashMap((int)1);
            changedSupplements.put((IPMGraphicalSupplementRW)this.planObject, this.getPreStateGeometry());
            return Collections.singleton(this.getActionContext().getActionTypeAgentManager().getReactionModifySupplementAgent().getEntryForCompressedList(changedSupplements, this.getActionContext()));
        }
        assert (false) : "point not part of supplement or figure";
        return null;
    }

    protected abstract List<PositionAndPoint> getPreStateGeometry();

    protected abstract Collection getPrimaryAnchoringSourceContributors();

    protected abstract Collection getSecondaryAnchoringSourceContributors();

    protected abstract Collection getAnchoringDestinationContributors();

    @Override
    public IPMSemanticalUnitRW getSemanticalUnit() {
        return this.getPlanObject().getPlanElementRW();
    }
}

