/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementMarkerRW;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDCallRO;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDCallRW;
import com.arcway.planagent.planmodel.uml.sd.implementation.PMPlanElementUMLSDCall;
import java.util.List;

public class RAFixUMLSDCallCommentAfterModifyEdge
implements IRAChangeGeometryFigure {
    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigureLineShapeRW edge = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementUMLSDCallRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigureLineShapeRW)) {
            route &= false;
        }
        if (route) {
            IPMFigureLineShapeRW lineShape = (IPMFigureLineShapeRW)figure;
            if (!lineShape.getRole().equals("outline")) {
                route &= false;
            }
            if (route) {
                edge = lineShape;
            }
        }
        if (edge != null) {
            IPMPlanElementUMLSDCallRW planElement = (IPMPlanElementUMLSDCallRW)edge.getPlanElementRW();
            if (planElement.getCommentRW() != null) {
                Points suggestion = PMPlanElementUMLSDCall.calculateCommentAreaSuggestion((IPMPlanElementUMLSDCallRO)((Object)planElement));
                Point newUL = suggestion.get(0);
                Point newLR = suggestion.get(2);
                IPMPointListRW boxPoints = planElement.getCommentRW().getPointListRW();
                IPMPointRW ul = null;
                IPMPointRW lr = null;
                int i = 0;
                while (i < boxPoints.getPointCount()) {
                    IPMPointRW currentPoint = boxPoints.getPointRW(i);
                    if (ul == null) {
                        ul = currentPoint;
                    } else if (currentPoint.getPosition().y + 1.0E-10 < ul.getPosition().y) {
                        ul = currentPoint;
                    } else if (Geo.equals((double)currentPoint.getPosition().y, (double)ul.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < ul.getPosition().x) {
                        ul = currentPoint;
                    }
                    if (lr == null) {
                        lr = currentPoint;
                    } else if (currentPoint.getPosition().y - 1.0E-10 > lr.getPosition().y) {
                        lr = currentPoint;
                    } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lr.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lr.getPosition().x) {
                        lr = currentPoint;
                    }
                    ++i;
                }
                boolean removeSourceAnchorings = false;
                assert (lr != null) : "lr is null";
                assert (ul != null) : "ul is null";
                GeoVector distanceToMove = new GeoVector(ul.getPosition(), newUL);
                ACMovePoint movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)ul, (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
                actions.addAction((Action)movePointAction);
                distanceToMove = new GeoVector(lr.getPosition(), newLR);
                movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lr, (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
                actions.addAction((Action)movePointAction);
            }
            if (planElement.getMarkerSupplementRW() != null) {
                GeoVector dir;
                IPMGraphicalSupplementMarkerRW markerSuppl = planElement.getMarkerSupplementRW();
                IPMPointRW originPoint = markerSuppl.getPointListRW().getPointRW(0);
                Point point = null;
                if (markerSuppl.getRole().equals("foundmessage")) {
                    Point startPoint = edge.getPointListRW().getPointRW(0).getPosition();
                    dir = new GeoVector(startPoint, edge.getPointListRW().getPointRW(edge.getPointListRW().getPointCount() - 1).getPosition());
                    point = startPoint.movePoint(dir.turn180().scaleToLength(1.2));
                } else if (markerSuppl.getRole().equals("lostmessage")) {
                    Point endPoint = edge.getPointListRW().getPointRW(edge.getPointListRW().getPointCount() - 1).getPosition();
                    dir = new GeoVector(edge.getPointListRW().getPointRW(0).getPosition(), endPoint);
                    point = endPoint.movePoint(dir.scaleToLength(1.2));
                }
                assert (point != null);
                boolean removeSourceAnchorings = false;
                GeoVector distanceToMove = new GeoVector(originPoint.getPosition(), point);
                ACMovePoint movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)originPoint, (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
                actions.addAction((Action)movePointAction);
            }
        }
    }
}

