/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDActivationBoxRW;
import java.util.List;

public class RAFixUMLSDActivationBoxAfterModifyGeometryLine
implements IRAChangeGeometryFigure,
IRAMoveFigure {
    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(4 * figureMovements.size());
        for (IPMFigureRW figure : figureMovements) {
            this.addFixActions(figure, context, actions);
        }
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigureLineShapeRW geometryLine = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementUMLSDActivationBoxRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigureLineShapeRW)) {
            route &= false;
        }
        if (route) {
            IPMFigureLineShapeRW lineShape = (IPMFigureLineShapeRW)figure;
            if (!lineShape.getRole().equals("geometryLine")) {
                route &= false;
            }
            if (route) {
                geometryLine = lineShape;
            }
        }
        if (geometryLine != null) {
            IPMPlanElementUMLSDActivationBoxRW planElement = (IPMPlanElementUMLSDActivationBoxRW)geometryLine.getPlanElementRW();
            Points linePoints = geometryLine.getPointListRW().getPoints();
            Point upperPoint = linePoints.get(0);
            Point lowerPoint = linePoints.get(1);
            if (upperPoint.y > lowerPoint.y) {
                Point t = upperPoint;
                upperPoint = lowerPoint;
                lowerPoint = t;
            }
            IPMPointListRW boxPoints = planElement.getBoxFigureRW().getPointListRW();
            IPMPointRW ul = null;
            IPMPointRW lr = null;
            int i = 0;
            while (i < boxPoints.getPointCount()) {
                IPMPointRW currentPoint = boxPoints.getPointRW(i);
                if (ul == null) {
                    ul = currentPoint;
                } else if (currentPoint.getPosition().y + 1.0E-10 < ul.getPosition().y) {
                    ul = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)ul.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < ul.getPosition().x) {
                    ul = currentPoint;
                }
                if (lr == null) {
                    lr = currentPoint;
                } else if (currentPoint.getPosition().y - 1.0E-10 > lr.getPosition().y) {
                    lr = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lr.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lr.getPosition().x) {
                    lr = currentPoint;
                }
                ++i;
            }
            assert (lr != null) : "lr is null";
            assert (ul != null) : "ul is null";
            double width = lr.getPosition().x - ul.getPosition().x;
            boolean removeSourceAnchorings = false;
            GeoVector distanceToMove = new GeoVector(ul.getPosition(), new Point(upperPoint.x - width / 2.0, upperPoint.y));
            ACMovePoint movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)ul, (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
            actions.addAction((Action)movePointAction);
            distanceToMove = new GeoVector(lr.getPosition(), new Point(lowerPoint.x + width / 2.0, lowerPoint.y));
            movePointAction = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lr, (GeoVector)distanceToMove, (boolean)removeSourceAnchorings);
            actions.addAction((Action)movePointAction);
        }
    }
}

