/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.implementation;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Alignment;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithLineShapeOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementMarkerRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementMarkerRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementMarker;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDCallRO;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDCallRW;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementUMLSDCall
extends PMPlanElementWithLineShapeOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementUMLSDCallRO,
IPMPlanElementUMLSDCallRW {
    private static final double DEFAULT_COMMENT_HEIGHT = 5.0;
    public static final double BUBBLE_SIZE = 0.6;
    public static final String XML_TYPE = "uml.sd.call";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";
    public static final String XML_SUPPLEMENT_LOSTBUBBLE_ROLE = "lostmessage";
    public static final String XML_SUPPLEMENT_FOUNDBUBBLE_ROLE = "foundmessage";
    private static String DEFAULT_NAME = "Call";
    private final ITransactionValidator transactionValidator = new ForceValidFiguresTransactionValidator((IPMPlanElementRO)this){

        protected boolean isPlanObjectOk(IPMPlanObjectRO planObject) {
            boolean isPlanObjectOk = super.isPlanObjectOk(planObject);
            if (isPlanObjectOk && PMPlanElementUMLSDCall.this.getEditFigures().contains(planObject)) {
                isPlanObjectOk &= planObject.getPointListRO().getPointCount() == 2 || planObject.getPointListRO().getPointCount() == 4;
            }
            return isPlanObjectOk;
        }
    };
    private static final Alignment DEFAULT_ALIGNMENT_FOR_NAME_SUPPLEMENT = new Alignment(2, 32);

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    @Deprecated
    public PMPlanElementUMLSDCall(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    @Deprecated
    public PMPlanElementUMLSDCall(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    protected PMPlanElementUMLSDCall(PMPlan plan) {
        super(plan.getPlanModelMgr(), plan);
        this.setType(XML_TYPE);
        super.setName(DEFAULT_NAME);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    public boolean isBendable(PMFigure figure) {
        assert (this.getFigureIndex(figure) >= 0);
        if (figure.getRole().equals("outline")) {
            return true;
        }
        return super.isBendable(figure);
    }

    public ITransactionValidator getTransactionValidator() {
        return this.transactionValidator;
    }

    private PMFigureLineShape getCall() {
        return this.getOutlineFigureLineShape();
    }

    @Override
    public IPMFigureLineShapeRO getCallRO() {
        return this.getCall();
    }

    @Override
    public IPMFigureLineShapeRW getCallRW() {
        return this.getCall();
    }

    public Collection getEditFigures() {
        return Collections.singleton(this.getOutlineFigure());
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = (PMFigure)this.getOutlineFigure();
        assert (outlineFigure != null) : "outlineFigure is NULL.";
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "it was not exactly one reference found";
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    private PMGraphicalSupplementMarker getMarkerSupplement() {
        PMFigure outlineFigure = (PMFigure)this.getOutlineFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_FOUNDBUBBLE_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_LOSTBUBBLE_ROLE);
            assert (supplementRefs != null) : "supplementRefs is NULL.";
            if (supplementRefs.size() == 0) {
                return null;
            }
        }
        assert (supplementRefs.size() == 1) : "it was not exactly one reference found";
        return (PMGraphicalSupplementMarker)supplementRefs.get(0);
    }

    public IPMGraphicalSupplementMarkerRO getMarkerSupplementRO() {
        return this.getMarkerSupplement();
    }

    public IPMGraphicalSupplementMarkerRW getMarkerSupplementRW() {
        return this.getMarkerSupplement();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    public static Points calculateCommentAreaSuggestion(IPMPlanElementUMLSDCallRO call) {
        double height = 5.0;
        double width = 0.0;
        IPMGraphicalSupplementTextRO comment = call.getCommentRO();
        if (comment != null) {
            IPMPointListRO commentPoints = comment.getPointListRO();
            double miny = Double.POSITIVE_INFINITY;
            double maxy = Double.NEGATIVE_INFINITY;
            double minx = Double.POSITIVE_INFINITY;
            double maxx = Double.NEGATIVE_INFINITY;
            int i = 0;
            while (i < commentPoints.getPointCount()) {
                if (commentPoints.getPointRO((int)i).getPosition().y < miny) {
                    miny = commentPoints.getPointRO((int)i).getPosition().y;
                }
                if (commentPoints.getPointRO((int)i).getPosition().y > maxy) {
                    maxy = commentPoints.getPointRO((int)i).getPosition().y;
                }
                if (commentPoints.getPointRO((int)i).getPosition().x < minx) {
                    minx = commentPoints.getPointRO((int)i).getPosition().x;
                }
                if (commentPoints.getPointRO((int)i).getPosition().x > maxx) {
                    maxx = commentPoints.getPointRO((int)i).getPosition().x;
                }
                ++i;
            }
            height = maxy - miny;
            width = maxx - minx;
        }
        Points points = new Points(4);
        IPMFigureLineShapeRO line = call.getCallRO();
        IPMPointRO leftPoint = line.getPointListRO().getPointRO(0);
        IPMPointRO rightPoint = line.getPointListRO().getPointRO(1);
        if (leftPoint.getPosition().x > rightPoint.getPosition().x) {
            IPMPointRO t = leftPoint;
            leftPoint = rightPoint;
            rightPoint = t;
        }
        if (line.getPointListRO().getLineCount() == 1 || width == 0.0) {
            width = rightPoint.getPosition().x - leftPoint.getPosition().x;
        }
        points.add(new Point(leftPoint.getPosition().x, leftPoint.getPosition().y - height));
        points.add(new Point(leftPoint.getPosition().x + width, rightPoint.getPosition().y - height));
        points.add(new Point(leftPoint.getPosition().x + width, leftPoint.getPosition().y));
        points.add(new Point(leftPoint.getPosition().x, leftPoint.getPosition().y));
        return points;
    }

    public IPMPlanObjectRO.PlanObjectEditType getFigureEditType(IPMFigureRO figure) {
        IPMPlanObjectRO.PlanObjectEditType editType = IPMPlanObjectRO.FIGURE_EDIT_TYPE_FULL_EDGE;
        return editType;
    }

    public String getNamePostfix() {
        if (this.getName() != null && this.getName().length() > 0) {
            return ":";
        }
        return "";
    }

    public Alignment getDefaultAlignmentForNameSupplement() {
        return DEFAULT_ALIGNMENT_FOR_NAME_SUPPLEMENT;
    }
}

