/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.uml.sd.check;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Point;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDActivationBoxRO;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDCallRO;
import com.arcway.planagent.planmodel.uml.sd.access.readonly.IPMPlanElementUMLSDObjectRO;
import com.arcway.planagent.planmodel.uml.sd.access.readwrite.IPMPlanElementUMLSDObjectRW;

public class SDValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        anchoringIsPossible |= SDValidityMatrix.isLifeLineLinkable(source.getAnchoringFigure()) && SDValidityMatrix.isLifeLine(destination.getAnchoringFigure());
        anchoringIsPossible &= SDValidityMatrix.validateAnchoring(source, (IAnchoringDestination)destination, anchoringIsPossible);
        return anchoringIsPossible;
    }

    public static boolean isPointToLineAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationLine destination) {
        boolean anchoringIsPossible = false;
        anchoringIsPossible |= Geo.equals((double)destination.getAnchoringDestinationPosition().start.x, (double)destination.getAnchoringDestinationPosition().end.x) && SDValidityMatrix.isBoxLinkable(source.getAnchoringFigure()) && SDValidityMatrix.isBox(destination.getAnchoringFigure());
        anchoringIsPossible &= SDValidityMatrix.validateAnchoring(source, (IAnchoringDestination)destination, anchoringIsPossible);
        return anchoringIsPossible;
    }

    private static boolean validateAnchoring(IAnchoringSourcePoint source, IAnchoringDestination destination, boolean anchoring) {
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        IPMPlanElementRO sourcePlanElement = sourceFigure.getPlanElementRO();
        IPMPlanElementRO destinationPlanElement = destinationFigure.getPlanElementRO();
        boolean anchoringIsPossible = anchoring;
        if (anchoringIsPossible && SDValidityMatrix.isBox(source.getAnchoringFigure())) {
            anchoringIsPossible &= SDValidityMatrix.isUpperAnchor(source);
        }
        if (anchoringIsPossible && SDValidityMatrix.isLifeLine(sourceFigure)) {
            anchoringIsPossible &= SDValidityMatrix.isObjectBox(destinationFigure);
        }
        if ((anchoringIsPossible &= source.getAnchoringFigure().getPlanElementRO() != destination.getAnchoringFigure().getPlanElementRO() ^ (SDValidityMatrix.isLifeLine(sourceFigure) && SDValidityMatrix.isObjectBox(destinationFigure))) && sourcePlanElement instanceof IPMPlanElementUMLSDActivationBoxRO && destinationPlanElement instanceof IPMPlanElementUMLSDActivationBoxRO) {
            IPMPlanElementUMLSDActivationBoxRO destinationBox = (IPMPlanElementUMLSDActivationBoxRO)destinationPlanElement;
            IPMPlanElementUMLSDActivationBoxRO sourceBox = (IPMPlanElementUMLSDActivationBoxRO)sourcePlanElement;
            anchoringIsPossible &= !SDValidityMatrix.isAnchored(destinationBox, sourceBox);
        }
        return anchoringIsPossible;
    }

    private static boolean isAnchored(IPMPlanElementUMLSDActivationBoxRO source, IPMPlanElementUMLSDActivationBoxRO destination) {
        boolean isAnchored = false;
        IPMFigureLineShapeRO sourceGeoFigure = source.getGeometryLineRO();
        IPMAnchoringPointRO sourceAnchoring1 = sourceGeoFigure.getPointListRO().getPointRO(0).getAnchoringRO();
        IPMAnchoringPointRO sourceAnchoring2 = sourceGeoFigure.getPointListRO().getPointRO(1).getAnchoringRO();
        if (sourceAnchoring1 != null) {
            isAnchored |= SDValidityMatrix.isAnchored(sourceAnchoring1, destination);
        }
        if (sourceAnchoring2 != null) {
            isAnchored |= SDValidityMatrix.isAnchored(sourceAnchoring2, destination);
        }
        return isAnchored;
    }

    private static boolean isAnchored(IPMAnchoringPointRO sourceAnchroring, IPMPlanElementUMLSDActivationBoxRO searchedDestination) {
        boolean isAnchored = false;
        IAnchoringDestination destination = sourceAnchroring.getAnchoringDestination();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        IPMPlanElementRO destinationPlanElement = destinationFigure.getPlanElementRO();
        if (destinationPlanElement instanceof IPMPlanElementUMLSDActivationBoxRO) {
            IPMPlanElementUMLSDActivationBoxRO destinationBox = (IPMPlanElementUMLSDActivationBoxRO)destinationPlanElement;
            isAnchored |= destinationBox == searchedDestination;
            isAnchored |= SDValidityMatrix.isAnchored(destinationBox, searchedDestination);
        }
        return isAnchored;
    }

    public static boolean isPointToPointAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationPoint destination) {
        boolean anchoringIsPossible = false;
        anchoringIsPossible |= SDValidityMatrix.isLifeLine(source.getAnchoringFigure()) && SDValidityMatrix.isObjectBox(destination.getAnchoringFigure()) && source.getAnchoringFigure().getPlanElementRO() == destination.getAnchoringFigure().getPlanElementRO();
        anchoringIsPossible &= SDValidityMatrix.validateAnchoring(source, (IAnchoringDestination)destination, anchoringIsPossible);
        return anchoringIsPossible;
    }

    public static boolean isTouchValid() {
        boolean touchIsValid = false;
        touchIsValid |= SDValidityMatrix.isDirectedTouchValid();
        return touchIsValid |= SDValidityMatrix.isDirectedTouchValid();
    }

    private static boolean isDirectedTouchValid() {
        boolean touchIsValid = true;
        return touchIsValid;
    }

    private static boolean isObjectBox(IPMFigureRO figure) {
        boolean isObjectLine = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementUMLSDObjectRO) {
            isObjectLine |= ((IPMPlanElementUMLSDObjectRO)planElement).getOutlineFigureRO() == figure;
        }
        return isObjectLine;
    }

    private static boolean isLifeLine(IPMFigureRO figure) {
        boolean isLifeLine = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementUMLSDObjectRO) {
            isLifeLine |= ((IPMPlanElementUMLSDObjectRO)planElement).getLifeLineRO() == figure;
        }
        return isLifeLine;
    }

    private static boolean isBox(IPMFigureRO figure) {
        boolean isBox = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementUMLSDActivationBoxRO) {
            isBox = true;
        } else if (planElement instanceof IPMPlanElementUMLSDObjectRO && figure == ((IPMPlanElementUMLSDObjectRO)planElement).getOutlineFigureRO()) {
            isBox = true;
        }
        return isBox;
    }

    private static boolean isLifeLineLinkable(IPMFigureRO figure) {
        boolean isLifeLineLinkable = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isLifeLineLinkable |= planElement instanceof IPMPlanElementUMLSDObjectRW;
        isLifeLineLinkable |= planElement instanceof IPMPlanElementUMLSDActivationBoxRO;
        return isLifeLineLinkable |= planElement instanceof IPMPlanElementUMLSDCallRO;
    }

    private static boolean isBoxLinkable(IPMFigureRO figure) {
        boolean isBoxLinkable = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isBoxLinkable |= planElement instanceof IPMPlanElementUMLSDCallRO;
        return isBoxLinkable |= planElement instanceof IPMPlanElementUMLSDActivationBoxRO;
    }

    private static boolean isUpperAnchor(IAnchoringSourcePoint source) {
        Point point = source.getAnchoringSourcePosition();
        Point upper = source.getAnchoringFigure().getPointListRO().getPoints().get(0);
        Point lower = source.getAnchoringFigure().getPointListRO().getPoints().get(1);
        if (upper.y > lower.y) {
            upper = lower;
        }
        return point.equalsPoint(upper);
    }
}

