/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigureLineShape;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.ACInvalidAction;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDModifyingStorageAccessRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateFMCBDModifyingStorageAccess
extends PredeterminedLengthTransaction {
    private static final ILogger logger = Logger.getLogger(TACreateFMCBDModifyingStorageAccess.class);
    private static final int STEPS = 4;
    private Points linePoints;
    private int[] lineForces;
    private ILineAppearanceRO lineAppearance;
    private ILineMarkerAppearanceRO lineMarkerAppearanceNone;
    private ILineMarkerAppearanceRO lineMarkerAppearanceArc;
    private double centerWidth = 10.0;
    private double endWidth = 5.0;
    private IPMPlanElementFMCBDModifyingStorageAccessRO createdModifyingArc;

    public TACreateFMCBDModifyingStorageAccess(IPMPlanRO plan, ActionParameters actionParameters, Points linePoints, ILineAppearanceRO lineAppearance, ILineMarkerAppearanceRO lineMarkerAppearanceNone, ILineMarkerAppearanceRO lineMarkerAppearanceArc, double centerWidth, double endWidth) {
        super(4, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "lineAppearance is null";
        assert (lineMarkerAppearanceNone != null) : "lineMarkerAppearanceNone is null";
        assert (lineMarkerAppearanceArc != null) : "lineMarkerAppearanceArc is null";
        this.transactionAssertion(linePoints.size() == 2, "only two points allowed for modifying storage access");
        try {
            this.linePoints = linePoints;
            this.lineForces = LineHelper.createAlternatingLineForcesOpen((Points)linePoints);
            this.lineAppearance = lineAppearance;
            this.lineMarkerAppearanceNone = lineMarkerAppearanceNone;
            this.lineMarkerAppearanceArc = lineMarkerAppearanceArc;
            this.centerWidth = centerWidth;
            this.endWidth = endWidth;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createArcAction();
            }
            case 1: {
                this.createdModifyingArc = (IPMPlanElementFMCBDModifyingStorageAccessRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createGeometryLineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
            case 2: {
                return this.createEdge1Action((ACCreatePlanElement)previousActions.get(n - 2));
            }
            case 3: {
                return this.createEdge2Action((ACCreatePlanElement)previousActions.get(n - 3));
            }
        }
        return null;
    }

    private Action createArcAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "fmc.bd.modifyingstorageaccess");
    }

    private Action createGeometryLineAction(ACCreatePlanElement createElementAction) {
        LineMarkerAppearance startMarkerAppearance = new LineMarkerAppearance();
        LineMarkerAppearance endMarkerAppearance = new LineMarkerAppearance();
        LineAppearance geometryLineAppearance = new LineAppearance();
        geometryLineAppearance.setLineStyle(LineStyle.NONE);
        return new ACCreateFigureLineShape(this.getActionContext(), "geometryLine", createElementAction.getCreatedPlanElement(), this.linePoints, this.lineForces, (ILineAppearanceRO)geometryLineAppearance, (ILineMarkerAppearanceRO)startMarkerAppearance, (ILineMarkerAppearanceRO)endMarkerAppearance, false);
    }

    private Action createEdge1Action(ACCreatePlanElement createElementAction) {
        try {
            Points edge = LineHelper.createModifyingEdge((Points)this.linePoints, (double)(this.centerWidth / 2.0), (double)(this.endWidth / 2.0));
            int[] forces = new int[]{1, 1};
            LineAppearance edgeAppearance = new LineAppearance(this.lineAppearance);
            edgeAppearance.setCornerRadiusInfinity();
            return new ACCreateFigureLineShape(this.getActionContext(), "edge1", createElementAction.getCreatedPlanElement(), edge, forces, (ILineAppearanceRO)edgeAppearance, this.lineMarkerAppearanceNone, this.lineMarkerAppearanceArc, false);
        }
        catch (EXTransactionNotValidException e) {
            logger.warn("create modifying storage access edge 1 action", (Throwable)e);
            return new ACInvalidAction(this.getActionContext());
        }
    }

    private Action createEdge2Action(ACCreatePlanElement createElementAction) {
        try {
            Points linePointsSwapped = new Points();
            linePointsSwapped.add(this.linePoints.get(1));
            linePointsSwapped.add(this.linePoints.get(0));
            Points edge = LineHelper.createModifyingEdge((Points)linePointsSwapped, (double)(this.centerWidth / 2.0), (double)(this.endWidth / 2.0));
            int[] forces = new int[]{1, 1};
            LineAppearance edgeAppearance = new LineAppearance(this.lineAppearance);
            edgeAppearance.setCornerRadiusInfinity();
            return new ACCreateFigureLineShape(this.getActionContext(), "edge2", createElementAction.getCreatedPlanElement(), edge, forces, (ILineAppearanceRO)edgeAppearance, this.lineMarkerAppearanceNone, this.lineMarkerAppearanceArc, false);
        }
        catch (EXTransactionNotValidException e) {
            logger.warn("create modifying storage access edge 2 action", (Throwable)e);
            return new ACInvalidAction(this.getActionContext());
        }
    }

    public String toString() {
        return "TACreateFMCBDModifyingStorageAccess (Geometry " + this.linePoints + " centerWidth " + this.centerWidth + " endWidth " + this.endWidth + ")";
    }

    public IPMPlanElementFMCBDModifyingStorageAccessRO getCreatedModifyingArc() {
        return this.createdModifyingArc;
    }
}

