/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.implementation;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithLineShapeOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDModifyingStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readwrite.IPMPlanElementFMCBDModifyingStorageAccessRW;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigureLineShape;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PMPoint;
import com.arcway.planagent.planmodel.implementation.PMPointList;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementFMCBDModifyingStorageAccess
extends PMPlanElementWithLineShapeOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementFMCBDModifyingStorageAccessRO,
IPMPlanElementFMCBDModifyingStorageAccessRW {
    public static final String XML_TYPE = "fmc.bd.modifyingstorageaccess";
    public static final String XML_FIGURE_EDGE1_ROLE = "edge1";
    public static final String XML_FIGURE_EDGE2_ROLE = "edge2";
    public static final String XML_FIGURE_GEOMETRYLINE_ROLE = "geometryLine";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";
    private static final String DEFAULT_NAME = "Modifying Storage Access";
    public static final double DEFAULT_END_WIDTH = 5.0;
    public static final double DEFAULT_CENTER_WIDTH = 10.0;
    private final double endWidth = 5.0;
    private final double centerWidth = 10.0;
    private final ITransactionValidator transactionValidator = new ForceValidFiguresTransactionValidator(this){

        protected boolean isPlanObjectOk(IPMPlanObjectRO planObject) {
            boolean isPlanObjectOk = super.isPlanObjectOk(planObject);
            return isPlanObjectOk;
        }
    };

    @Deprecated
    public PMPlanElementFMCBDModifyingStorageAccess(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    @Deprecated
    public PMPlanElementFMCBDModifyingStorageAccess(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    protected PMPlanElementFMCBDModifyingStorageAccess(PMPlan plan) {
        super(plan.getPlanModelMgr(), plan);
        this.setType(XML_TYPE);
        this.setup();
    }

    private void setup() {
        super.setName(DEFAULT_NAME);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    protected IPMPlanObjectRO getProjectionAreaDefiningPlanObject() {
        return this.getGeometryLine();
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    public boolean isBendable(PMFigure figure) {
        assert (this.getFigureIndex(figure) >= 0);
        if (figure.getRole().equals("outline") || figure.getRole().equals(XML_FIGURE_GEOMETRYLINE_ROLE)) {
            return true;
        }
        return super.isBendable(figure);
    }

    public IAnchoringSource getRootSource(PMPoint point) {
        PMPoint rootSource = null;
        assert (point != null) : "point is NULL.";
        if (this.getEdge1Figure() != null && this.getEdge2Figure() != null) {
            PMPointList edge1PointList = this.getEdge1Figure().getPointList();
            PMPointList edge2PointList = this.getEdge2Figure().getPointList();
            PMPointList geoPointList = this.getGeometryLine().getPointList();
            assert (edge1PointList != null) : "edgePoint1List is null";
            assert (edge1PointList.getPointCount() > 0) : "edgePoint1List is empty";
            assert (edge2PointList != null) : "edgePoint2List is null";
            assert (edge2PointList.getPointCount() > 0) : "edgePoint2List is empty";
            assert (geoPointList != null) : "geoPointList is null";
            assert (geoPointList.getPointCount() > 0) : "geoPointList is empty";
            PMPoint edge1Start = edge1PointList.getPoint(0);
            PMPoint edge1End = edge1PointList.getPoint(edge1PointList.getPointCount() - 1);
            PMPoint edge2Start = edge2PointList.getPoint(0);
            PMPoint edge2End = edge2PointList.getPoint(edge2PointList.getPointCount() - 1);
            if (point == edge1Start || point == edge1End || point == edge2Start || point == edge2End) {
                double distanceToEnd;
                PMPoint geometryStart = geoPointList.getPoint(0);
                PMPoint geometryEnd = geoPointList.getPoint(geoPointList.getPointCount() - 1);
                double distanceToStart = new GeoVector(point.getPosition(), geometryStart.getPosition()).abs();
                rootSource = distanceToStart <= (distanceToEnd = new GeoVector(point.getPosition(), geometryEnd.getPosition()).abs()) ? geometryStart : geometryEnd;
            }
        }
        return rootSource;
    }

    public Collection<IAnchoringSource> getChildSources(PMPoint rootSource) {
        ArrayList<IAnchoringSource> childSources = new ArrayList<IAnchoringSource>(2);
        assert (rootSource != null) : "rootSource is NULL.";
        PMPointList geoPointList = this.getGeometryLine().getPointList();
        assert (geoPointList != null) : "geoPointList is null";
        assert (geoPointList.getPointCount() > 0) : "geoPointList is empty";
        PMPoint geometryStart = geoPointList.getPoint(0);
        PMPoint geometryEnd = geoPointList.getPoint(geoPointList.getPointCount() - 1);
        if ((rootSource == geometryStart || rootSource == geometryEnd) && this.getEdge1Figure() != null && this.getEdge2Figure() != null) {
            PMPointList edge1PointList = this.getEdge1Figure().getPointList();
            PMPointList edge2PointList = this.getEdge2Figure().getPointList();
            assert (edge1PointList != null) : "edgePoint1List is null";
            assert (edge1PointList.getPointCount() > 0) : "edgePoint1List is empty";
            assert (edge2PointList != null) : "edgePoint2List is null";
            assert (edge2PointList.getPointCount() > 0) : "edgePoint2List is empty";
            PMPoint edge1Start = edge1PointList.getPoint(0);
            PMPoint edge1End = edge1PointList.getPoint(edge1PointList.getPointCount() - 1);
            PMPoint edge2Start = edge2PointList.getPoint(0);
            PMPoint edge2End = edge2PointList.getPoint(edge2PointList.getPointCount() - 1);
            double distanceToStart1 = new GeoVector(rootSource.getPosition(), edge1Start.getPosition()).abs();
            double distanceToEnd1 = new GeoVector(rootSource.getPosition(), edge1End.getPosition()).abs();
            double distanceToStart2 = new GeoVector(rootSource.getPosition(), edge2Start.getPosition()).abs();
            double distanceToEnd2 = new GeoVector(rootSource.getPosition(), edge2End.getPosition()).abs();
            if (distanceToStart1 <= distanceToEnd1) {
                childSources.add((IAnchoringSource)edge1Start);
            } else {
                childSources.add((IAnchoringSource)edge1End);
            }
            if (distanceToStart2 <= distanceToEnd2) {
                childSources.add((IAnchoringSource)edge2Start);
            } else {
                childSources.add((IAnchoringSource)edge2End);
            }
        }
        return childSources;
    }

    public PMFigureLineShape getEdge1Figure() {
        List edges = this.getFiguresRO(XML_FIGURE_EDGE1_ROLE);
        if (edges.size() == 0) {
            return null;
        }
        assert (edges.get(0) instanceof PMFigureLineShape) : "edges.get(0) returned an object that is not of type PMFigureLineShape.";
        assert (edges.size() == 1) : "more than one edge found";
        return (PMFigureLineShape)edges.get(0);
    }

    @Override
    public IPMFigureLineShapeRO getEdge1FigureRO() {
        return this.getEdge1Figure();
    }

    @Override
    public IPMFigureLineShapeRW getEdge1FigureRW() {
        return this.getEdge1Figure();
    }

    public PMFigureLineShape getEdge2Figure() {
        List edges = this.getFiguresRO(XML_FIGURE_EDGE2_ROLE);
        if (edges.size() == 0) {
            return null;
        }
        assert (edges.get(0) instanceof PMFigureLineShape) : "edges.get(0) returned an object that is not of type PMFigureLineShape.";
        assert (edges.size() == 1) : "more than one edge found";
        return (PMFigureLineShape)edges.get(0);
    }

    @Override
    public IPMFigureLineShapeRO getEdge2FigureRO() {
        return this.getEdge2Figure();
    }

    @Override
    public IPMFigureLineShapeRW getEdge2FigureRW() {
        return this.getEdge2Figure();
    }

    public PMFigureLineShape getGeometryLine() {
        List edges = this.getFiguresRO(XML_FIGURE_GEOMETRYLINE_ROLE);
        if (edges.size() == 0) {
            return null;
        }
        assert (edges.get(0) instanceof PMFigureLineShape) : "edges.get(0) returned an object that is not of type PMFigureLineShape.";
        assert (edges.size() == 1) : "more than one edge found";
        return (PMFigureLineShape)edges.get(0);
    }

    @Override
    public IPMFigureLineShapeRO getGeometryLineRO() {
        return this.getGeometryLine();
    }

    @Override
    public IPMFigureLineShapeRW getGeometryLineRW() {
        return this.getGeometryLine();
    }

    public PMFigure getOutlineFigure() {
        return this.getGeometryLine();
    }

    @Override
    public double getEndWidth() {
        return 5.0;
    }

    @Override
    public double getCenterWidth() {
        return 10.0;
    }

    public ITransactionValidator getTransactionValidator() {
        return this.transactionValidator;
    }

    public Collection<PMFigureLineShape> getEditFigures() {
        return Collections.singleton(this.getGeometryLine());
    }

    protected PMFigure getNestingOutlineFigure() {
        return this.getGeometryLine();
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getGeometryLineRW();
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = this.getNestingInlineFigure();
        assert (outlineFigure != null) : "outlineFigure is NULL.";
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "it was not exactly one reference found";
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    protected PMFigure getNestingInlineFigure() {
        return this.getGeometryLine();
    }

    public Collection<? extends IPMFigureLineShapeRO> getLineShapeFiguresRO() {
        ArrayList<PMFigureLineShape> lineShapeFigures = new ArrayList<PMFigureLineShape>();
        PMFigureLineShape edge1Figure = this.getEdge1Figure();
        PMFigureLineShape edge2Figure = this.getEdge2Figure();
        if (edge1Figure != null) {
            lineShapeFigures.add(this.getEdge1Figure());
        }
        if (edge2Figure != null) {
            lineShapeFigures.add(this.getEdge2Figure());
        }
        return Collections.singleton(this.getGeometryLine());
    }
}

