/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.check;

import com.arcway.planagent.planmodel.access.readonly.IPMAnchorRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMPlanElementDotsCommentRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDAgentRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDChannelRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDModifyingStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStorageAccessRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStorageRO;
import com.arcway.planagent.planmodel.fmc.bd.access.readonly.IPMPlanElementFMCBDStructureVarianceRO;

public class BDValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        anchoringIsPossible |= BDValidityMatrix.isEdge(source.getAnchoringFigure()) && BDValidityMatrix.isNode(destination.getAnchoringFigure());
        return anchoringIsPossible |= BDValidityMatrix.isDotsComment(sourceFigure) && (BDValidityMatrix.isNode(destinationFigure) || BDValidityMatrix.isEdge(destinationFigure));
    }

    public static boolean isPointToPointAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationPoint destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        if (source instanceof IPMPointRO && destination instanceof IPMAnchorRO) {
            IPMPointRO sourcePoint = (IPMPointRO)source;
            IPMAnchorRO iPMAnchorRO = (IPMAnchorRO)destination;
        }
        return anchoringIsPossible |= BDValidityMatrix.isDotsComment(sourceFigure) && (BDValidityMatrix.isNode(destinationFigure) || BDValidityMatrix.isEdge(destinationFigure));
    }

    public static boolean isTouchValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        boolean touchIsValid = false;
        touchIsValid |= BDValidityMatrix.isDirectedTouchValid(figure1, figure2);
        return touchIsValid |= BDValidityMatrix.isDirectedTouchValid(figure2, figure1);
    }

    private static boolean isDirectedTouchValid(IPMFigureRO sourceFigure, IPMFigureRO destinationFigure) {
        boolean touchIsValid = true;
        IPMPlanElementRO edgePlanElement = sourceFigure.getPlanElementRO();
        IPMPlanElementRO nodePlanElement = destinationFigure.getPlanElementRO();
        touchIsValid = BDValidityMatrix.isEdge(sourceFigure) && BDValidityMatrix.isNode(destinationFigure) ? (touchIsValid &= !(edgePlanElement instanceof IPMPlanElementFMCBDModifyingStorageAccessRO) || !(nodePlanElement instanceof IPMPlanElementFMCBDChannelRO)) : (BDValidityMatrix.isDotsComment(sourceFigure) ? (touchIsValid &= BDValidityMatrix.isEdge(destinationFigure) || BDValidityMatrix.isNode(destinationFigure)) : (touchIsValid &= false));
        return touchIsValid;
    }

    public static boolean isCombinationValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        IPMPlanElementRO planElement1 = figure1.getPlanElementRO();
        IPMPlanElementRO planElement2 = figure2.getPlanElementRO();
        if (!(planElement1 instanceof IPMPlanElementFMCBDAgentRO) && !(planElement2 instanceof IPMPlanElementFMCBDAgentRO)) {
            return false;
        }
        return !(planElement1 instanceof IPMPlanElementFMCBDAgentRO) || !(planElement2 instanceof IPMPlanElementFMCBDAgentRO);
    }

    private static boolean isEdge(IPMFigureRO figure) {
        boolean isEdge = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isEdge |= planElement instanceof IPMPlanElementFMCBDModifyingStorageAccessRO;
        return isEdge |= planElement instanceof IPMPlanElementFMCBDStorageAccessRO;
    }

    private static boolean isNode(IPMFigureRO figure) {
        boolean isNode = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        isNode |= planElement instanceof IPMPlanElementFMCBDAgentRO;
        isNode |= planElement instanceof IPMPlanElementFMCBDStorageRO;
        isNode |= planElement instanceof IPMPlanElementFMCBDStructureVarianceRO;
        return isNode |= BDValidityMatrix.isChannelNode(figure);
    }

    private static boolean isChannelNode(IPMFigureRO figure) {
        boolean isChannelNode = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementFMCBDChannelRO) {
            IPMPlanElementFMCBDChannelRO channel = (IPMPlanElementFMCBDChannelRO)planElement;
            isChannelNode |= channel.getOutlineFigureRO() == figure;
        }
        return isChannelNode;
    }

    private static boolean isChannelPointAnchorableToItsOwnChannel(IAnchoringSourcePoint source) {
        IPMPlanElementRO planElement;
        boolean isAnchorablePoint = false;
        if (source instanceof IPMPointRO && (planElement = source.getAnchoringFigure().getPlanElementRO()) instanceof IPMPlanElementFMCBDChannelRO) {
            IPMPlanElementFMCBDChannelRO channel = (IPMPlanElementFMCBDChannelRO)planElement;
            IPMPointRO point = (IPMPointRO)source;
            IPMPointListRO pointList = point.getPointListRO();
            IPMPointRO startPoint = pointList.getPointRO(0);
            IPMPointRO endPoint = pointList.getPointRO(pointList.getPointCount() - 1);
            Object otherPoint = point == startPoint && point != endPoint ? endPoint : (point == endPoint && point != startPoint ? startPoint : null);
            if (otherPoint != null) {
                IPMAnchoringPointRO anchoring = otherPoint.getAnchoringRO();
                isAnchorablePoint = anchoring == null ? (isAnchorablePoint |= true) : (isAnchorablePoint |= anchoring.getAnchoringDestination().getAnchoringFigure() != channel.getOutlineFigureRO());
            }
        }
        return isAnchorablePoint;
    }

    private static boolean isDotsComment(IPMFigureRO figure) {
        boolean isComment = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isComment |= planElement instanceof IPMPlanElementDotsCommentRO;
    }
}

