/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.fmc.bd.appearance;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearance;
import com.arcway.planagent.planmodel.fmc.bd.appearance.IFMCBDRequestSymbolAppearanceRO;

public class FMCBDRequestSymbolAppearance
implements IFMCBDRequestSymbolAppearance {
    private static final ILogger logger = Logger.getLogger(FMCBDRequestSymbolAppearance.class);
    private Color color = new Color(0, 0, 0);
    private double size = 2.5;
    private Direction direction = DEFAULT_DIRECTION;

    public FMCBDRequestSymbolAppearance() {
        if (logger.isDebugEnabled()) {
            logger.trace("RequestSymbolAppearance() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("RequestSymbolAppearance() - end");
        }
    }

    public FMCBDRequestSymbolAppearance(IFMCBDRequestSymbolAppearanceRO source) {
        if (logger.isDebugEnabled()) {
            logger.trace("RequestSymbolAppearance(IRequestSymbolAppearance source = " + source + ") - start");
        }
        assert (source != null) : "source object is NULL";
        this.setAppearanceFrom(source);
        if (logger.isDebugEnabled()) {
            logger.trace("RequestSymbolAppearance(IRequestSymbolAppearance) - end");
        }
    }

    @Override
    public void setColor(Color color) {
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color color = " + color + ") - start");
        }
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color) - end");
        }
    }

    @Override
    public void setSize(double size) {
        if (logger.isDebugEnabled()) {
            logger.trace("setSize(double size = " + size + ") - start");
        }
        assert (size >= 0.0) : "size is smaller than 0";
        this.size = size;
        if (logger.isDebugEnabled()) {
            logger.trace("setSize(double) - end");
        }
    }

    @Override
    public void setDirection(Direction direction) {
        if (logger.isDebugEnabled()) {
            logger.trace("setDirection(Color direction = " + direction + ") - start");
        }
        assert (direction != null) : "direction is NULL.";
        this.direction = direction;
        if (logger.isDebugEnabled()) {
            logger.trace("setDirection(direction) - end");
        }
    }

    @Override
    public Color getColor() {
        if (logger.isDebugEnabled()) {
            logger.trace("getColor() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getColor() - end - return value = " + this.color);
        }
        return new Color(this.color);
    }

    @Override
    public double getSize() {
        if (logger.isDebugEnabled()) {
            logger.trace("getSize() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getSize() - end - return value = " + this.size);
        }
        return this.size;
    }

    @Override
    public Direction getDirection() {
        if (logger.isDebugEnabled()) {
            logger.trace("getDirection() - start");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("getDirection() - end - return value = " + this.direction);
        }
        return this.direction;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IFMCBDRequestSymbolAppearanceRO)) {
            return;
        }
        IFMCBDRequestSymbolAppearanceRO rs = (IFMCBDRequestSymbolAppearanceRO)appearance;
        this.setColor(rs.getColor());
        this.setSize(rs.getSize());
        this.setDirection(rs.getDirection());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new FMCBDRequestSymbolAppearance(this);
    }
}

