/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.reactions.ExtendedEven;
import com.arcway.planagent.planmodel.reactions.OverlappedEven;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ResizeSupplementFittingStraightLineRouter
extends AbstractResizeSupplementRouter {
    private final IPMGraphicalSupplementRW graSuppl;

    public ResizeSupplementFittingStraightLineRouter(IPMGraphicalSupplementRW graSuppl) {
        assert (graSuppl != null) : "ref to grapSuppl is null";
        this.graSuppl = graSuppl;
    }

    public ActionIterator calculateReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext context) {
        IPMGraphicalSupplementRW planObjectToReroute = this.graSuppl;
        PredeterminedActionIterator reactionIterator = new PredeterminedActionIterator();
        ResizeSupplementFittingStraightLineRouter.resizePlanObjectFittingStraightLines(figure, (IPMPlanObjectRW)planObjectToReroute, oldGeometry, context, reactionIterator);
        return reactionIterator;
    }

    public static void resizePlanObjectFittingStraightLines(IPMFigureRW figure, IPMPlanObjectRW planObjectToReroute, List<PositionAndPoint> oldGeometry, ActionContext context, PredeterminedActionIterator reactionIterator) {
        List<ExtendedEven> extendedEvensOfGraSuppl = ResizeSupplementFittingStraightLineRouter.getAllEvensOfGraphicalSupplement(planObjectToReroute);
        ArrayList<OverlappedEven> overlappedEvens = new ArrayList<OverlappedEven>();
        if (figure.getPointListRW().getPointCount() == ResizeSupplementFittingStraightLineRouter.getPointCount(oldGeometry) && ResizeSupplementFittingStraightLineRouter.getPointCount(oldGeometry) == oldGeometry.size()) {
            List<ExtendedEven> evensOfFigure = ResizeSupplementFittingStraightLineRouter.getAllEvensOfFigure(figure, oldGeometry);
            for (ExtendedEven evenGraSuppl : extendedEvensOfGraSuppl) {
                OverlappedEven overlappedEven = null;
                for (ExtendedEven evenFigure : evensOfFigure) {
                    boolean isUorLFigure = false;
                    if (!evenFigure.equalsStraightLine((StraightLine)evenGraSuppl)) continue;
                    if (!isUorLFigure) {
                        overlappedEven = new OverlappedEven((StraightLine)evenFigure, evenFigure.getLine(), evenGraSuppl.getLine());
                        isUorLFigure = true;
                        continue;
                    }
                    assert (overlappedEven != null) : "overlapped even is null";
                    overlappedEven.addLineOfFigure(evenFigure.getLine());
                }
                if (overlappedEven == null) continue;
                overlappedEvens.add(overlappedEven);
            }
            List<OverlappedEven> changedOverlappedEvens = ResizeSupplementFittingStraightLineRouter.findAllChangedLines(overlappedEvens);
            for (OverlappedEven changedOverlappedEven : changedOverlappedEvens) {
                boolean removeSourceAnchorings = false;
                Action a = ActionFactory.createACMoveLine((ActionContext)context, (IPMLineRW)changedOverlappedEven.getLineOfGraSuppl(), (GeoVector)ResizeSupplementFittingStraightLineRouter.calculateVectorOfMoveLine(changedOverlappedEven, figure, extendedEvensOfGraSuppl), (boolean)removeSourceAnchorings);
                reactionIterator.addAction(a);
            }
        }
    }

    private static int getPointCount(List<PositionAndPoint> geometry) {
        assert (geometry != null) : "ref to geometry is null";
        int size = 0;
        for (PositionAndPoint p : geometry) {
            if (p.getPoint() == null) continue;
            ++size;
        }
        return size;
    }

    private static Point getPosition(IPMPointRW point, List<PositionAndPoint> geometry) {
        Point position = null;
        for (PositionAndPoint p : geometry) {
            if (p.getPoint() != point) continue;
            position = p.getPosition();
        }
        return position;
    }

    private static List<ExtendedEven> getAllEvensOfGraphicalSupplement(IPMPlanObjectRW graphSuppl) {
        assert (graphSuppl != null) : "ref to graphSuppl is null";
        ArrayList<ExtendedEven> extendedEvens = new ArrayList<ExtendedEven>();
        int k = 0;
        while (k < graphSuppl.getPointListRW().getLineCount()) {
            IPMLineRW line = graphSuppl.getPointListRW().getLineRW(k);
            ExtendedEven e = ResizeSupplementFittingStraightLineRouter.getExtendedEven(line);
            extendedEvens.add(e);
            ++k;
        }
        return extendedEvens;
    }

    private static List<OverlappedEven> findAllChangedLines(List<OverlappedEven> overlappedEvens) {
        ArrayList<OverlappedEven> changedOverlappedEvens = new ArrayList<OverlappedEven>();
        assert (overlappedEvens != null) : "ref to overlappedEvens is null";
        for (OverlappedEven overlappedEven : overlappedEvens) {
            boolean isChanged = false;
            for (IPMLineRW lineOfFigure : overlappedEven.getLinesOfFigure()) {
                if (!ResizeSupplementFittingStraightLineRouter.checkLineIsEvenable(lineOfFigure)) continue;
                StraightLine evenPostOfFigure = ResizeSupplementFittingStraightLineRouter.getEven(lineOfFigure);
                if (overlappedEven.getEven().equalsStraightLine(evenPostOfFigure)) continue;
                if (!isChanged) {
                    changedOverlappedEvens.add(overlappedEven);
                    isChanged = true;
                    ArrayList<ExtendedEven> evensPostOfFigure = new ArrayList<ExtendedEven>();
                    evensPostOfFigure.add(ResizeSupplementFittingStraightLineRouter.getExtendedEven(lineOfFigure));
                    overlappedEven.setEvensPostOfFigure(evensPostOfFigure);
                    continue;
                }
                overlappedEven.getEvensPostOfFigure().add(ResizeSupplementFittingStraightLineRouter.getExtendedEven(lineOfFigure));
            }
        }
        return changedOverlappedEvens;
    }

    private static GeoVector calculateVectorOfMoveLine(OverlappedEven overlappedEven, IPMFigureRW figure, List<ExtendedEven> oldEvensOfSupplement) {
        GeoVector vector = null;
        StraightLine sourceEven = overlappedEven.getEven();
        List targetsEven = overlappedEven.getEvensPostOfFigure();
        if (targetsEven.size() <= 1) {
            assert (targetsEven.size() == 1) : "there should be exactly one targetEven in the list";
            Iterator i = targetsEven.iterator();
            StraightLine ex = (StraightLine)i.next();
            if (sourceEven.isParallel(ex)) {
                GeoVector sourceDirectionVector = ResizeSupplementFittingStraightLineRouter.getVector(sourceEven, ex);
                List<Object> evensWithSameAngle = sourceDirectionVector.abs() < 1.0E-10 ? Collections.emptyList() : ResizeSupplementFittingStraightLineRouter.getAllEvensWithSameAngle(figure, Geo.getNormalizedAngle((double)sourceDirectionVector.angle()), sourceEven);
                int k = 0;
                while (k < oldEvensOfSupplement.size()) {
                    Iterator<Object> sameAngleEvens = evensWithSameAngle.iterator();
                    while (sameAngleEvens.hasNext()) {
                        StraightLine sameAngleEven = (StraightLine)sameAngleEvens.next();
                        if (!sameAngleEven.equalsStraightLine((StraightLine)oldEvensOfSupplement.get(k))) continue;
                        sameAngleEvens.remove();
                    }
                    ++k;
                }
                if (evensWithSameAngle.size() == 0) {
                    evensWithSameAngle.add(overlappedEven.getEven());
                }
                double distance = 0.0;
                boolean firstTime = false;
                StraightLine targetEven = null;
                for (StraightLine straightLine : evensWithSameAngle) {
                    if (!firstTime) {
                        distance = ResizeSupplementFittingStraightLineRouter.getDistance(sourceEven, straightLine);
                        targetEven = straightLine;
                        firstTime = true;
                    }
                    if (!(distance >= ResizeSupplementFittingStraightLineRouter.getDistance(sourceEven, straightLine))) continue;
                    distance = ResizeSupplementFittingStraightLineRouter.getDistance(sourceEven, straightLine);
                    targetEven = straightLine;
                }
                assert (targetEven != null) : "there should be at least one targetEven";
                vector = ResizeSupplementFittingStraightLineRouter.getVector(sourceEven, targetEven);
            }
        }
        if (vector == null) {
            vector = GeoVector.NULL;
        }
        return vector;
    }

    private static List<ExtendedEven> getAllEvensOfFigure(IPMFigureRW figure, List<PositionAndPoint> oldGeometry) {
        ArrayList<ExtendedEven> evensFigure = new ArrayList<ExtendedEven>();
        int k = 0;
        while (k < figure.getPointListRW().getLineCount()) {
            ExtendedEven evenFigure;
            IPMLineRW line = figure.getPointListRW().getLineRW(k);
            if (Geo.equals((double)ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).x, (double)ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint2ndRW(), oldGeometry).x) && Geo.equals((double)ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).y, (double)ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint2ndRW(), oldGeometry).y)) {
                if (line.getForce() != 1) {
                    Point calculatedEvenPoint;
                    if (line.getForce() == 2) {
                        calculatedEvenPoint = new Point(ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).x + 1.0, ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).y);
                        evenFigure = new ExtendedEven(ResizeSupplementFittingStraightLineRouter.getPosition(line.getPoint1stRW(), oldGeometry), calculatedEvenPoint, line);
                        evensFigure.add(evenFigure);
                    } else {
                        assert (line.getForce() == 3) : "line force must be FORCE_V";
                        calculatedEvenPoint = new Point(ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).x, ResizeSupplementFittingStraightLineRouter.getPosition((IPMPointRW)line.getPoint1stRW(), oldGeometry).y + 1.0);
                        evenFigure = new ExtendedEven(ResizeSupplementFittingStraightLineRouter.getPosition(line.getPoint1stRW(), oldGeometry), calculatedEvenPoint, line);
                        evensFigure.add(evenFigure);
                    }
                }
            } else {
                evenFigure = new ExtendedEven(ResizeSupplementFittingStraightLineRouter.getPosition(line.getPoint1stRW(), oldGeometry), ResizeSupplementFittingStraightLineRouter.getPosition(line.getPoint2ndRW(), oldGeometry), line);
                evensFigure.add(evenFigure);
            }
            ++k;
        }
        assert (evensFigure.size() > 0) : "figure should have lines and that's why more than 0 evens";
        return evensFigure;
    }

    private static List<StraightLine> getAllEvensWithSameAngle(IPMFigureRW figure, double directionAngle, StraightLine sourceEven) {
        assert (figure != null) : "ref to graphSuppl is null";
        ArrayList<StraightLine> allEvensWithSameAngle = new ArrayList<StraightLine>();
        int k = 0;
        while (k < figure.getPointListRW().getLineCount()) {
            StraightLine g;
            IPMLineRW line = figure.getPointListRW().getLineRW(k);
            if (ResizeSupplementFittingStraightLineRouter.checkLineIsEvenable(line) && sourceEven.isParallel(g = ResizeSupplementFittingStraightLineRouter.getEven(line))) {
                if (ResizeSupplementFittingStraightLineRouter.getDistance(sourceEven, g) < 1.0E-10) {
                    allEvensWithSameAngle.add(g);
                } else {
                    GeoVector p = ResizeSupplementFittingStraightLineRouter.getVector(sourceEven, g);
                    if (Geo.equalsNormalizedAngles((double)directionAngle, (double)Geo.getNormalizedAngle((double)p.angle()))) {
                        allEvensWithSameAngle.add(g);
                    }
                }
            }
            ++k;
        }
        return allEvensWithSameAngle;
    }

    private static double getDistance(StraightLine sourceEven, StraightLine targetEven) {
        assert (sourceEven.isParallel(targetEven)) : "even should be parallel if they have the same angle";
        StraightLine perpendicular = sourceEven.getPerpendicular(sourceEven.getEntryPoint());
        Point intersection = targetEven.getInterceptPoint(perpendicular);
        GeoVector vector = new GeoVector(sourceEven.getEntryPoint(), intersection);
        return vector.abs();
    }

    private static GeoVector getVector(StraightLine sourceEven, StraightLine targetEven) {
        assert (sourceEven.isParallel(targetEven)) : "even should be parallel if they have the same angle";
        StraightLine perpendicular = sourceEven.getPerpendicular(Point.getAsPoint((Point)sourceEven.getEntryPoint()));
        Point intersection = targetEven.getInterceptPoint(perpendicular);
        GeoVector vector = new GeoVector(Point.getAsPoint((Point)sourceEven.getEntryPoint()), intersection);
        return vector;
    }

    private static boolean checkLineIsEvenable(IPMLineRW line) {
        boolean isEvenable = true;
        if (Geo.equals((double)line.getPoint1stRW().getPosition().x, (double)line.getPoint2ndRW().getPosition().x) && Geo.equals((double)line.getPoint1stRW().getPosition().y, (double)line.getPoint2ndRW().getPosition().y) && line.getForce() == 1) {
            isEvenable = false;
        }
        return isEvenable;
    }

    private static StraightLine getEven(IPMLineRW line) {
        StraightLine even = null;
        if (Geo.equals((double)line.getPoint1stRW().getPosition().x, (double)line.getPoint2ndRW().getPosition().x) && Geo.equals((double)line.getPoint1stRW().getPosition().y, (double)line.getPoint2ndRW().getPosition().y)) {
            if (line.getForce() == 2) {
                Point calculatedEvenPoint = new Point(line.getPoint1stRW().getPosition().x + 1.0, line.getPoint1stRW().getPosition().y);
                even = new StraightLine(line.getPoint1stRW().getPosition(), calculatedEvenPoint);
            } else {
                assert (line.getForce() == 3) : "preconditions are not met";
                Point calculatedEvenPoint = new Point(line.getPoint1stRW().getPosition().x, line.getPoint1stRW().getPosition().y + 1.0);
                even = new StraightLine(line.getPoint1stRW().getPosition(), calculatedEvenPoint);
            }
        } else {
            even = new StraightLine(line.getPoint1stRW().getPosition(), line.getPoint2ndRW().getPosition());
        }
        return even;
    }

    private static ExtendedEven getExtendedEven(IPMLineRW line) {
        ExtendedEven even = null;
        if (Geo.equals((double)line.getPoint1stRW().getPosition().x, (double)line.getPoint2ndRW().getPosition().x) && Geo.equals((double)line.getPoint1stRW().getPosition().y, (double)line.getPoint2ndRW().getPosition().y)) {
            if (line.getForce() == 2) {
                Point calculatedEvenPoint = new Point(line.getPoint1stRW().getPosition().x + 1.0, line.getPoint1stRW().getPosition().y);
                even = new ExtendedEven(line.getPoint1stRW().getPosition(), calculatedEvenPoint, line);
            } else {
                assert (line.getForce() == 3) : "preconditions are not met";
                Point calculatedEvenPoint = new Point(line.getPoint1stRW().getPosition().x, line.getPoint1stRW().getPosition().y + 1.0);
                even = new ExtendedEven(line.getPoint1stRW().getPosition(), calculatedEvenPoint, line);
            }
        } else {
            even = new ExtendedEven(line.getPoint1stRW().getPosition(), line.getPoint2ndRW().getPosition(), line);
        }
        return even;
    }
}

