/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Arc;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Line;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Ray;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.polygon.PolygonLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationLine;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractSetPointRouter;

public class KeepHorizontalPositionOnLineRouter
extends AbstractSetPointRouter {
    public KeepHorizontalPositionOnLineRouter() {
        super(IAnchoringDestinationLine.class);
    }

    protected Point getTargetPosition(IAnchoringSourcePoint sourcePoint, IAnchoringDestination destination) {
        IAnchoringDestinationLine destinationFigure = (IAnchoringDestinationLine)destination;
        Point targetPoint = null;
        Point fromPoint = sourcePoint.getAnchoringSourceFromPoint().getAnchoringSourcePosition();
        Point toPointOld = sourcePoint.getAnchoringSourcePosition();
        if (fromPoint != null) {
            Line line = destinationFigure.getAnchoringDestinationPosition();
            Rectangle destinationBounds = line.getBounds();
            Direction direction = toPointOld.x < destinationBounds.center().x ? Direction.ANGLE_0 : Direction.ANGLE_180;
            Ray interceptRay = new Ray(toPointOld, direction);
            PolygonLine polygonLine = destinationFigure.getAnchoringDestinationPositionOnPolygon();
            if (polygonLine != null) {
                Arc endArc;
                Point point;
                Line middleLine;
                Points points = new Points(5);
                Arc startArc = polygonLine.getStartArc();
                if (startArc != null) {
                    points.addAll(interceptRay.getInterceptPoints(startArc));
                }
                if ((middleLine = polygonLine.line) != null && (point = interceptRay.getInterceptPoint(middleLine)) != null) {
                    points.add(point);
                }
                if ((endArc = polygonLine.getEndArc()) != null) {
                    points.addAll(interceptRay.getInterceptPoints(endArc));
                }
                targetPoint = points.getNearestPoint(fromPoint);
            } else {
                targetPoint = interceptRay.getInterceptPoint(line);
            }
        }
        return targetPoint;
    }

    protected boolean justElongatesForcedLines() {
        return false;
    }
}

