/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Ray;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.routing.AbstractSetPointRouter;

public class KeepHorizontalPositionOnFigureRouter
extends AbstractSetPointRouter {
    public KeepHorizontalPositionOnFigureRouter() {
        super(IAnchoringDestinationFigure.class);
    }

    protected Point getTargetPosition(IAnchoringSourcePoint sourcePoint, IAnchoringDestination destination) {
        IAnchoringDestinationFigure destinationFigure = (IAnchoringDestinationFigure)destination;
        Point targetPoint = null;
        Point fromPoint = sourcePoint.getAnchoringSourceFromPoint().getAnchoringSourcePosition();
        Point toPointOld = sourcePoint.getAnchoringSourcePosition();
        Polygon polygon = destinationFigure.getAnchoringDestinationPositionAsPolygon();
        if (polygon == null) {
            Corners corners = new Corners(destinationFigure.getAnchoringDestinationPosition(), 0.0);
            polygon = new Polygon(corners, destinationFigure.isAnchoringDestinationClosedDraw());
        }
        Rectangle destinationBounds = polygon.getBounds();
        Direction direction = toPointOld.x < destinationBounds.center().x ? Direction.ANGLE_0 : Direction.ANGLE_180;
        if (fromPoint == null) {
            StraightLine interceptEven = new StraightLine(toPointOld, direction);
            Points points = interceptEven.getIntersectionPoints(polygon);
            targetPoint = points.getNearestPoint(toPointOld);
        } else {
            Ray interceptRay = new Ray(toPointOld, direction);
            Points points = interceptRay.getIntersectionPoints(polygon);
            targetPoint = points.getNearestPoint(fromPoint);
        }
        return targetPoint;
    }

    protected boolean justElongatesForcedLines() {
        return false;
    }
}

