/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.Corners;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Ray;
import com.arcway.lib.geometry.StraightLine;
import com.arcway.lib.geometry.polygon.Polygon;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMAnchoringPointRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreate1Point;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.ACRemove1Point;
import com.arcway.planagent.planmodel.actions.ACSetLineForce;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedLengthActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.routing.ICurveLineRouter;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import java.util.ArrayList;

public class CurveLineRouterProcessor
implements ICurveLineRouter {
    ActionContext actionContext;
    IPMPointRW endPoint;
    IPMLineRW line = null;
    IAnchoringDestination destination;
    Polygon polygon;
    int lineForce = -1;
    boolean differentDestinationAtBothEdgeEnds;
    boolean isRoutingFromInsideDestinationFigure;
    boolean endPointMoved = false;

    @Override
    public ActionIterator getRoutProcessingActionIterator(IAnchoringSource src, IAnchoringDestination dest, ActionContext actionCntxt, IRoutingParameters routingPara) {
        ACMovePoint movePointAction;
        boolean removeSourceAnchorings;
        GeoVector vMove;
        if (!(src instanceof IPMPointRW)) {
            return null;
        }
        this.actionContext = actionCntxt;
        this.destination = dest;
        IAnchoringDestinationFigure destinationFigure = (IAnchoringDestinationFigure)dest;
        IAnchoringSourcePoint sourcePoint = (IAnchoringSourcePoint)src;
        this.endPoint = (IPMPointRW)sourcePoint;
        PredeterminedLengthActionIterator actionIterator = null;
        if (!(this.endPoint.getPlanObjectRW() instanceof IPMFigureRW)) {
            return null;
        }
        if (this.endPoint.getLine1stRW() == null) {
            this.line = this.endPoint.getLine2ndRW();
        } else if (this.endPoint.getLine2ndRW() == null) {
            this.line = this.endPoint.getLine1stRW();
        } else assert (false) : "endPoint is not an endpoint!";
        IPMLineRW preLine = this.line.getPoint1stRW().getLine1stRW();
        IPMLineRW postLine = this.line.getPoint2ndRW().getLine2ndRW();
        boolean onlyTwoPoints = false;
        if (!(preLine == null && postLine != null || postLine == null && preLine != null)) {
            if (preLine != null && postLine != null) {
                return null;
            }
            onlyTwoPoints = true;
        }
        Point point = this.getTargetPositionByElonguatingToFigureAndCompareDestinations(sourcePoint, dest, onlyTwoPoints);
        IPMFigureRW figure = (IPMFigureRW)this.endPoint.getPlanObjectRW();
        if (!figure.getPlanElementRW().isBendableRW(figure) || !actionCntxt.getActionParameters().getRoutingContext().isBendingActive()) {
            if (!this.differentDestinationAtBothEdgeEnds || point == null) {
                return null;
            }
            vMove = new GeoVector(sourcePoint.getAnchoringSourcePosition(), point);
            movePointAction = ActionFactory.createACMovePoint((ActionContext)actionCntxt, (IAnchoringSourcePoint)sourcePoint, (GeoVector)vMove, (boolean)(removeSourceAnchorings = false));
            if (movePointAction != null && movePointAction.getDistance().equalsGeoVector(vMove)) {
                actionIterator = new PredeterminedActionIterator(1);
                ((PredeterminedActionIterator)actionIterator).addAction((Action)movePointAction);
            }
            if (actionIterator != null) {
                return actionIterator;
            }
        }
        if (point != null && this.isRoutingFromInsideDestinationFigure && !onlyTwoPoints) {
            if (preLine == null && postLine == null) {
                return null;
            }
            IPMPointRW newEndPoint = null;
            if (this.endPoint.getLine1stRW() == null) {
                this.line = this.endPoint.getLine2ndRW();
                newEndPoint = this.line.getPoint2ndRW();
            } else if (this.endPoint.getLine2ndRW() == null) {
                this.line = this.endPoint.getLine1stRW();
                newEndPoint = this.line.getPoint1stRW();
            } else assert (false) : "endPoint is not an endpoint!";
            actionIterator = new PredeterminedActionIterator(2);
            GeoVector distance = new GeoVector(this.endPoint.getPosition(), newEndPoint.getPosition());
            ACMovePoint movePoint = ActionFactory.createACMovePoint((ActionContext)actionCntxt, (IAnchoringSourcePoint)this.endPoint, (GeoVector)distance, (boolean)false);
            this.endPointMoved |= true;
            ((PredeterminedActionIterator)actionIterator).addAction((Action)movePoint);
            ACRemove1Point removePointAction = new ACRemove1Point(actionCntxt, newEndPoint, this.line);
            ((PredeterminedActionIterator)actionIterator).addAction((Action)removePointAction);
        } else if (point == null) {
            if (this.polygon == null) {
                Corners corners = new Corners(destinationFigure.getAnchoringDestinationPosition(), 0.0);
                this.polygon = new Polygon(corners, destinationFigure.isAnchoringDestinationClosedDraw());
            }
            actionIterator = new PredeterminedLengthActionIterator(){

                public boolean hasNextAfter(int n) {
                    return n < 3;
                }

                public Action createNextAction(ArrayList<Action> previousActions, int n) {
                    return CurveLineRouterProcessor.this.createActionInCaseOfBending(n, previousActions);
                }
            };
        } else {
            if (!this.differentDestinationAtBothEdgeEnds) {
                return null;
            }
            vMove = new GeoVector(sourcePoint.getAnchoringSourcePosition(), point);
            movePointAction = ActionFactory.createACMovePoint((ActionContext)actionCntxt, (IAnchoringSourcePoint)sourcePoint, (GeoVector)vMove, (boolean)(removeSourceAnchorings = false));
            if (movePointAction != null && movePointAction.getDistance().equalsGeoVector(vMove)) {
                actionIterator = new PredeterminedActionIterator(1);
                ((PredeterminedActionIterator)actionIterator).addAction((Action)movePointAction);
            }
            if (actionIterator != null) {
                return actionIterator;
            }
        }
        return actionIterator;
    }

    private Action createActionInCaseOfBending(int n, ArrayList<Action> previousActions) {
        ACCreate1Point nextAction = null;
        switch (n) {
            case 0: {
                nextAction = new ACCreate1Point(this.actionContext, this.endPoint, this.line);
                break;
            }
            case 1: {
                ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(0);
                this.lineForce = 1;
                switch (this.line.getForce()) {
                    case 2: {
                        this.lineForce = 3;
                        break;
                    }
                    case 3: {
                        this.lineForce = 2;
                    }
                }
                nextAction = new ACSetLineForce(this.actionContext, create1PointAction.getCreatedLine(), this.lineForce);
                break;
            }
            case 2: {
                Point newPosition = this.getFigurePoint(this.destination);
                IPMPointRW startPoint = this.line.getPoint1stRW();
                ACCreate1Point create1PointAction = (ACCreate1Point)previousActions.get(0);
                if (startPoint == create1PointAction.getCreatedPoint()) {
                    startPoint = this.line.getPoint2ndRW();
                }
                Direction direction = null;
                Direction inverseDirection = null;
                if (startPoint.getPosition().equalsPoint(this.endPoint.getPosition())) {
                    if (this.line.getForce() == 2) {
                        direction = Direction.ANGLE_0;
                        inverseDirection = Direction.ANGLE_180;
                    } else if (this.line.getForce() == 3) {
                        direction = Direction.ANGLE_90;
                        inverseDirection = Direction.ANGLE_270;
                    } else assert (false) : "line is not recoverable, because there is no lineForce and startPoint.position and endPoint.position are equal!";
                } else {
                    direction = new GeoVector(startPoint.getPosition(), this.endPoint.getPosition()).getDirection();
                    inverseDirection = new GeoVector(this.endPoint.getPosition(), startPoint.getPosition()).getDirection();
                }
                Ray interceptRay = new Ray(startPoint.getPosition(), direction);
                Ray inverseInterceptRay = new Ray(this.endPoint.getPosition(), inverseDirection);
                Direction toEast = Direction.ANGLE_0;
                Direction toNorth = Direction.ANGLE_90;
                Direction toWest = Direction.ANGLE_180;
                Direction toSouth = Direction.ANGLE_270;
                Ray centerToEast = new Ray(newPosition, toEast);
                Ray centerToNorth = new Ray(newPosition, toNorth);
                Ray centerToWest = new Ray(newPosition, toWest);
                Ray centerToSouth = new Ray(newPosition, toSouth);
                Ray rayToObject = null;
                Point rayIntersection = interceptRay.getInterceptPoint(centerToEast);
                if (rayIntersection != null) {
                    rayToObject = new Ray(rayIntersection, toWest);
                } else {
                    rayIntersection = interceptRay.getInterceptPoint(centerToNorth);
                    if (rayIntersection != null) {
                        rayToObject = new Ray(rayIntersection, toSouth);
                    } else {
                        rayIntersection = interceptRay.getInterceptPoint(centerToWest);
                        if (rayIntersection != null) {
                            rayToObject = new Ray(rayIntersection, toEast);
                        } else {
                            rayIntersection = interceptRay.getInterceptPoint(centerToSouth);
                            if (rayIntersection != null) {
                                rayToObject = new Ray(rayIntersection, toNorth);
                            } else {
                                rayIntersection = inverseInterceptRay.getInterceptPoint(centerToEast);
                                if (rayIntersection != null) {
                                    rayToObject = new Ray(rayIntersection, toWest);
                                } else {
                                    rayIntersection = inverseInterceptRay.getInterceptPoint(centerToNorth);
                                    if (rayIntersection != null) {
                                        rayToObject = new Ray(rayIntersection, toSouth);
                                    } else {
                                        rayIntersection = inverseInterceptRay.getInterceptPoint(centerToWest);
                                        if (rayIntersection != null) {
                                            rayToObject = new Ray(rayIntersection, toEast);
                                        } else {
                                            rayIntersection = inverseInterceptRay.getInterceptPoint(centerToSouth);
                                            if (rayIntersection != null) {
                                                rayToObject = new Ray(rayIntersection, toNorth);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                assert (rayToObject != null) : "rayToObject is null";
                Points objectIntersections = rayToObject.getIntersectionPoints(this.polygon);
                Point targetPoint = objectIntersections.getNearestPoint(rayIntersection);
                GeoVector distance = new GeoVector(this.endPoint.getPosition(), targetPoint);
                nextAction = ActionFactory.createACMovePoint((ActionContext)this.actionContext, (IAnchoringSourcePoint)this.endPoint, (GeoVector)distance, (boolean)false);
                this.endPointMoved = this.endPointMoved || !distance.isZero();
            }
        }
        return nextAction;
    }

    protected Point getTargetPositionByElonguatingToFigureAndCompareDestinations(IAnchoringSourcePoint sourcePoint, IAnchoringDestination dest, boolean onlyTwoPoints) {
        Direction direction;
        this.differentDestinationAtBothEdgeEnds = true;
        IAnchoringDestinationFigure destinationFigure = (IAnchoringDestinationFigure)dest;
        IPMPointRW point = (IPMPointRW)sourcePoint;
        Point targetPoint = null;
        Point fromPoint = sourcePoint.getAnchoringSourceFromPoint().getAnchoringSourcePosition();
        Point toPointOld = sourcePoint.getAnchoringSourcePosition();
        Point fromPointForced = sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_HORIZONTAL ? new Point(fromPoint.x, toPointOld.y) : (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_VERTICAL ? new Point(toPointOld.x, fromPoint.y) : fromPoint);
        if (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_HORIZONTAL) {
            direction = Direction.ANGLE_0;
        } else if (sourcePoint.getForce() == IAnchoringSourcePoint.FORCE_VERTICAL) {
            direction = Direction.ANGLE_90;
        } else {
            Point destinationCenter;
            direction = new GeoVector(fromPointForced, toPointOld).getDirection();
            if (direction == null && (direction = new GeoVector(fromPointForced, destinationCenter = destinationFigure.getAnchoringDestinationPosition().getBounds().center()).getDirection()) == null) {
                direction = Direction.ANGLE_90;
            }
        }
        Polygon poly = destinationFigure.getAnchoringDestinationPositionAsPolygon();
        if (poly == null) {
            Corners corners = new Corners(destinationFigure.getAnchoringDestinationPosition(), 0.0);
            poly = new Polygon(corners, destinationFigure.isAnchoringDestinationClosedDraw());
        }
        StraightLine even = new StraightLine(fromPointForced, direction);
        this.isRoutingFromInsideDestinationFigure = poly.hasBeenHit(fromPointForced, 0.0);
        if (onlyTwoPoints) {
            this.differentDestinationAtBothEdgeEnds = this.hasTwoDifferentDestinations(point, destinationFigure);
        }
        Points points = even.getIntersectionPoints(poly);
        targetPoint = points.getNearestPoint(fromPointForced);
        return targetPoint;
    }

    private boolean hasTwoDifferentDestinations(IPMPointRW point, IAnchoringDestinationFigure destinationFigure) {
        IPMPointRW otherPoint = null;
        if (point.getLine1stRW() != null) {
            IPMLineRW centerLine = point.getLine1stRW();
            otherPoint = centerLine.getPoint1stRW();
        } else if (point.getLine2ndRW() != null) {
            IPMLineRW centerLine = point.getLine2ndRW();
            otherPoint = centerLine.getPoint2ndRW();
        }
        assert (otherPoint != null) : "other point is null";
        IPMAnchoringPointRW anchoring = otherPoint.getAnchoringRW();
        IPMFigureRO figure = null;
        if (anchoring != null) {
            figure = anchoring.getAnchoringDestination().getAnchoringFigure();
        }
        return figure == null || !figure.equals(destinationFigure);
    }

    protected Point getFigurePoint(IAnchoringDestination dest) {
        IPMPointListRO figurePointList = dest.getAnchoringFigure().getPointListRO();
        assert (figurePointList.getPointCount() == figurePointList.getLineCount());
        return figurePointList.getPoints().getBounds().center();
    }

    @Override
    public boolean endPointMoved() {
        return this.endPointMoved;
    }
}

