/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.routing;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.ConcatenatingActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouterInCaseOfMovingProcessor;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouterProcessor;
import com.arcway.planagent.planmodel.cm.routing.ICurveLineRouter;
import com.arcway.planagent.planmodel.routing.AbstractRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.routing.RouterContext;

public class CurveLineRouter
extends AbstractRouter {
    public CurveLineRouter() {
        super(IAnchoringSourcePoint.class, IAnchoringDestinationFigure.class);
    }

    public ActionIterator routeWhenClassesAreChecked(IAnchoringSource source, IAnchoringDestination destination, ActionContext actionContext, IRoutingParameters routingParameters, IRoutingManager routingManager) {
        ConcatenatingActionIterator concatenatingActionIterator;
        IAnchoringSourcePoint sourcePoint = (IAnchoringSourcePoint)source;
        IPMPointRW endPoint = (IPMPointRW)sourcePoint;
        IPMFigureRW figure = (IPMFigureRW)endPoint.getPlanObjectRW();
        GeoVector distanceOfTargetFigure = routingParameters.getDistanceWhenFiguresAreMoved((IPMFigureRW)destination.getAnchoringFigure());
        ICurveLineRouter curveLineRouter = distanceOfTargetFigure == null || !figure.getPlanElementRW().isBendableRW(figure) || !actionContext.getActionParameters().getRoutingContext().isBendingActive() ? new CurveLineRouterProcessor() : new CurveLineRouterInCaseOfMovingProcessor();
        ActionIterator firstRunActionIterator = curveLineRouter.getRoutProcessingActionIterator(source, destination, actionContext, routingParameters);
        RepeatingCurveLineActionIterator repeatingActionIterator = new RepeatingCurveLineActionIterator(curveLineRouter, source, destination, actionContext, routingManager);
        if (firstRunActionIterator != null) {
            concatenatingActionIterator = new ConcatenatingActionIterator(2);
            concatenatingActionIterator.addActionIterator(firstRunActionIterator);
            concatenatingActionIterator.addActionIterator((ActionIterator)repeatingActionIterator);
        } else {
            concatenatingActionIterator = null;
        }
        return concatenatingActionIterator;
    }

    private class RepeatingCurveLineActionIterator
    extends ActionIterator {
        private final ICurveLineRouter previousCurveLineRouter;
        private final IAnchoringSource source;
        private final IAnchoringDestination destination;
        private final ActionContext actionContext;
        private final IRoutingManager routingManager;
        private ActionIterator repeatedActionIterator;

        public RepeatingCurveLineActionIterator(ICurveLineRouter previousCurveLineRouter, IAnchoringSource source, IAnchoringDestination destination, ActionContext actionContext, IRoutingManager routingManager) {
            this.previousCurveLineRouter = previousCurveLineRouter;
            this.source = source;
            this.destination = destination;
            this.actionContext = actionContext;
            this.routingManager = routingManager;
            this.repeatedActionIterator = null;
        }

        public boolean hasNext() {
            boolean hasNext;
            if (this.repeatedActionIterator == null) {
                boolean repeat;
                boolean bl = repeat = this.previousCurveLineRouter.endPointMoved() && this.source.getIAnchoring() != null && this.source.getIAnchoring().getAnchoringDestination() == this.destination;
                if (repeat) {
                    RouterContext routingParameters = new RouterContext(null);
                    this.repeatedActionIterator = CurveLineRouter.this.routeWhenClassesAreChecked(this.source, this.destination, this.actionContext, (IRoutingParameters)routingParameters, this.routingManager);
                    hasNext = this.repeatedActionIterator != null ? this.repeatedActionIterator.hasNext() : false;
                } else {
                    hasNext = false;
                }
            } else {
                hasNext = this.repeatedActionIterator.hasNext();
            }
            return hasNext;
        }

        public Action next() {
            return this.repeatedActionIterator.next();
        }
    }
}

