/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.reactions;

import com.arcway.lib.geometry.Dimension;
import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.device.Device;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.lib.java.New;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACApplyAppearanceTpl;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithNameSupplementRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.reactions.IRACreateSupplement;
import com.arcway.planagent.planmodel.reactions.IRADeleteSupplement;
import com.arcway.planagent.planmodel.reactions.IRAModifySupplement;
import com.arcway.planagent.planmodel.reactions.IRASetPlanElementName;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RAFixTextInsets
implements IRACreateSupplement,
IRAModifySupplement,
IRADeleteSupplement,
IRASetPlanElementName {
    private static final ILogger logger = Logger.getLogger(RAFixTextInsets.class);
    private static final int NAME_SUPPLEMENT_POINT_COUNT = 4;

    public ActionIterator createReactionsSupplementCreated(List<IPMGraphicalSupplementRW> createdSupplements, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + createdSupplements + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashSet planElements = New.hashSet((int)createdSupplements.size());
        for (IPMGraphicalSupplementRW supplement : createdSupplements) {
            IPMPlanElementRW planElement = supplement.getPlanElementRW();
            planElements.add(planElement);
        }
        for (IPMPlanElementRW planElement : planElements) {
            RAFixTextInsets.addFixActions(planElement, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsSupplementsDeleted(List<IPMGraphicalSupplementRW> deletedSupplements, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + deletedSupplements + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashSet planElements = New.hashSet((int)deletedSupplements.size());
        for (IPMGraphicalSupplementRW supplement : deletedSupplements) {
            IPMPlanElementRW planElement = supplement.getPlanElementRW();
            planElements.add(planElement);
        }
        for (IPMPlanElementRW planElement : planElements) {
            RAFixTextInsets.addFixActions(planElement, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsSupplementsModified(Map<IPMGraphicalSupplementRW, List<PositionAndPoint>> changedSupplements2OldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + changedSupplements2OldGeometry + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashSet planElements = New.hashSet((int)changedSupplements2OldGeometry.size());
        for (IPMGraphicalSupplementRW supplement : changedSupplements2OldGeometry.keySet()) {
            IPMPlanElementRW planElement = supplement.getPlanElementRW();
            planElements.add(planElement);
        }
        for (IPMPlanElementRW planElement : planElements) {
            RAFixTextInsets.addFixActions(planElement, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsPlanElementNameSet(IPMPlanElementRW planElement, String newName, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + planElement + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        RAFixTextInsets.addFixActions(planElement, actionContext, actions);
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addFixActions(IPMPlanElementRW planElement, ActionContext actionContext, PredeterminedActionIterator actions) {
        void var6_48;
        Insets nameInsets;
        if (!(planElement instanceof IPMPlanElementWithNameSupplementRW)) return;
        IPMPlanElementWithNameSupplementRW planElementWithNameSupplement = (IPMPlanElementWithNameSupplementRW)planElement;
        IPMGraphicalSupplementTextRW nameSupplement = planElementWithNameSupplement.getNameSupplementRW();
        if (nameSupplement != null) {
            IPMPointListRW supplementPointList = nameSupplement.getPointListRW();
            int supplementPointCount = supplementPointList.getPointCount();
            if (supplementPointCount == 4) {
                int vCandidateAlignment;
                double vCandidateArea;
                int hCandidateAlignment;
                double hCandidateArea;
                double centerDistance;
                String text = nameSupplement.getText();
                ITextAppearance textAppearance = nameSupplement.getTextAppearance();
                TextStyle textStyle = textAppearance.getTextStyle();
                double textHeight = textAppearance.getTextLineHeight();
                Points points = supplementPointList.getPoints();
                Direction direction = textAppearance.getDirection();
                Insets textInsets = textAppearance.getInsets();
                TurnedRectangle turnedTextRectangle = PMGraphicalSupplementText.calculateTextRectangle(points, direction, textInsets);
                double width = turnedTextRectangle.getW().abs();
                int numberOfTextLines = Device.calculateNumberOfTextLines((String)text, (TextStyle)textStyle, (double)textHeight, (double)width);
                double realHeight = (double)numberOfTextLines * textHeight;
                double height = turnedTextRectangle.getH().abs();
                int vAlignment = textAppearance.getAlignment().v;
                if (vAlignment == 8) {
                    centerDistance = (height - realHeight) / 2.0;
                } else if (vAlignment == 16) {
                    centerDistance = 0.0;
                } else {
                    if (vAlignment != 32) throw new IllegalArgumentException();
                    centerDistance = -(height - realHeight) / 2.0;
                }
                Point turnedTextRectangleCenter = turnedTextRectangle.getCenter();
                Direction xDirection = turnedTextRectangle.getDirection();
                GeoVector centerOffset = new GeoVector(centerDistance, xDirection.turn90());
                Point realTextCenter = turnedTextRectangleCenter.movePoint(centerOffset);
                Dimension realTextDimension = new Dimension(width, realHeight);
                TurnedRectangle realTextBoundary = new TurnedRectangle(realTextCenter, realTextDimension, xDirection);
                Rectangle realTextBounds = realTextBoundary.getOuterBounds();
                Rectangle realTextArea = realTextBounds.expand(textInsets);
                Rectangle supplementArea = points.getBounds();
                Insets space = new Insets(realTextArea, supplementArea);
                double supplementHeight = supplementArea.h();
                double freeAreaLeft = space.leftInset * supplementHeight;
                double freeAreaRight = space.rightInset * supplementHeight;
                if (freeAreaRight + 1.0E-10 > freeAreaLeft) {
                    hCandidateArea = freeAreaRight;
                    hCandidateAlignment = 4;
                } else {
                    hCandidateArea = freeAreaLeft;
                    hCandidateAlignment = 1;
                }
                double supplementWidth = supplementArea.w();
                double freeAreaTop = space.upperInset * supplementWidth;
                double freeAreaBottom = space.lowerInset * supplementWidth;
                if (freeAreaBottom + 1.0E-10 > freeAreaTop) {
                    vCandidateArea = freeAreaBottom;
                    vCandidateAlignment = 32;
                } else {
                    vCandidateArea = freeAreaTop;
                    vCandidateAlignment = 8;
                }
                int alignment = vCandidateArea + 1.0E-10 > hCandidateArea ? vCandidateAlignment : hCandidateAlignment;
                if (alignment == 1) {
                    nameInsets = new Insets(0.0, 0.0, 0.0, Math.max(0.0, supplementWidth - space.leftInset));
                } else if (alignment == 4) {
                    nameInsets = new Insets(0.0, 0.0, Math.max(0.0, supplementWidth - space.rightInset), 0.0);
                } else if (alignment == 8) {
                    nameInsets = new Insets(0.0, Math.max(0.0, supplementHeight - space.upperInset), 0.0, 0.0);
                } else {
                    if (alignment != 32) throw new IllegalArgumentException();
                    nameInsets = new Insets(Math.max(0.0, supplementHeight - space.lowerInset), 0.0, 0.0, 0.0);
                }
            } else {
                nameInsets = new Insets(0.0);
            }
            IPMFigureRW iPMFigureRW = nameSupplement.getFigureRW();
        } else {
            nameInsets = new Insets(0.0);
            List outlineFigures = planElement.getFiguresRW("outline");
            if (outlineFigures.size() > 0) {
                IPMFigureRW iPMFigureRW = (IPMFigureRW)outlineFigures.get(0);
            } else if (planElement.getFigureCount() > 0) {
                IPMFigureRW iPMFigureRW = planElement.getFigureRW(0);
            } else {
                Object var6_47 = null;
            }
        }
        if (var6_48 == null) return;
        RAFixTextInsets.addFixActions((IPMFigureRW)var6_48, nameSupplement, nameInsets, actionContext, actions);
    }

    private static void addFixActions(IPMFigureRW figure, IPMGraphicalSupplementTextRW nameSupplement, Insets nameInsets, ActionContext actionContext, PredeterminedActionIterator actions) {
        int i = 0;
        while (i < figure.getGraphicalSupplementCount()) {
            IPMGraphicalSupplementRW supplement = figure.getGraphicalSupplementRW(i);
            if (supplement != nameSupplement && supplement instanceof IPMGraphicalSupplementTextRW) {
                IPMGraphicalSupplementTextRW textSupplement = (IPMGraphicalSupplementTextRW)supplement;
                RAFixTextInsets.addFixActions(textSupplement, nameSupplement, nameInsets, actionContext, actions);
            }
            ++i;
        }
    }

    private static void addFixActions(IPMGraphicalSupplementTextRW supplement, IPMGraphicalSupplementTextRW nameSupplement, Insets nameInsets, ActionContext actionContext, PredeterminedActionIterator actions) {
        Rectangle supplementBounds = supplement.getPointListRW().getPoints().getBounds();
        if (supplementBounds != null) {
            Rectangle nameSupplementBounds;
            ITextAppearance currentTextAppearance = supplement.getTextAppearance();
            Insets currentInsets = currentTextAppearance.getInsets();
            double smallestInsetX = Math.min(currentInsets.leftInset, currentInsets.rightInset);
            double smallestInsetY = Math.min(currentInsets.upperInset, currentInsets.lowerInset);
            Insets newInsets = nameSupplement != null ? ((nameSupplementBounds = nameSupplement.getPointListRW().getPoints().getBounds()).equalsRectangle(supplementBounds) ? new Insets(smallestInsetY + nameInsets.upperInset, smallestInsetY + nameInsets.lowerInset, smallestInsetX + nameInsets.leftInset, smallestInsetX + nameInsets.rightInset) : new Insets(smallestInsetY, smallestInsetY, smallestInsetX, smallestInsetX)) : new Insets(smallestInsetY, smallestInsetY, smallestInsetX, smallestInsetX);
            if (!newInsets.equalsInsets(currentInsets)) {
                TextAppearanceTpl newAppearanceTpl = new TextAppearanceTpl();
                newAppearanceTpl.setInsets(newInsets);
                ACApplyAppearanceTpl action = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)supplement, (IAppearanceRO)currentTextAppearance, (IAppearanceTpl)newAppearanceTpl);
                actions.addAction((Action)action);
            }
        }
    }
}

