/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.reactions;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.java.New;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMContainmentRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.ACApplyAppearanceTpl;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.FillAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.IAppearanceTpl;
import com.arcway.planagent.planmodel.appearance.IFillAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.TextAppearanceTpl;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithNameSupplementRW;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithPlaneOutlineRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementImageRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementPlaneTextRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementStickmanRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.reactions.IRAAddContainment;
import com.arcway.planagent.planmodel.reactions.IRACreateSupplement;
import com.arcway.planagent.planmodel.reactions.IRADeleteSupplement;
import com.arcway.planagent.planmodel.reactions.IRAModifySupplement;
import com.arcway.planagent.planmodel.reactions.IRARemoveContainment;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RAFixNameAlignment
implements IRAAddContainment,
IRARemoveContainment,
IRACreateSupplement,
IRAModifySupplement,
IRADeleteSupplement {
    private static final ILogger logger = Logger.getLogger(RAFixNameAlignment.class);
    private static final int NAME_SUPPLEMENT_POINT_COUNT = 4;

    public ActionIterator createReactionsSupplementCreated(List<IPMGraphicalSupplementRW> createdSupplements, ActionContext actionContext) {
        IPMPlanElementRW planElement;
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + createdSupplements + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashMap planElement2Supplements = New.hashMap((int)createdSupplements.size());
        for (IPMGraphicalSupplementRW iPMGraphicalSupplementRW : createdSupplements) {
            planElement = iPMGraphicalSupplementRW.getPlanElementRW();
            ArrayList<IPMGraphicalSupplementRW> supplementsOfPlanElement = (ArrayList<IPMGraphicalSupplementRW>)planElement2Supplements.get(planElement);
            if (supplementsOfPlanElement == null) {
                supplementsOfPlanElement = new ArrayList<IPMGraphicalSupplementRW>();
                planElement2Supplements.put(planElement, supplementsOfPlanElement);
            }
            supplementsOfPlanElement.add(iPMGraphicalSupplementRW);
        }
        for (Map.Entry entry : planElement2Supplements.entrySet()) {
            planElement = (IPMPlanElementRW)entry.getKey();
            List<IPMPlanElementRW> addedContainees = Collections.emptyList();
            List<IPMPlanElementRW> removedContainees = Collections.emptyList();
            List addedSupplements = (List)entry.getValue();
            List<IPMGraphicalSupplementRW> removedSupplements = Collections.emptyList();
            int nrOfSupplementsBecameRelevant = 0;
            this.addFixActions(planElement, addedContainees, removedContainees, addedSupplements, removedSupplements, nrOfSupplementsBecameRelevant, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsSupplementsDeleted(List<IPMGraphicalSupplementRW> deletedSupplements, ActionContext actionContext) {
        IPMPlanElementRW planElement;
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + deletedSupplements + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashMap planElement2Supplements = New.hashMap((int)deletedSupplements.size());
        for (IPMGraphicalSupplementRW iPMGraphicalSupplementRW : deletedSupplements) {
            planElement = iPMGraphicalSupplementRW.getPlanElementRW();
            ArrayList<IPMGraphicalSupplementRW> supplementsOfPlanElement = (ArrayList<IPMGraphicalSupplementRW>)planElement2Supplements.get(planElement);
            if (supplementsOfPlanElement == null) {
                supplementsOfPlanElement = new ArrayList<IPMGraphicalSupplementRW>();
                planElement2Supplements.put(planElement, supplementsOfPlanElement);
            }
            supplementsOfPlanElement.add(iPMGraphicalSupplementRW);
        }
        for (Map.Entry entry : planElement2Supplements.entrySet()) {
            planElement = (IPMPlanElementRW)entry.getKey();
            List<IPMPlanElementRW> addedContainees = Collections.emptyList();
            List<IPMPlanElementRW> removedContainees = Collections.emptyList();
            List<IPMGraphicalSupplementRW> addedSupplements = Collections.emptyList();
            List removedSupplements = (List)entry.getValue();
            int nrOfSupplementsBecameRelevant = 0;
            this.addFixActions(planElement, addedContainees, removedContainees, addedSupplements, removedSupplements, nrOfSupplementsBecameRelevant, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsContainmentAdded(IPMContainmentRW createdContainment, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + createdContainment + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        IPMPlanElementRW planElement = createdContainment.getContainingPlanElementRW();
        List<IPMPlanElementRW> addedContainees = Collections.singletonList(createdContainment.getContainedPlanElementRW());
        List<IPMPlanElementRW> removedContainees = Collections.emptyList();
        List<IPMGraphicalSupplementRW> addedSupplements = Collections.emptyList();
        List<IPMGraphicalSupplementRW> removedSupplements = Collections.emptyList();
        int nrOfSupplementsBecameRelevant = 0;
        this.addFixActions(planElement, addedContainees, removedContainees, addedSupplements, removedSupplements, nrOfSupplementsBecameRelevant, actionContext, actions);
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsContainmentRemoved(IPMContainmentRW deletedContainment, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + deletedContainment + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        IPMPlanElementRW planElement = deletedContainment.getContainingPlanElementRW();
        List<IPMPlanElementRW> addedContainees = Collections.emptyList();
        List<IPMPlanElementRW> removedContainees = Collections.singletonList(deletedContainment.getContainedPlanElementRW());
        List<IPMGraphicalSupplementRW> addedSupplements = Collections.emptyList();
        List<IPMGraphicalSupplementRW> removedSupplements = Collections.emptyList();
        int nrOfSupplementsBecameRelevant = 0;
        this.addFixActions(planElement, addedContainees, removedContainees, addedSupplements, removedSupplements, nrOfSupplementsBecameRelevant, actionContext, actions);
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsSupplementsModified(Map<IPMGraphicalSupplementRW, List<PositionAndPoint>> changedSupplements2OldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixNameAlignment createReactions(" + changedSupplements2OldGeometry + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator();
        HashMap planElement2Supplements = New.hashMap((int)changedSupplements2OldGeometry.size());
        for (Map.Entry<IPMGraphicalSupplementRW, List<PositionAndPoint>> entry : changedSupplements2OldGeometry.entrySet()) {
            IPMGraphicalSupplementRW supplement = entry.getKey();
            IPMPlanElementRW planElement = supplement.getPlanElementRW();
            ArrayList<IPMGraphicalSupplementRW> supplementsOfPlanElement = (ArrayList<IPMGraphicalSupplementRW>)planElement2Supplements.get(planElement);
            if (supplementsOfPlanElement == null) {
                supplementsOfPlanElement = new ArrayList<IPMGraphicalSupplementRW>();
                planElement2Supplements.put(planElement, supplementsOfPlanElement);
            }
            supplementsOfPlanElement.add(supplement);
        }
        for (Map.Entry<Object, List<Object>> entry : planElement2Supplements.entrySet()) {
            IPMPlanElementWithNameSupplementRW planElementWithNameSupplement;
            IPMGraphicalSupplementTextRW nameSupplement;
            IPMPlanElementRW planElement = (IPMPlanElementRW)entry.getKey();
            if (!(planElement instanceof IPMPlanElementWithNameSupplementRW) || (nameSupplement = (planElementWithNameSupplement = (IPMPlanElementWithNameSupplementRW)planElement).getNameSupplementRW()) == null) continue;
            IPMPointListRW nameSupplementPointList = nameSupplement.getPointListRW();
            Rectangle newNameSupplementSupplementBounds = nameSupplementPointList.getPoints().getBounds();
            List<PositionAndPoint> oldNameSupplementGeometry = changedSupplements2OldGeometry.get(nameSupplement);
            Rectangle oldNameSupplementSupplementBounds = RAFixNameAlignment.getBounds(oldNameSupplementGeometry);
            if (oldNameSupplementSupplementBounds == null) {
                oldNameSupplementSupplementBounds = newNameSupplementSupplementBounds;
            }
            int nrOfSupplementsBecameRelevant = 0;
            List<Object> supplements = entry.getValue();
            for (IPMGraphicalSupplementRW iPMGraphicalSupplementRW : supplements) {
                if (iPMGraphicalSupplementRW == nameSupplement) continue;
                List<PositionAndPoint> oldGeometry = changedSupplements2OldGeometry.get(iPMGraphicalSupplementRW);
                int oldPointCount = oldGeometry == null ? 0 : oldGeometry.size();
                Rectangle oldSupplementBounds = RAFixNameAlignment.getBounds(oldGeometry);
                if (oldSupplementBounds == null) continue;
                IPMPointListRW supplementPointList = iPMGraphicalSupplementRW.getPointListRW();
                int currentPointCount = supplementPointList.getPointCount();
                Rectangle currentSupplementBounds = supplementPointList.getPoints().getBounds();
                boolean isFormerlyRelevant = RAFixNameAlignment.isRelevantSupplement(nameSupplement, oldNameSupplementSupplementBounds, iPMGraphicalSupplementRW, oldPointCount, oldSupplementBounds);
                boolean isCurrentlyRelevant = RAFixNameAlignment.isRelevantSupplement(nameSupplement, newNameSupplementSupplementBounds, iPMGraphicalSupplementRW, currentPointCount, currentSupplementBounds);
                if (isCurrentlyRelevant && !isFormerlyRelevant) {
                    ++nrOfSupplementsBecameRelevant;
                    continue;
                }
                if (isCurrentlyRelevant || !isFormerlyRelevant) continue;
                --nrOfSupplementsBecameRelevant;
            }
            List<IPMPlanElementRW> list = Collections.emptyList();
            List<IPMPlanElementRW> removedContainees = Collections.emptyList();
            List<IPMGraphicalSupplementRW> addedSupplements = Collections.emptyList();
            List<IPMGraphicalSupplementRW> removedSupplements = Collections.emptyList();
            this.addFixActions(planElement, list, removedContainees, addedSupplements, removedSupplements, nrOfSupplementsBecameRelevant, actionContext, actions);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    private static Rectangle getBounds(List<PositionAndPoint> positionAndPoints) {
        Rectangle bounds = null;
        if (positionAndPoints != null) {
            for (PositionAndPoint positionAndPoint : positionAndPoints) {
                Point position = positionAndPoint.getPosition();
                bounds = bounds == null ? new Rectangle(position, position) : bounds.union(position);
            }
        }
        return bounds;
    }

    private void addFixActions(IPMPlanElementRW planElement, List<IPMPlanElementRW> addedContainees, List<IPMPlanElementRW> removedContainees, List<IPMGraphicalSupplementRW> addedSupplements, List<IPMGraphicalSupplementRW> removedSupplements, int nrOfSupplementsBecameRelevant, ActionContext actionContext, PredeterminedActionIterator actions) {
        Rectangle figureBounds;
        Rectangle supplementBounds;
        IPMFigureRW figure;
        IPMPointListRW figurePointList;
        IPMPointListRW supplementPointList;
        int supplementPointCount;
        IPMPlanElementWithNameSupplementRW planElementWithNameSupplement;
        IPMGraphicalSupplementTextRW nameSupplement;
        if (planElement instanceof IPMPlanElementWithNameSupplementRW && (nameSupplement = (planElementWithNameSupplement = (IPMPlanElementWithNameSupplementRW)planElement).getNameSupplementRW()) != null && (supplementPointCount = (supplementPointList = nameSupplement.getPointListRW()).getPointCount()) == 4 && (figurePointList = (figure = nameSupplement.getFigureRW()).getPointListRW()).getPointCount() == supplementPointCount && (supplementBounds = supplementPointList.getPoints().getBounds()).equalsRectangle(figureBounds = figurePointList.getPoints().getBounds())) {
            List<IPMPlanElementRW> currentContainees = RAFixNameAlignment.getConainees(planElementWithNameSupplement);
            this.filterRelevantContainees(currentContainees);
            this.filterRelevantContainees(addedContainees);
            this.filterRelevantContainees(removedContainees);
            List<IPMGraphicalSupplementRW> currentSupplements = RAFixNameAlignment.getSupplements(figure);
            boolean nameSupplementCreated = addedSupplements.contains(nameSupplement);
            RAFixNameAlignment.filterRelevantSupplements(nameSupplement, supplementBounds, currentSupplements);
            RAFixNameAlignment.filterRelevantSupplements(nameSupplement, supplementBounds, addedSupplements);
            RAFixNameAlignment.filterRelevantSupplements(nameSupplement, supplementBounds, removedSupplements);
            int nrOfCurrentChildren = currentContainees.size() + currentSupplements.size();
            int addedContainments = addedContainees.size() - removedContainees.size();
            int nrOfAddedChildren = addedContainments + addedSupplements.size() - removedSupplements.size() + nrOfSupplementsBecameRelevant;
            Operation operation = nrOfCurrentChildren > 0 && (nameSupplementCreated || nrOfCurrentChildren == nrOfAddedChildren) ? (addedContainments > 0 ? Operation.GIVE_WAY_WITH_CONTAINMENT : Operation.GIVE_WAY) : (nrOfCurrentChildren == 0 && nrOfAddedChildren < 0 ? Operation.MOVE_BACK : null);
            if (operation != null) {
                RAFixNameAlignment.addFixActions(planElementWithNameSupplement, nameSupplement, operation, actionContext, actions);
            }
        }
    }

    private static List<IPMPlanElementRW> getConainees(IPMPlanElementRW planElement) {
        int containmentCount = planElement.getContainmentAsContainerCount();
        ArrayList<IPMPlanElementRW> containees = new ArrayList<IPMPlanElementRW>(containmentCount);
        int i = 0;
        while (i < containmentCount) {
            IPMContainmentRW containment = planElement.getContainmentAsContainerRW(i);
            IPMPlanElementRW containedPlanElement = containment.getContainedPlanElementRW();
            containees.add(containedPlanElement);
            ++i;
        }
        return containees;
    }

    private static List<IPMGraphicalSupplementRW> getSupplements(IPMFigureRW figure) {
        int supplementCount = figure.getGraphicalSupplementCount();
        ArrayList<IPMGraphicalSupplementRW> supplements = new ArrayList<IPMGraphicalSupplementRW>(supplementCount);
        int i = 0;
        while (i < supplementCount) {
            IPMGraphicalSupplementRW supplement = figure.getGraphicalSupplementRW(i);
            supplements.add(supplement);
            ++i;
        }
        return supplements;
    }

    private void filterRelevantContainees(List<IPMPlanElementRW> containees) {
    }

    private static void filterRelevantSupplements(IPMGraphicalSupplementTextRW nameSupplement, Rectangle nameSupplementBounds, List<IPMGraphicalSupplementRW> supplements) {
        Iterator<IPMGraphicalSupplementRW> i = supplements.iterator();
        while (i.hasNext()) {
            IPMGraphicalSupplementRW supplement = i.next();
            if (RAFixNameAlignment.isRelevantSupplement(nameSupplement, nameSupplementBounds, supplement, -1, null)) continue;
            i.remove();
        }
    }

    private static boolean isRelevantSupplement(IPMGraphicalSupplementTextRW nameSupplement, Rectangle nameSupplementBounds, IPMGraphicalSupplementRW supplement, int optionalSupplementPointCount, Rectangle optionalSupplementBounds) {
        boolean isRelevant;
        if (supplement != nameSupplement && RAFixNameAlignment.isRelevantSupplementType(supplement)) {
            int supplementPointCount;
            IPMPointListRW supplementPointList = supplement.getPointListRW();
            int n = supplementPointCount = optionalSupplementPointCount >= 0 ? optionalSupplementPointCount : supplementPointList.getPointCount();
            if (supplementPointCount == 4) {
                Rectangle supplementBounds = optionalSupplementBounds != null ? optionalSupplementBounds : supplementPointList.getPoints().getBounds();
                isRelevant = supplementBounds.equalsRectangle(nameSupplementBounds);
            } else {
                isRelevant = false;
            }
        } else {
            isRelevant = false;
        }
        return isRelevant;
    }

    private static boolean isRelevantSupplementType(IPMGraphicalSupplementRW supplement) {
        return supplement instanceof IPMGraphicalSupplementTextRW || supplement instanceof IPMGraphicalSupplementPlaneTextRW || supplement instanceof IPMGraphicalSupplementStickmanRW || supplement instanceof IPMGraphicalSupplementImageRW;
    }

    private static void addFixActions(IPMPlanElementWithNameSupplementRW planElement, IPMGraphicalSupplementTextRW nameSupplement, Operation operation, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW outlineFigure;
        IPMPlanElementWithPlaneOutlineRW planElementWithPlaneOutline;
        Alignment newAlignment;
        ITextAppearance textAppearance = nameSupplement.getTextAppearance();
        Alignment currentAlignment = textAppearance.getAlignment();
        Alignment defaultAlignment = planElement.getDefaultAlignmentForNameSupplement();
        int verticalGiveWayAlignment = planElement.getVerticalGiveWayAlignmentForNameSupplement();
        int horizontalGiveWayAlignment = planElement.getHorizontalGiveWayAlignmentForNameSupplement();
        if (operation == Operation.GIVE_WAY || operation == Operation.GIVE_WAY_WITH_CONTAINMENT) {
            if (currentAlignment.v == 16) {
                newAlignment = new Alignment(currentAlignment);
                newAlignment.v = verticalGiveWayAlignment;
                if (horizontalGiveWayAlignment != -1) {
                    newAlignment.h = horizontalGiveWayAlignment;
                }
            } else {
                newAlignment = currentAlignment;
            }
        } else if (operation == Operation.MOVE_BACK) {
            newAlignment = currentAlignment.v == verticalGiveWayAlignment && (horizontalGiveWayAlignment == -1 || currentAlignment.h == horizontalGiveWayAlignment) ? new Alignment(defaultAlignment) : currentAlignment;
        } else {
            throw new IllegalArgumentException();
        }
        if (!newAlignment.equalsAlignment(currentAlignment)) {
            TextAppearanceTpl newAppearanceTpl = new TextAppearanceTpl();
            newAppearanceTpl.setAlignment(newAlignment);
            ACApplyAppearanceTpl action = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)nameSupplement, (IAppearanceRO)textAppearance, (IAppearanceTpl)newAppearanceTpl);
            actions.addAction((Action)action);
        }
        if (operation == Operation.GIVE_WAY_WITH_CONTAINMENT && planElement instanceof IPMPlanElementWithPlaneOutlineRW && (planElementWithPlaneOutline = (IPMPlanElementWithPlaneOutlineRW)((Object)planElement)).removeFillColorWhenFirstChildIsAdded() && (outlineFigure = planElementWithPlaneOutline.getOutlineFigurePlaneRW()) != null) {
            IFillAppearance fillAppearance = outlineFigure.getFillAppearanceRW();
            FillAppearanceTpl newAppearanceTpl = new FillAppearanceTpl();
            FillAppearance defaultFillAppearance = new FillAppearance();
            newAppearanceTpl.setFillColor(defaultFillAppearance.getFillColor());
            ACApplyAppearanceTpl action = new ACApplyAppearanceTpl(actionContext, (IPMPlanObjectRO)outlineFigure, (IAppearanceRO)fillAppearance, (IAppearanceTpl)newAppearanceTpl);
            actions.addAction((Action)action);
        }
    }

    private static enum Operation {
        GIVE_WAY,
        GIVE_WAY_WITH_CONTAINMENT,
        MOVE_BACK;

    }
}

