/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.persistent;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.graphics.image.IImageProxy;
import com.arcway.lib.graphics.image.Image;
import com.arcway.lib.graphics.image.ImageCoDec;
import com.arcway.lib.graphics.image.ImageFileType;
import com.arcway.lib.graphics.image.ImageProxy;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResource;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.resource.URLResource;
import com.arcway.planagent.planmodel.FMCAPlanModelCommonPlugin;
import com.arcway.planagent.planmodel.cm.appearance.IImageAppearance;
import com.arcway.planagent.planmodel.persistent.EOData;
import com.arcway.planagent.planmodel.persistent.EOPlanModelObject;
import com.arcway.planagent.planmodel.persistent.EXEOFactoryException;
import de.plans.lib.eclipse.ResourceLoader;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.Plugin;

public class EOGraphicalSupplementDataImage
extends EOData {
    private static final ILogger LOGGER = Logger.getLogger(EOGraphicalSupplementDataImage.class);
    public static final String XML_NAME = "supplement.image";
    static final ImageProxy ERROR_IMAGE;
    private final ImageAppearance imageAppearance = new ImageAppearance();
    private FileResource tmpPNGOrJPGFileResource = null;
    private Byte headerByte1 = null;
    private Byte headerByte2 = null;
    private OutputStream outputStream = null;

    static {
        try {
            URL url = ResourceLoader.getUrl((Plugin)FMCAPlanModelCommonPlugin.getDefault(), (String)"icons/missingImg.png");
            URLResource streamResource = new URLResource(url);
            File tmpFile = EOGraphicalSupplementDataImage.createTempFile(ImageCoDec.PNG);
            Image image = ImageCoDec.decodeIntoImage((IStreamResource)streamResource);
            ImageCoDec.encodeIntoFile((Image)image, (File)tmpFile, (ImageFileType)ImageCoDec.PNG);
            image.dispose();
            FileResource byteArrayAsStreamResource = new FileResource(tmpFile);
            ERROR_IMAGE = new ImageProxy((IStreamResource)byteArrayAsStreamResource);
            ERROR_IMAGE.registerClient(EOGraphicalSupplementDataImage.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    private static File createTempFile(ImageFileType imageFileType) throws IOException {
        File tmpFile = File.createTempFile("planeditorimage", "." + imageFileType.getFileExtension());
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public EOGraphicalSupplementDataImage() {
        super(XML_NAME);
    }

    public EOGraphicalSupplementDataImage(String xmlName, XMLContext xmlContext) throws EXEOFactoryException {
        super(XML_NAME, xmlContext);
        if (!XML_NAME.equals(xmlName)) {
            throw new EXEOFactoryException("Unexpected tag <" + xmlName + "> (<" + XML_NAME + "> expected.");
        }
    }

    protected EOPlanModelObject getFlatCopy(EOPlanModelObject parent) {
        EOGraphicalSupplementDataImage newObject = new EOGraphicalSupplementDataImage();
        newObject.setAttributesFromEO(this);
        return newObject;
    }

    public EOData createChild(String xmlName, XMLContext context) throws EXEOFactoryException {
        return null;
    }

    protected final void setAttributesFromEO(EOGraphicalSupplementDataImage sourceEO) {
        assert (sourceEO != null);
        super.setAttributesFromEO((EOData)sourceEO);
        this.imageAppearance.setImageProxy(sourceEO.imageAppearance.getImageProxy());
    }

    protected boolean canHaveBinaryContent() {
        return true;
    }

    protected void beginReadingBinaryContent() throws EXDecoderException {
    }

    protected void readPartOfBinaryContent(byte[] bytes) throws EXDecoderException {
        int skip;
        if (this.outputStream == null) {
            if (this.headerByte1 == null && bytes.length >= 1) {
                this.headerByte1 = bytes[0];
                if (bytes.length >= 2) {
                    this.headerByte2 = bytes[1];
                }
                skip = 2;
            } else if (this.headerByte2 == null && bytes.length >= 1) {
                this.headerByte2 = bytes[0];
                skip = 1;
            } else {
                skip = 0;
            }
            if (this.headerByte1 != null && this.headerByte2 != null) {
                ImageFileType imageFileType = this.headerByte1 == -1 && this.headerByte2 == -40 ? ImageCoDec.JPG : ImageCoDec.PNG;
                try {
                    File tmpFile = EOGraphicalSupplementDataImage.createTempFile(imageFileType);
                    this.outputStream = FileHelper.fileToOutputStream((File)tmpFile);
                    this.tmpPNGOrJPGFileResource = new FileResource(tmpFile);
                    this.outputStream.write(this.headerByte1.byteValue());
                    this.outputStream.write(this.headerByte2.byteValue());
                }
                catch (IOException e) {
                    throw new EXDecoderException((Throwable)e);
                }
                catch (JvmExternalResourceInteractionException e) {
                    throw new EXDecoderException((Throwable)e);
                }
            }
        } else {
            skip = 0;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.write(bytes, skip, bytes.length - skip);
            }
            catch (IOException e) {
                throw new EXDecoderException((Throwable)e);
            }
        }
    }

    protected void endReadingBinaryContent() throws EXDecoderException {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            throw new EXDecoderException((Throwable)e);
        }
        this.outputStream = null;
        ImageProxy imageProxy = this.imageAppearance.createImageProxy((IStreamResource)this.tmpPNGOrJPGFileResource);
        this.imageAppearance.setImageProxy((IImageProxy)imageProxy);
        this.tmpPNGOrJPGFileResource = null;
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = false;
        if (!knownAttribute) {
            knownAttribute = super.setAttributeFromXML(name, value);
        }
        return knownAttribute;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext outp) throws EXEncoderException {
        super.appendAttributesToXML(outp);
    }

    protected boolean hasBinaryContent() {
        return true;
    }

    protected InputStream writeBinaryContentToXML() throws IOException {
        IStreamResource pngOrJpgByteArrayAsStreamResource = this.imageAppearance.getImageProxy().getPNGOrJPGByteArrayAsStreamResource();
        try {
            return pngOrJpgByteArrayAsStreamResource.toInputStream();
        }
        catch (JvmExternalResourceInteractionException e) {
            throw e.toIOException();
        }
    }

    public IImageAppearance getImageAppearance() {
        return this.imageAppearance;
    }

    public void resourceCacheActivated() {
        this.imageAppearance.activateImageCache();
        super.resourceCacheActivated();
    }

    public void resourceCacheDeactivated() {
        super.resourceCacheDeactivated();
        this.imageAppearance.deactivateImageCache();
    }

    private class ImageAppearance
    implements IImageAppearance {
        private IImageProxy imageProxy = ERROR_IMAGE;

        private ImageAppearance() {
        }

        public ImageProxy createImageProxy(IStreamResource pngByteArrayAsStreamResource) {
            ImageProxy newImageProxy = new ImageProxy(pngByteArrayAsStreamResource);
            return newImageProxy;
        }

        @Override
        public IImageProxy getImageProxy() {
            return this.imageProxy;
        }

        @Override
        public void setImageProxy(IImageProxy imageProxy) {
            if (imageProxy != this.imageProxy) {
                if (EOGraphicalSupplementDataImage.this.isResourceCacheActive()) {
                    this.imageProxy.deregisterClient((Object)this);
                    imageProxy.registerClient((Object)this);
                }
                this.imageProxy = imageProxy;
            }
        }

        private void activateImageCache() {
            this.imageProxy.registerClient((Object)this);
        }

        private void deactivateImageCache() {
            this.imageProxy.deregisterClient((Object)this);
        }
    }
}

