/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.cm.implementation;

import com.arcway.lib.geometry.Direction;
import com.arcway.lib.geometry.Insets;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.Rectangle;
import com.arcway.lib.geometry.TurnedRectangle;
import com.arcway.lib.graphics.Alignment;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.text.TextStyle;
import com.arcway.planagent.planmodel.access.readonly.IText;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearance;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.persistent.EOGraphicalSupplementDataText;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMGraphicalSupplement;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOData;
import com.arcway.planagent.planmodel.persistent.EOGraphicalSupplement;
import java.util.Collection;
import java.util.Collections;

public class PMGraphicalSupplementText
extends PMGraphicalSupplement
implements IPMGraphicalSupplementTextRO,
IPMGraphicalSupplementTextRW {
    public static final String XML_TYPE = "text";
    private final ITextAppearance textAppearance = new ITextAppearance(){

        public Alignment getAlignment() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getAlignment();
        }

        public Direction getDirection() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getDirection();
        }

        public Insets getInsets() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getInsets();
        }

        public Color getTextColor() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getTextColor();
        }

        public double getTextLineHeight() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getTextLineHeight();
        }

        public TextStyle getTextStyle() {
            return PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().getTextStyle();
        }

        public void setAlignment(Alignment alignment) {
            if (!$assertionsDisabled && alignment == null) {
                throw new AssertionError((Object)"alignment is null");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setAlignment(alignment);
        }

        public void setDirection(Direction direction) {
            if (!$assertionsDisabled && direction == null) {
                throw new AssertionError((Object)"direction is null");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setDirection(direction);
        }

        public void setInsets(Insets insets) {
            if (!$assertionsDisabled && insets == null) {
                throw new AssertionError((Object)"insets is null");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setInsets(insets);
        }

        public void setTextColor(Color textColor) {
            if (!$assertionsDisabled && textColor == null) {
                throw new AssertionError((Object)"textColor is null");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setTextColor(textColor);
        }

        public void setTextLineHeight(double textHeight) {
            if (!$assertionsDisabled && !(textHeight >= 0.0)) {
                throw new AssertionError((Object)"textHeight is less than 0");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setTextLineHeight(textHeight);
        }

        public void setTextStyle(TextStyle textStyle) {
            if (!$assertionsDisabled && textStyle == null) {
                throw new AssertionError((Object)"textStyle is null");
            }
            PMGraphicalSupplementText.this.getPersistentGraphicalSupplementDataText().getTextAppearance().setTextStyle(textStyle);
        }

        public void setAppearanceFrom(IAppearanceRO appearance) {
            if (appearance instanceof ITextAppearanceRO) {
                ITextAppearanceRO text = (ITextAppearanceRO)appearance;
                this.setAlignment(text.getAlignment());
                this.setDirection(text.getDirection());
                this.setInsets(text.getInsets());
                this.setTextColor(text.getTextColor());
                this.setTextLineHeight(text.getTextLineHeight());
                this.setTextStyle(text.getTextStyle());
            }
        }

        public IAppearanceRO getAppearanceAsCopy() {
            return new TextAppearance((ITextAppearanceRO)this);
        }
    };
    private final Collection<? extends IText> iTexts = Collections.singleton(new IText(){

        public double getTextLineHeight() {
            return PMGraphicalSupplementText.this.getTextAppearanceRO().getTextLineHeight();
        }

        public String getText() {
            return PMGraphicalSupplementText.this.getText();
        }
    });

    public static TurnedRectangle calculateTextRectangle(Points points, Direction direction, Insets textInsets) {
        Rectangle bounds = PMGraphicalSupplementText.calculateTextBoundary(points, textInsets);
        TurnedRectangle turnedRectangle = new TurnedRectangle(bounds).turnAndShrinkToBiggest(direction);
        return turnedRectangle;
    }

    public static Rectangle calculateTextBoundary(Points points, Insets textInsets) {
        Rectangle bounds = points.getBounds().shrink(textInsets);
        return bounds;
    }

    protected PMGraphicalSupplementText(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
        EOData[] data = new EOData[]{new EOGraphicalSupplementDataText()};
        this.setDatas(data);
    }

    protected PMGraphicalSupplementText(PlanModelMgr planModelMgr, EOGraphicalSupplement eo) {
        super(planModelMgr, eo);
    }

    public PMGraphicalSupplementText(PlanModelMgr planModelMgr, PMFigure figure) {
        this(planModelMgr);
        assert (figure != null) : "figure is null";
        this.constructPMGraphicalSupplement(figure);
    }

    protected EOGraphicalSupplementDataText getPersistentGraphicalSupplementDataText() {
        return (EOGraphicalSupplementDataText)this.getDatas()[0];
    }

    @Override
    public ITextAppearance getTextAppearance() {
        return this.textAppearance;
    }

    @Override
    public String getText() {
        return this.getPersistentGraphicalSupplementDataText().getText();
    }

    @Override
    public void setText(String text) {
        this.getPersistentGraphicalSupplementDataText().setText(text);
    }

    @Override
    public ITextAppearanceRO getTextAppearanceRO() {
        return this.getTextAppearance();
    }

    public Collection<? extends IText> getTexts() {
        return this.iTexts;
    }
}

