/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.base.actions;

import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.geometry.polygon.PolygonCorner;
import com.arcway.lib.graphics.FillColor;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureLineShapeRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanElementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigureLineShape;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACRemoveFigure;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.IndeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithOptionalShadowRW;
import com.arcway.planagent.planmodel.cm.actions.ACCreateGraphicalSupplementDots;
import com.arcway.planagent.planmodel.cm.appearance.DotsAppearance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class UpdateShadowsActionIterator
extends IndeterminedActionIterator {
    private static final double SHADOW_THICKNESS_MULTIPLIER = 0.5;
    private static final double SHADOW_COLOR_GAYER = 0.5;
    private static final double SHADOW_COLOR_BRIGHTER = 0.5;
    private static final double DOTS_SIZE_MULTIPLIER = 0.5;
    private static final GeoVector SHADOW_DISTANCE = new GeoVector(3.0, -3.0);
    private final IPMPlanElementWithOptionalShadowRW planElement;
    private final ActionContext actionContext;
    private final boolean makeShadows;
    private Iterator<IPMFigureRW> shadowsToRemoveIterator = null;
    private Iterator<IPMFigureRW> shadowableFigureIterator = null;
    private Iterator<IPMPointRW> pointsToBeDottedIterator = null;

    public UpdateShadowsActionIterator(IPMPlanElementWithOptionalShadowRW planElement, ActionContext actionContext, boolean makeShadows) {
        this.planElement = planElement;
        this.actionContext = actionContext;
        this.makeShadows = makeShadows;
    }

    public Action createAction(int n, List<Action> previousActions) {
        Object nextAction = null;
        if (this.shadowsToRemoveIterator == null) {
            this.shadowsToRemoveIterator = new ArrayList(this.planElement.getFiguresRW("shadow")).iterator();
        }
        if (this.shadowsToRemoveIterator.hasNext()) {
            IPMFigureRW shadowFigure = this.shadowsToRemoveIterator.next();
            nextAction = new ACRemoveFigure(this.actionContext, shadowFigure);
        } else if (this.makeShadows) {
            if (this.shadowableFigureIterator == null) {
                this.shadowableFigureIterator = new ArrayList<IPMFigureRW>(this.planElement.getShadowableFigures()).iterator();
            }
            if (this.shadowableFigureIterator.hasNext()) {
                Points points;
                IPMFigureRW shadowableFigure = this.shadowableFigureIterator.next();
                if (this.planElement.getShadowGeometry(shadowableFigure) != null) {
                    points = this.planElement.getShadowGeometry(shadowableFigure);
                } else {
                    IPMPointListRW pointList = shadowableFigure.getPointListRW();
                    points = pointList.getPoints();
                }
                points = points.movePoints(SHADOW_DISTANCE);
                int[] force = new int[points.size()];
                int i = 0;
                while (i < force.length) {
                    force[i] = 1;
                    ++i;
                }
                LineAppearance lineAppearance = null;
                lineAppearance = this.planElement.getShadowLineAppearance() != null ? new LineAppearance((ILineAppearanceRO)this.planElement.getShadowLineAppearance()) : new LineAppearance((ILineAppearanceRO)shadowableFigure.getLineAppearanceRW());
                lineAppearance.setLineThickness(lineAppearance.getLineThickness() * 0.5);
                lineAppearance.setLineColor(lineAppearance.getLineColor().gotoGray(0.5).gotoWhite(0.5));
                if (shadowableFigure instanceof IPMFigurePlaneRW) {
                    IPMFigurePlaneRW figure = (IPMFigurePlaneRW)shadowableFigure;
                    FillAppearance fillAppearance = new FillAppearance((IFillAppearanceRO)figure.getFillAppearanceRW());
                    FillColor fillColor = fillAppearance.getFillColor();
                    fillAppearance.setFillColor(new FillColor(fillColor.foregroundColor.gotoGray(0.5).gotoWhite(0.5), fillColor.foregroundAlpha, fillColor.backgroundColor.gotoGray(0.5), fillColor.backgroundAlpha));
                    nextAction = new ACCreateFigurePlane(this.actionContext, "shadow", (IPMPlanElementRW)this.planElement, points, force, (ILineAppearanceRO)lineAppearance, (IFillAppearanceRO)fillAppearance, true);
                } else if (shadowableFigure instanceof IPMFigureLineShapeRW) {
                    IPMFigureLineShapeRW figure = (IPMFigureLineShapeRW)shadowableFigure;
                    LineMarkerAppearance lineStartMarkerAppearance = new LineMarkerAppearance((ILineMarkerAppearanceRO)figure.getLineStartMarkerAppearanceRW());
                    lineStartMarkerAppearance.setLineMarkerColor(lineStartMarkerAppearance.getLineMarkerColor().gotoGray(0.5).gotoWhite(0.5));
                    lineStartMarkerAppearance.setLineMarkerSize(lineStartMarkerAppearance.getLineMarkerSize() / 0.5);
                    LineMarkerAppearance lineEndMarkerAppearance = new LineMarkerAppearance((ILineMarkerAppearanceRO)figure.getLineStartMarkerAppearanceRW());
                    lineEndMarkerAppearance.setLineMarkerColor(lineEndMarkerAppearance.getLineMarkerColor().gotoGray(0.5).gotoWhite(0.5));
                    lineEndMarkerAppearance.setLineMarkerSize(lineEndMarkerAppearance.getLineMarkerSize() / 0.5);
                    nextAction = new ACCreateFigureLineShape(this.actionContext, "shadow", (IPMPlanElementRW)this.planElement, points, force, (ILineAppearanceRO)lineAppearance, (ILineMarkerAppearanceRO)lineStartMarkerAppearance, (ILineMarkerAppearanceRO)lineEndMarkerAppearance, true);
                }
            } else {
                if (this.pointsToBeDottedIterator == null) {
                    ArrayList<IPMPointRW> pointsToBeDotted = new ArrayList<IPMPointRW>();
                    Collection<IPMFigureRW> shadowFigures = this.planElement.getShadowFigures();
                    Collection<IPMFigureRW> shadowableFigures = this.planElement.getShadowableFigures();
                    for (IPMFigureRW shadowableFigure : shadowableFigures) {
                        IPMPointListRW shadowableFigurePointList = shadowableFigure.getPointListRW();
                        Points points = shadowableFigurePointList.getPoints();
                        for (IPMFigureRW shadowFigure : shadowFigures) {
                            IPMPointListRW shadowFigurePointList = shadowFigure.getPointListRW();
                            int pointIdx = 0;
                            while (pointIdx < shadowFigurePointList.getPointCount()) {
                                double requiredDistance;
                                Point point = shadowFigurePointList.getPoints().get(pointIdx);
                                double distance = points.getDistanceToBorder(point, true);
                                if (distance == (requiredDistance = Math.sqrt(Math.pow(UpdateShadowsActionIterator.SHADOW_DISTANCE.x, 2.0) + Math.pow(UpdateShadowsActionIterator.SHADOW_DISTANCE.y, 2.0))) || distance == UpdateShadowsActionIterator.SHADOW_DISTANCE.x) {
                                    pointsToBeDotted.add(shadowFigurePointList.getPointRW(pointIdx));
                                }
                                ++pointIdx;
                            }
                        }
                    }
                    this.pointsToBeDottedIterator = pointsToBeDotted.iterator();
                }
                if (this.pointsToBeDottedIterator.hasNext()) {
                    IAnchoringDestinationPoint point = (IAnchoringDestinationPoint)this.pointsToBeDottedIterator.next();
                    IPMFigureRW figure = (IPMFigureRW)point.getAnchoringFigure();
                    PolygonCorner polygonCorner = point.getAnchoringDestinationPositionOnPolygon();
                    Point position = polygonCorner != null ? polygonCorner.getRealPosition() : point.getAnchoringDestinationPosition();
                    Points points = new Points(2);
                    points.add(Point.getAsPoint((Point)position));
                    points.add(position.movePoint(SHADOW_DISTANCE.turn180()));
                    int[] force = new int[]{1};
                    DotsAppearance dotsAppearance = new DotsAppearance();
                    dotsAppearance.setSize(0.5);
                    dotsAppearance.setColor(figure.getLineAppearanceRW().getLineColor().gotoBlack(0.5));
                    nextAction = new ACCreateGraphicalSupplementDots(this.actionContext, points, force, figure, "dots", dotsAppearance);
                }
            }
        }
        return nextAction;
    }
}

