/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.transactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigurePlane;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCFunctionRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREEPCFunction
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private Points functionPoints;
    private int[] functionForce;
    private ILineAppearanceRO lineAppearance;
    private IFillAppearanceRO fill;
    private IPMPlanElementBPREEPCFunctionRO createdFunction;

    public TACreateBPREEPCFunction(IPMPlanRO plan, ActionParameters actionParameters, Points functionPoints, ILineAppearanceRO lineAppearance, IFillAppearanceRO fillAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (lineAppearance != null) : "ILineAppearance is null";
        this.transactionAssertion(functionPoints.size() >= 4, "not enough points describing agent figure");
        this.transactionAssertion(Geo.equals((double)0.0, (double)lineAppearance.getCornerRadius()), "the agent's corner radius is not 0");
        try {
            this.functionPoints = functionPoints;
            this.functionForce = LineHelper.createAlternatingLineForcesClosed((Points)functionPoints);
            this.lineAppearance = lineAppearance;
            this.fill = fillAppearance;
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createFunctionAction();
            }
            case 1: {
                this.createdFunction = (IPMPlanElementBPREEPCFunctionRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createOutlineAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createFunctionAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.epc.function");
    }

    private Action createOutlineAction(ACCreatePlanElement previousAction) {
        return new ACCreateFigurePlane(this.getActionContext(), "outline", previousAction.getCreatedPlanElement(), this.functionPoints, this.functionForce, this.lineAppearance, this.fill, false);
    }

    public IPMPlanElementBPREEPCFunctionRO getCreatedFunction() {
        return this.createdFunction;
    }

    public String toString() {
        return "TACreateBREEPCFunction (Points " + this.functionPoints + ")";
    }
}

