/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.transactions;

import com.arcway.lib.geometry.Points;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanModelObjectRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.actions.ACCreateFigureLineShape;
import com.arcway.planagent.planmodel.actions.ACCreatePlanElement;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.base.transactions.LineHelper;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCControlFlowRO;
import com.arcway.planagent.planmodel.transactions.EXTransactionNotValidException;
import com.arcway.planagent.planmodel.transactions.PredeterminedLengthTransaction;
import java.util.ArrayList;

public class TACreateBPREEPCControlFlow
extends PredeterminedLengthTransaction {
    private static final int STEPS = 2;
    private Points linePoints;
    private ILineAppearanceRO lineAppearance;
    private ILineMarkerAppearanceRO startMarkerAppearance;
    private ILineMarkerAppearanceRO endMarkerAppearance;
    private int[] lineForces;
    private IPMPlanElementBPREEPCControlFlowRO createdControlFlow;

    public TACreateBPREEPCControlFlow(IPMPlanRO plan, ActionParameters actionParameters, Points linePoints, ILineAppearanceRO lineAppearance, ILineMarkerAppearanceRO startMarkerAppearance, ILineMarkerAppearanceRO endMarkerAppearance) {
        super(2, (IPMPlanModelObjectRW)((IPMPlanRW)plan), actionParameters);
        assert (linePoints.size() > 1) : "too few points";
        assert (lineAppearance != null) : "lineAppearance is null";
        assert (startMarkerAppearance != null) : "startMarkerAppearance is null";
        assert (endMarkerAppearance != null) : "endMarkerAppearance is null";
        try {
            this.linePoints = linePoints;
            this.lineAppearance = lineAppearance;
            this.startMarkerAppearance = startMarkerAppearance;
            this.endMarkerAppearance = endMarkerAppearance;
            this.lineForces = LineHelper.createAlternatingLineForcesOpen((Points)linePoints);
        }
        catch (EXTransactionNotValidException e) {
            this.setInvalid(e);
        }
    }

    public Action createAction(int n, ArrayList<Action> previousActions) {
        switch (n) {
            case 0: {
                return this.createArcAction();
            }
            case 1: {
                this.createdControlFlow = (IPMPlanElementBPREEPCControlFlowRO)((ACCreatePlanElement)previousActions.get(n - 1)).getCreatedPlanElement();
                return this.createControlFlowAction((ACCreatePlanElement)previousActions.get(n - 1));
            }
        }
        return null;
    }

    private Action createArcAction() {
        return new ACCreatePlanElement(this.getActionContext(), (IPMPlanRW)this.getTransactionRoot(), "bpre.epc.controlflow");
    }

    private Action createControlFlowAction(ACCreatePlanElement createElementAction) {
        return new ACCreateFigureLineShape(this.getActionContext(), "outline", createElementAction.getCreatedPlanElement(), this.linePoints, this.lineForces, this.lineAppearance, this.startMarkerAppearance, this.endMarkerAppearance, false);
    }

    public IPMPlanElementBPREEPCControlFlowRO getCreatedControlFlow() {
        return this.createdControlFlow;
    }

    public String toString() {
        return "TACreateBPREEPCControlFlow (Points " + this.linePoints + ")";
    }
}

