/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.implementation;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMLineRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointListRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.appearance.ILineAppearance;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithOptionalShadowRO;
import com.arcway.planagent.planmodel.base.access.readwrite.IPMPlanElementWithOptionalShadowRW;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCFunctionRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readwrite.IPMPlanElementBPREEPCFunctionRW;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementStickmanRO;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementStickmanRW;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementStickman;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.routing.ResizeSupplementFittingStraightLineRouter;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ForceValidFiguresTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementBPREEPCFunction
extends PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementBPREEPCFunctionRO,
IPMPlanElementBPREEPCFunctionRW,
IPMPlanElementWithOptionalShadowRO,
IPMPlanElementWithOptionalShadowRW {
    public static final String XML_TYPE = "bpre.epc.function";
    public static final String XML_SUPPLEMENT_STICKMAN_ROLE = "stickman";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";

    @Deprecated
    public PMPlanElementBPREEPCFunction(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    public PMPlanElementBPREEPCFunction(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    public ITransactionValidator getTransactionValidator() {
        return new ForceValidFiguresTransactionValidator((IPMPlanElementRO)this);
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = (PMFigure)this.getOutlineFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1);
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    public Collection getShadowFigures() {
        return this.getFiguresRO("shadow");
    }

    public Collection getShadowableFigures() {
        return Collections.singleton(this.getOutlineFigure());
    }

    public Points getShadowGeometry(IPMFigureRW shadowableFigure) {
        Points shadowPoints = new Points(6);
        IPMPointListRW originalPoints = shadowableFigure.getPointListRW();
        int i = 0;
        while (i < originalPoints.getLineCount()) {
            IPMLineRW line = originalPoints.getLineRW(i);
            if (line.getForce() == 3) {
                Point firstPoint = line.getPoint1stRW().getPosition();
                Point secondPoint = line.getPoint2ndRW().getPosition();
                Point startPoint = Point.getAsPoint((Point)firstPoint);
                Point endPoint = Point.getAsPoint((Point)secondPoint);
                double x = startPoint.x;
                shadowPoints.add(startPoint);
                if (startPoint.x > line.getPoint1stRW().getLine1stRW().getPoint1stRW().getPosition().x && endPoint.x > line.getPoint2ndRW().getLine2ndRW().getPoint2ndRW().getPosition().x) {
                    x = startPoint.x + 3.0;
                    double y = startPoint.y < endPoint.y ? (endPoint.y - startPoint.y) / 2.0 + startPoint.y : (startPoint.y - endPoint.y) / 2.0 + endPoint.y;
                    Point arrow = new Point(x, y);
                    shadowPoints.add(arrow);
                }
                shadowPoints.add(endPoint);
            }
            ++i;
        }
        return shadowPoints;
    }

    public ILineAppearance getShadowLineAppearance() {
        LineAppearance lineAppearance = new LineAppearance((ILineAppearanceRO)((PMFigure)this.getOutlineFigure()).getLineAppearance());
        lineAppearance.setCornerRadius(0.0);
        return lineAppearance;
    }

    public ILineAppearanceRO getShadowLineAppearanceRO() {
        return this.getShadowLineAppearance();
    }

    public PMGraphicalSupplementStickman getStickman() {
        PMFigure outlineFigure = (PMFigure)this.getFigureForStickman();
        assert (outlineFigure != null) : "outlineFigure is NULL.";
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_STICKMAN_ROLE);
        assert (supplementRefs != null) : "supplementRefs is NULL.";
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1) : "supplementRefs does not contain exactly one element";
        return (PMGraphicalSupplementStickman)supplementRefs.get(0);
    }

    public IPMGraphicalSupplementStickmanRO getStickmanRO() {
        return this.getStickman();
    }

    public IPMGraphicalSupplementStickmanRW getStickmanRW() {
        return this.getStickman();
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null) : "ref to graphSuppl is null";
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW())) : "the graSuppl does not belong to this planelement";
        if (this.getStickman() == graphSuppl) {
            return new ResizeSupplementFittingStraightLineRouter(graphSuppl);
        }
        return super.getResizeSupplementRouter(graphSuppl);
    }

    public String getStickmanRole() {
        return XML_SUPPLEMENT_STICKMAN_ROLE;
    }

    public IPMFigureRW getFigureForStickman() {
        return this.getOutlineFigureRW();
    }

    public boolean isBendable(PMFigure figure) {
        assert (this.getFigureIndex(figure) >= 0);
        if (figure.getRole().equals("outline")) {
            return true;
        }
        return super.isBendable(figure);
    }

    public boolean hasRelevantGeometryAdaption() {
        return true;
    }

    public int getVerticalGiveWayAlignmentForNameSupplement() {
        return 8;
    }

    public int getHorizontalGiveWayAlignmentForNameSupplement() {
        return 1;
    }
}

