/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.implementation;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.controllinginterface.planagent.TopologyType;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigurePlaneRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanObjectRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointListRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMGraphicalSupplementRW;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithLineShapeOutlineRO;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCEventRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readwrite.IPMPlanElementBPREEPCEventRW;
import com.arcway.planagent.planmodel.cm.access.readonly.IPMGraphicalSupplementTextRO;
import com.arcway.planagent.planmodel.cm.access.readwrite.IPMGraphicalSupplementTextRW;
import com.arcway.planagent.planmodel.cm.actions.ACSetTextGraphicalSupplementText;
import com.arcway.planagent.planmodel.cm.implementation.PMGraphicalSupplementText;
import com.arcway.planagent.planmodel.implementation.PMFigure;
import com.arcway.planagent.planmodel.implementation.PMFigurePlane;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EOPlanElement;
import com.arcway.planagent.planmodel.routing.AbstractResizeSupplementRouter;
import com.arcway.planagent.planmodel.transactions.ForceValidPointsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PMPlanElementBPREEPCEvent
extends PMPlanElementWithPlaneOutlineAndNameAndDescriptionSupplement
implements IPMPlanElementBPREEPCEventRO,
IPMPlanElementBPREEPCEventRW {
    public static final String XML_FIGURE_EVENT_ROLE = "event";
    public static final String XML_FIGURE_GEOMETRYFIGURE_ROLE = "geometryFigure";
    public static final String XML_SUPPLEMENT_COMMENT_ROLE = "comment";
    public static final String XML_TYPE = "bpre.epc.event";

    @Deprecated
    public PMPlanElementBPREEPCEvent(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    @Deprecated
    public PMPlanElementBPREEPCEvent(PlanModelMgr planModelMgr, EOPlanElement eo) {
        super(planModelMgr, eo);
    }

    public TopologyType getToplogyType() {
        return TopologyType.DEEP;
    }

    public Action createSetCommentAction(String comment, ActionContext actionContext) {
        PMGraphicalSupplementText graphicalSupplementText = this.getComment();
        return graphicalSupplementText == null ? null : new ACSetTextGraphicalSupplementText(actionContext, (IPMGraphicalSupplementTextRW)graphicalSupplementText, comment);
    }

    public IPMGraphicalSupplementTextRO getCommentRO() {
        return this.getComment();
    }

    public IPMGraphicalSupplementTextRW getCommentRW() {
        return this.getComment();
    }

    public String getCommentTextRole() {
        return XML_SUPPLEMENT_COMMENT_ROLE;
    }

    public Collection<IPMFigureRO> getEditFigures() {
        return Collections.singleton(this.getGeometryFigure());
    }

    @Override
    public IPMFigurePlaneRO getEventFigureRO() {
        return this.getEventFigure();
    }

    @Override
    public IPMFigurePlaneRW getEventFigureRW() {
        return this.getEventFigure();
    }

    public IPMFigureRW getFigureToCommentRW() {
        return this.getOutlineFigureRW();
    }

    @Override
    public IPMFigurePlaneRO getGeometryFigureRO() {
        return (IPMFigurePlaneRO)this.getGeometryFigure();
    }

    @Override
    public IPMFigurePlaneRW getGeometryFigureRW() {
        return (IPMFigurePlaneRW)this.getGeometryFigure();
    }

    public PMFigure getOutlineFigure() {
        return (PMFigure)this.getGeometryFigure();
    }

    protected PMFigure getNestingInlineFigure() {
        return this.getEventFigure();
    }

    protected IPMPlanObjectRO getProjectionAreaDefiningPlanObject() {
        return this.getEventFigure();
    }

    public AbstractResizeSupplementRouter getResizeSupplementRouter(IPMGraphicalSupplementRW graphSuppl) {
        assert (graphSuppl != null);
        assert (this.getPlanElementRW().equals(graphSuppl.getPlanElementRW()));
        return super.getResizeSupplementRouter(graphSuppl);
    }

    public ITransactionValidator getTransactionValidator() {
        return new ForceValidPointsTransactionValidator((IPMPlanElementRO)this, new Point(7.5, 0.0));
    }

    public int getNumberOfIncomingEdges() {
        int pointCount = 0;
        PMFigurePlane outlineFigure = this.getEventFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!(figure.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)figure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle() != LineMarker.NONE && startPoint.equals(anchorPoint)) {
                ++pointCount;
            }
            if (edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle() == LineMarker.NONE || !endPoint.equals(anchorPoint)) continue;
            ++pointCount;
        }
        return pointCount;
    }

    public int getNumberOfOutgoingEdges() {
        int pointCount = 0;
        PMFigurePlane outlineFigure = this.getEventFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!(figure.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)figure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (edge.getLineStartMarkerAppearanceRO().getLineMarkerStyle() == LineMarker.NONE && startPoint.equals(anchorPoint)) {
                ++pointCount;
            }
            if (edge.getLineEndMarkerAppearanceRO().getLineMarkerStyle() != LineMarker.NONE || !endPoint.equals(anchorPoint)) continue;
            ++pointCount;
        }
        return pointCount;
    }

    public boolean isIncomingEdge(IPMFigureRO sourceFigure) {
        PMFigurePlane outlineFigure = this.getEventFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!figure.equals(sourceFigure)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)sourceFigure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO endPoint = edgePoints.getPointRO(edge.getPointListRO().getPointCount() - 1);
            if (!endPoint.equals(anchorPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutgoingEdge(IPMFigureRO sourceFigure) {
        PMFigurePlane outlineFigure = this.getEventFigure();
        ArrayList<PMFigurePlane> destinationContributors = new ArrayList<PMFigurePlane>();
        destinationContributors.add(outlineFigure);
        Collection anchorings = AnchoringContributorTraverser.getAllAnchorings((Collection)Collections.EMPTY_LIST, destinationContributors);
        for (IAnchoring anchoring : anchorings) {
            IPMFigureRO figure = anchoring.getAnchoringSource().getAnchoringFigure();
            if (!figure.equals(sourceFigure)) continue;
            IPMFigureLineShapeRO edge = ((IPMPlanElementWithLineShapeOutlineRO)sourceFigure.getPlanElementRO()).getOutlineFigureLineShapeRO();
            IPMPointRO anchorPoint = ((IPMAnchoringPointRO)anchoring).getPointRO();
            IPMPointListRO edgePoints = edge.getPointListRO();
            IPMPointRO startPoint = edgePoints.getPointRO(0);
            if (!startPoint.equals(anchorPoint)) continue;
            return true;
        }
        return false;
    }

    public PMGraphicalSupplementText getNameSupplement() {
        PMGraphicalSupplementText supplement = null;
        IPMFigureRO geometryFigure = this.getGeometryFigure();
        ArrayList textSupplements = geometryFigure == null ? new ArrayList(1) : geometryFigure.getGraphicalSupplements("nameSupplement");
        PMFigurePlane eventFigure = this.getEventFigure();
        if (eventFigure != null) {
            textSupplements.addAll(eventFigure.getGraphicalSupplements("nameSupplement"));
        }
        if (textSupplements.size() == 1) {
            supplement = (PMGraphicalSupplementText)textSupplements.get(0);
        }
        return supplement;
    }

    private PMGraphicalSupplementText getComment() {
        PMFigure outlineFigure = this.getOutlineFigure();
        assert (outlineFigure != null);
        List supplementRefs = outlineFigure.getGraphicalSupplements(XML_SUPPLEMENT_COMMENT_ROLE);
        if (supplementRefs.size() == 0) {
            return null;
        }
        assert (supplementRefs.size() == 1);
        return (PMGraphicalSupplementText)supplementRefs.get(0);
    }

    private PMFigurePlane getEventFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_EVENT_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1) : "more than one event figure found";
        return (PMFigurePlane)figures.get(0);
    }

    private IPMFigureRO getGeometryFigure() {
        List figures = this.getFiguresRO(XML_FIGURE_GEOMETRYFIGURE_ROLE);
        if (figures.size() == 0) {
            return null;
        }
        assert (figures.get(0) instanceof PMFigurePlane);
        assert (figures.size() == 1);
        return (IPMFigureRO)figures.get(0);
    }

    public boolean hasRelevantGeometryAdaption() {
        return true;
    }

    public boolean isHighlightableFigure(PMFigure figureToCheck) {
        boolean isEventFigure = figureToCheck.getRole().equals(XML_FIGURE_EVENT_ROLE);
        return isEventFigure && super.isHighlightableFigure(figureToCheck);
    }
}

