/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.check;

import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointRO;
import com.arcway.planagent.planmodel.access.readonly.IPMAnchoringPointToFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureLineShapeRO;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPointRO;
import com.arcway.planagent.planmodel.anchoring.AnchoringContributorTraverser;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationContributor;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourceContributor;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithLineShapeOutlineRO;
import com.arcway.planagent.planmodel.base.implementation.PMPlanElementWithOutline;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCControlFlowRO;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCLogicalOperatorRO;
import com.arcway.planagent.planmodel.bpre.epc.check.BPREEPCValidityMatrix;
import com.arcway.planagent.planmodel.bpre.epc.check.ProblemBadCombination;
import com.arcway.planagent.planmodel.bpre.epc.check.ProblemBadConnection;
import com.arcway.planagent.planmodel.bpre.epc.check.ProblemBadControlFlow;
import com.arcway.planagent.planmodel.bpre.epc.check.ProblemEventConnectedToIllegalOperator;
import com.arcway.planagent.planmodel.bpre.epc.check.ProblemIllegalConnectionsToLogicalOperator;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCEvent;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCLogicalOperatorOR;
import com.arcway.planagent.planmodel.bpre.epc.implementation.PMPlanElementBPREEPCLogicalOperatorXOR;
import com.arcway.planagent.planmodel.check.IModelSyntaxChecker;
import com.arcway.planagent.planmodel.check.ISyntaxProblem;
import com.arcway.planagent.planmodel.check.SyntaxProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class BPREEPCModelSyntaxChecker
implements IModelSyntaxChecker {
    public Collection<? extends ISyntaxProblem> checkSyntax(IPMPlanRO plan) {
        ArrayList<SyntaxProblem> problems = new ArrayList<SyntaxProblem>();
        int elementNumber = plan.getPlanElementCount();
        int i = 0;
        while (i < elementNumber) {
            IPMPlanElementRO pe = plan.getPlanElementRO(i);
            if (pe instanceof IPMPlanElementBPREEPCControlFlowRO) {
                IPMFigureLineShapeRO edge;
                IPMFigureRO fig;
                IPMAnchoringPointToFigureRO anchoring;
                int j;
                int anchoringCount;
                SyntaxProblem prob;
                IPMFigureLineShapeRO figure = null;
                figure = ((IPMPlanElementBPREEPCControlFlowRO)pe).getEdgeRO();
                IPMPointRO startPoint = figure.getPointListRO().getPointRO(0);
                IPMPointRO endPoint = figure.getPointListRO().getPointRO(figure.getPointListRO().getPointCount() - 1);
                LineMarker lineMarkerStyleStartPoint = figure.getLineStartMarkerAppearanceRO().getLineMarkerStyle();
                LineMarker lineMarkerStyleEndPoint = figure.getLineEndMarkerAppearanceRO().getLineMarkerStyle();
                if (lineMarkerStyleStartPoint == LineMarker.NONE && lineMarkerStyleEndPoint == LineMarker.NONE || lineMarkerStyleStartPoint != LineMarker.NONE && lineMarkerStyleEndPoint != LineMarker.NONE) {
                    ProblemBadControlFlow prob2 = new ProblemBadControlFlow(pe);
                    problems.add(prob2);
                }
                IPMAnchoringPointRO anchoring1 = startPoint.getAnchoringRO();
                IPMAnchoringPointRO anchoring2 = endPoint.getAnchoringRO();
                IPMFigureRO linkedFigure1 = null;
                IPMFigureRO linkedFigure2 = null;
                IPMPlanElementRO linkedPlanElement1 = null;
                IPMPlanElementRO linkedPlanElement2 = null;
                if (anchoring1 != null) {
                    linkedFigure1 = anchoring1.getAnchoringDestination().getAnchoringFigure();
                    linkedPlanElement1 = linkedFigure1.getPlanElementRO();
                    if (!anchoring1.isDesirable()) {
                        prob = new ProblemBadConnection(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement1);
                        anchoringCount = linkedFigure1.getAnchoringCount();
                        j = 0;
                        while (j < anchoringCount) {
                            anchoring = linkedFigure1.getAnchoringRO(j);
                            fig = anchoring.getAnchoringSource().getAnchoringFigure();
                            if (fig.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO) {
                                edge = ((IPMPlanElementWithLineShapeOutlineRO)fig.getPlanElementRO()).getOutlineFigureLineShapeRO();
                                prob.addOtherInvolvedElement(edge.getPlanElementRO());
                            }
                            ++j;
                        }
                        problems.add(prob);
                    }
                }
                if (anchoring2 != null) {
                    linkedFigure2 = anchoring2.getAnchoringDestination().getAnchoringFigure();
                    linkedPlanElement2 = linkedFigure2.getPlanElementRO();
                    if (!anchoring2.isDesirable()) {
                        prob = new ProblemBadConnection(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement2);
                        anchoringCount = linkedFigure2.getAnchoringCount();
                        j = 0;
                        while (j < anchoringCount) {
                            anchoring = linkedFigure2.getAnchoringRO(j);
                            fig = anchoring.getAnchoringSource().getAnchoringFigure();
                            if (fig.getPlanElementRO() instanceof IPMPlanElementWithLineShapeOutlineRO) {
                                edge = ((IPMPlanElementWithLineShapeOutlineRO)fig.getPlanElementRO()).getOutlineFigureLineShapeRO();
                                prob.addOtherInvolvedElement(edge.getPlanElementRO());
                            }
                            ++j;
                        }
                        problems.add(prob);
                    }
                }
                if (linkedFigure1 != null && linkedFigure2 != null) {
                    if (linkedFigure1.getPlanElementRO() instanceof PMPlanElementBPREEPCEvent && (linkedFigure2.getPlanElementRO() instanceof PMPlanElementBPREEPCLogicalOperatorXOR || linkedFigure2.getPlanElementRO() instanceof PMPlanElementBPREEPCLogicalOperatorOR)) {
                        if (!BPREEPCValidityMatrix.isCombinationValid(linkedFigure1, linkedFigure2) || !BPREEPCValidityMatrix.isCombinationValid(linkedFigure2, linkedFigure1)) {
                            prob = new ProblemEventConnectedToIllegalOperator(pe);
                            prob.addOtherInvolvedElement(linkedPlanElement1);
                            prob.addOtherInvolvedElement(linkedPlanElement2);
                            problems.add(prob);
                        }
                    } else if (linkedFigure2.getPlanElementRO() instanceof PMPlanElementBPREEPCEvent && (linkedFigure1.getPlanElementRO() instanceof PMPlanElementBPREEPCLogicalOperatorXOR || linkedFigure1.getPlanElementRO() instanceof PMPlanElementBPREEPCLogicalOperatorOR)) {
                        if (!BPREEPCValidityMatrix.isCombinationValid(linkedFigure1, linkedFigure2) || !BPREEPCValidityMatrix.isCombinationValid(linkedFigure2, linkedFigure1)) {
                            prob = new ProblemEventConnectedToIllegalOperator(pe);
                            prob.addOtherInvolvedElement(linkedPlanElement1);
                            prob.addOtherInvolvedElement(linkedPlanElement2);
                            problems.add(prob);
                        }
                    } else if (!BPREEPCValidityMatrix.isCombinationValid(linkedFigure1, linkedFigure2)) {
                        prob = new ProblemBadCombination(pe);
                        prob.addOtherInvolvedElement(linkedPlanElement1);
                        prob.addOtherInvolvedElement(linkedPlanElement2);
                        problems.add(prob);
                    }
                }
            } else if (pe instanceof IPMPlanElementBPREEPCLogicalOperatorRO && !BPREEPCValidityMatrix.isLogicalOperatorConnectionValid(((PMPlanElementWithOutline)pe).getOutlineFigureRO())) {
                ProblemIllegalConnectionsToLogicalOperator prob = new ProblemIllegalConnectionsToLogicalOperator(pe);
                ArrayList<IAnchoringDestinationContributor> destinationContributors = new ArrayList<IAnchoringDestinationContributor>();
                destinationContributors.add((IAnchoringDestinationContributor)((PMPlanElementWithOutline)pe).getOutlineFigureRO());
                Collection anchorings = AnchoringContributorTraverser.getAllAnchorings(Collections.emptyList(), destinationContributors);
                for (IAnchoring anchoring : anchorings) {
                    IPMFigureRO controlFlow = anchoring.getAnchoringSource().getAnchoringFigure();
                    prob.addOtherInvolvedElement(controlFlow.getPlanElementRO());
                    ArrayList<IAnchoringSourceContributor> sourceContributors = new ArrayList<IAnchoringSourceContributor>();
                    sourceContributors.add((IAnchoringSourceContributor)controlFlow);
                    Collection controlFlowAnchorings = AnchoringContributorTraverser.getAllAnchorings(sourceContributors, Collections.emptyList());
                    for (IAnchoring controlFlowAnchoring : controlFlowAnchorings) {
                        IPMFigureRO anchoredFigure = controlFlowAnchoring.getAnchoringDestination().getAnchoringFigure();
                        prob.addOtherInvolvedElement(anchoredFigure.getPlanElementRO());
                    }
                }
                problems.add(prob);
            }
            ++i;
        }
        return problems;
    }

    public String[] getCheckablePlanTypes() {
        return new String[]{"bpre.epc"};
    }
}

