/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.bpre.epc.appearance;

import com.arcway.lib.graphics.Color;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.appearance.IAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ITextAppearanceRO;
import com.arcway.planagent.planmodel.appearance.TextAppearance;
import com.arcway.planagent.planmodel.bpre.epc.appearance.IBPREEPCXORSymbolAppearance;
import com.arcway.planagent.planmodel.bpre.epc.appearance.IBPREEPCXORSymbolAppearanceRO;

public class BPREEPCXORSymbolAppearance
implements IBPREEPCXORSymbolAppearance {
    private static final ILogger logger = Logger.getLogger(BPREEPCXORSymbolAppearance.class);
    private Color color = new Color(0, 0, 0);
    private ITextAppearanceRO textAppearance = this.getDefaultTextAppearance();

    public BPREEPCXORSymbolAppearance() {
    }

    public BPREEPCXORSymbolAppearance(IBPREEPCXORSymbolAppearance source) {
        if (logger.isDebugEnabled()) {
            logger.trace("ORSymbolAppearance(IORSymbolAppearancee source = " + source + ") - start");
        }
        assert (source != null) : "source object is NULL";
        this.setAppearanceFrom(source);
        if (logger.isDebugEnabled()) {
            logger.trace("ORSymbolAppearance(IORSymbolAppearance) - end");
        }
    }

    private ITextAppearanceRO getDefaultTextAppearance() {
        TextAppearance txtAppearance = new TextAppearance();
        txtAppearance.setAlignment(DEFAULT_TEXT_ALIGNMENT);
        txtAppearance.setInsets(DEFAULT_TEXT_INSETS);
        txtAppearance.setTextColor(new Color(0, 0, 0));
        txtAppearance.setTextStyle(DEFAULT_TEXT_STYLE);
        txtAppearance.setTextLineHeight(4.5);
        return txtAppearance;
    }

    public void setAppearanceFrom(IAppearanceRO appearance) {
        if (!(appearance instanceof IBPREEPCXORSymbolAppearanceRO)) {
            return;
        }
        IBPREEPCXORSymbolAppearanceRO xorSymbolAppearance = (IBPREEPCXORSymbolAppearanceRO)appearance;
        this.setColor(xorSymbolAppearance.getColor());
        this.setTextAppearance(xorSymbolAppearance.getTextAppearanceRO());
    }

    public IAppearanceRO getAppearanceAsCopy() {
        return new BPREEPCXORSymbolAppearance(this);
    }

    @Override
    public ITextAppearanceRO getTextAppearanceRO() {
        return this.textAppearance;
    }

    @Override
    public void setTextAppearance(ITextAppearanceRO textAppearance) {
        this.textAppearance = new TextAppearance(textAppearance);
    }

    @Override
    public Color getColor() {
        return new Color(this.color);
    }

    @Override
    public void setColor(Color color) {
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color color = " + color + ") - start");
        }
        assert (color != null) : "color is NULL.";
        this.color = new Color(color);
        if (logger.isDebugEnabled()) {
            logger.trace("setColor(Color) - end");
        }
    }
}

