/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.acm.pd.reactions;

import com.arcway.lib.geometry.Geo;
import com.arcway.lib.geometry.GeoVector;
import com.arcway.lib.geometry.Point;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigurePlaneRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMFigureRW;
import com.arcway.planagent.planmodel.access.readwrite.IPMPointRW;
import com.arcway.planagent.planmodel.acm.pd.access.readwrite.IPMPlanElementACMPDStartProcessStepRW;
import com.arcway.planagent.planmodel.actions.ACMovePoint;
import com.arcway.planagent.planmodel.actions.Action;
import com.arcway.planagent.planmodel.actions.ActionContext;
import com.arcway.planagent.planmodel.actions.ActionFactory;
import com.arcway.planagent.planmodel.actions.ActionIterator;
import com.arcway.planagent.planmodel.actions.PredeterminedActionIterator;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.reactions.FigureMovements;
import com.arcway.planagent.planmodel.reactions.IRAChangeGeometryFigure;
import com.arcway.planagent.planmodel.reactions.IRAMoveFigure;
import com.arcway.planagent.planmodel.reactions.PositionAndPoint;
import java.util.List;

public class RAFixStartArrow
implements IRAChangeGeometryFigure,
IRAMoveFigure {
    private static final ILogger logger = Logger.getLogger(RAFixStartArrow.class);

    public ActionIterator createReactionsFigureGeometryChanged(IPMFigureRW figure, List<PositionAndPoint> oldGeometry, ActionContext actionContext) {
        if (logger.isTraceEnabled()) {
            logger.trace("RAFixAnchoringsAfterFigureModify createReactions(" + figure + ") - start");
        }
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6);
        this.addFixActions(figure, actionContext, actions);
        if (actions.isEmpty()) {
            actions = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getReActionIterator(Action) - end - return value = " + actions);
        }
        return actions;
    }

    public ActionIterator createReactionsFiguresMoved(FigureMovements figureMovements, ActionContext context) {
        PredeterminedActionIterator actions = new PredeterminedActionIterator(6 * figureMovements.size());
        for (IPMFigureRW figure : figureMovements) {
            this.addFixActions(figure, context, actions);
        }
        if (actions.isEmpty()) {
            actions = null;
        }
        return actions;
    }

    private void addFixActions(IPMFigureRW figure, ActionContext actionContext, PredeterminedActionIterator actions) {
        IPMFigurePlaneRW geometryFigure = null;
        boolean route = true;
        if (route && !(figure.getPlanElementRW() instanceof IPMPlanElementACMPDStartProcessStepRW)) {
            route &= false;
        }
        if (route && !(figure instanceof IPMFigurePlaneRW)) {
            route &= false;
        }
        if (route) {
            IPMFigurePlaneRW plane = (IPMFigurePlaneRW)figure;
            if (!plane.getRole().equals("geometryFigure")) {
                route &= false;
            }
            if (route) {
                geometryFigure = plane;
            }
        }
        if (geometryFigure != null) {
            IPMFigurePlaneRW oldArrowFigure = ((IPMPlanElementACMPDStartProcessStepRW)geometryFigure.getPlanElementRW()).getArrowFigureRW();
            IPMPointRW outerRightPoint = null;
            IPMPointRW upperLeftPoint = null;
            IPMPointRW lowerLeftPoint = null;
            IPMPointRW upperRightPoint = null;
            IPMPointRW lowerRightPoint = null;
            int i = 0;
            while (i < oldArrowFigure.getPointListRW().getPointCount()) {
                IPMPointRW currentPoint = oldArrowFigure.getPointListRW().getPointRW(i);
                IPMPointRW firstNeighbor = currentPoint.getLine1stRW().getPoint1stRW();
                IPMPointRW secondNeighbor = currentPoint.getLine2ndRW().getPoint2ndRW();
                if (outerRightPoint == null) {
                    outerRightPoint = currentPoint;
                    upperLeftPoint = currentPoint;
                    lowerLeftPoint = currentPoint;
                } else {
                    if (currentPoint.getPosition().x + 1.0E-10 > outerRightPoint.getPosition().x) {
                        outerRightPoint = currentPoint;
                        if (firstNeighbor.getPosition().y + 1.0E-10 < outerRightPoint.getPosition().y) {
                            upperRightPoint = firstNeighbor;
                            lowerRightPoint = secondNeighbor;
                        } else {
                            lowerRightPoint = firstNeighbor;
                            upperRightPoint = secondNeighbor;
                        }
                    }
                    if (currentPoint.getPosition().x + 1.0E-10 < lowerLeftPoint.getPosition().x) {
                        upperLeftPoint = currentPoint;
                        if (upperLeftPoint.getPosition().x == firstNeighbor.getPosition().x) {
                            lowerLeftPoint = firstNeighbor;
                            if (upperLeftPoint.getPosition().y > firstNeighbor.getPosition().y) {
                                lowerLeftPoint = upperLeftPoint;
                                upperLeftPoint = firstNeighbor;
                            }
                        } else {
                            lowerLeftPoint = secondNeighbor;
                            if (upperLeftPoint.getPosition().y > secondNeighbor.getPosition().y) {
                                lowerLeftPoint = upperLeftPoint;
                                upperLeftPoint = secondNeighbor;
                            }
                        }
                    }
                }
                ++i;
            }
            IPMPointRW upperLeftGeometry = null;
            IPMPointRW lowerRightGeometry = null;
            int i2 = 0;
            while (i2 < geometryFigure.getPointListRW().getPointCount()) {
                IPMPointRW currentPoint = geometryFigure.getPointListRW().getPointRW(i2);
                if (upperLeftGeometry == null) {
                    upperLeftGeometry = currentPoint;
                } else if (currentPoint.getPosition().y + 1.0E-10 < upperLeftGeometry.getPosition().y) {
                    upperLeftGeometry = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)upperLeftGeometry.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 < upperLeftGeometry.getPosition().x) {
                    upperLeftGeometry = currentPoint;
                }
                if (lowerRightGeometry == null) {
                    lowerRightGeometry = currentPoint;
                } else if (currentPoint.getPosition().y - 1.0E-10 > lowerRightGeometry.getPosition().y) {
                    lowerRightGeometry = currentPoint;
                } else if (Geo.equals((double)currentPoint.getPosition().y, (double)lowerRightGeometry.getPosition().y) && currentPoint.getPosition().x - 1.0E-10 > lowerRightGeometry.getPosition().x) {
                    lowerRightGeometry = currentPoint;
                }
                ++i2;
            }
            assert (upperLeftPoint != null) : "upper left point has not been calculated";
            assert (lowerLeftPoint != null) : "lower left point has not been calculated";
            assert (upperRightPoint != null) : "upper right point has not been calculated";
            assert (lowerRightPoint != null) : "lower right point has not been calculated";
            assert (outerRightPoint != null) : "outer right point has not been calculated";
            assert (upperLeftGeometry != null) : "upper left point of geometry figure has not been calculated";
            assert (lowerRightGeometry != null) : "lower right point of geometry figure has not been calculated";
            ACMovePoint moveUpperLeft = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)upperLeftPoint, (GeoVector)new GeoVector(upperLeftPoint.getPosition(), new Point(upperLeftGeometry.getPosition().x, upperLeftGeometry.getPosition().y)), (boolean)false);
            actions.addAction((Action)moveUpperLeft);
            ACMovePoint moveLowerLeft = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lowerLeftPoint, (GeoVector)new GeoVector(lowerLeftPoint.getPosition(), new Point(upperLeftGeometry.getPosition().x, lowerRightGeometry.getPosition().y)), (boolean)false);
            actions.addAction((Action)moveLowerLeft);
            ACMovePoint moveUpperRight = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)upperRightPoint, (GeoVector)new GeoVector(upperRightPoint.getPosition(), new Point(lowerRightGeometry.getPosition().x, upperLeftGeometry.getPosition().y)), (boolean)false);
            actions.addAction((Action)moveUpperRight);
            Point newOuterRightPosition = new Point(lowerRightGeometry.getPosition().x + 10.0, upperLeftGeometry.getPosition().y + (lowerRightGeometry.getPosition().y - upperLeftGeometry.getPosition().y) / 2.0);
            ACMovePoint moveOuterRight = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)outerRightPoint, (GeoVector)new GeoVector(outerRightPoint.getPosition(), newOuterRightPosition), (boolean)false);
            actions.addAction((Action)moveOuterRight);
            ACMovePoint moveLowerRight = ActionFactory.createACMovePoint((ActionContext)actionContext, (IAnchoringSourcePoint)lowerRightPoint, (GeoVector)new GeoVector(lowerRightPoint.getPosition(), new Point(lowerRightGeometry.getPosition().x, lowerRightGeometry.getPosition().y)), (boolean)false);
            actions.addAction((Action)moveLowerRight);
        }
    }
}

