/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.acm.pd.implementation;

import com.arcway.planagent.controllinginterface.planagent.FlowType;
import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.acm.pd.check.ACMPDValidityMatrix;
import com.arcway.planagent.planmodel.acm.pd.relations.ACMPDPlanElementRelationsMatrix;
import com.arcway.planagent.planmodel.anchoring.IAnchoring;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDecider;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestination;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationPoint;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Figure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringPoint2Point;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSource;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineEndMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineStartMarkerAppearanceRO;
import com.arcway.planagent.planmodel.cm.routing.CurveLineRouter;
import com.arcway.planagent.planmodel.cm.routing.RemoveAnchoringRouter;
import com.arcway.planagent.planmodel.cm.routing.SetPointToPointRouter;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.nesting.INestable;
import com.arcway.planagent.planmodel.nesting.INestingManager;
import com.arcway.planagent.planmodel.persistent.EOPlan;
import com.arcway.planagent.planmodel.relations.PlanElementRelation;
import com.arcway.planagent.planmodel.routing.IRouter;
import com.arcway.planagent.planmodel.routing.IRoutingManager;
import com.arcway.planagent.planmodel.routing.IRoutingParameters;
import com.arcway.planagent.planmodel.transactions.AllowAllTransactionsTransactionValidator;
import com.arcway.planagent.planmodel.transactions.ITransactionValidator;
import java.util.Collection;
import java.util.Collections;

public class PMPlanACMPD
extends PMPlan
implements IAnchoringDecider,
IRoutingManager,
INestingManager {
    public static final String PLAN_TYPE_ID = "acm.pd";
    private static String XML_TYPE = "acm.pd";

    public PMPlanACMPD(PlanModelMgr planModelMgr) {
        super(planModelMgr);
        this.setType(XML_TYPE);
    }

    public PMPlanACMPD(PlanModelMgr planModelMgr, EOPlan eo) {
        super(planModelMgr, eo);
    }

    public boolean decideNesting(INestable inner, INestable outer) {
        boolean nestingAllowed = false;
        return nestingAllowed;
    }

    public Collection<IPMPlanElementRO> getAlsoContainedPlanElementsFor(IPMPlanElementRO planElement) {
        return Collections.emptyList();
    }

    public IAnchoringDecider getAnchoringDecider() {
        return this;
    }

    public INestingManager getNestingManager() {
        return this;
    }

    public IRouter getRouter(IAnchoring anchoring, IRoutingParameters routingParameters) {
        Object router = anchoring instanceof IAnchoringPoint2Figure ? new CurveLineRouter() : (anchoring instanceof IAnchoringPoint2Point ? new SetPointToPointRouter() : new RemoveAnchoringRouter());
        return router;
    }

    public IRoutingManager getRoutingManager() {
        return this;
    }

    public String[] getSupportedPlanElementTypeIDs() {
        return new String[]{"acm.pd.startprocessstep", "acm.pd.processstep", "acm.pd.competency", "acm.pd.edge", "fmc.cm.lineshapecomment", "fmc.cm.planecomment", "fmc.cm.legend", "fmc.cm.dotscomment"};
    }

    public ITransactionValidator getTransactionValidator() {
        return AllowAllTransactionsTransactionValidator.getInstance();
    }

    public boolean isDesirableAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isDesirable = false;
        IPMFigureRO fig1 = source.getAnchoringFigure();
        IPMFigureRO fig2 = destination.getAnchoringFigure();
        return isDesirable |= ACMPDValidityMatrix.isTouchValid(fig1, fig2);
    }

    protected boolean isAllowedAnchoring(IAnchoringSource source, IAnchoringDestination destination) {
        boolean isAllowed = false;
        if (source instanceof IAnchoringSourcePoint) {
            if (destination instanceof IAnchoringDestinationFigure) {
                isAllowed |= ACMPDValidityMatrix.isPointToFigureAnchoringPossible((IAnchoringSourcePoint)source, (IAnchoringDestinationFigure)destination);
            }
            if (destination instanceof IAnchoringDestinationPoint) {
                isAllowed |= ACMPDValidityMatrix.isPointToPointAnchoringPossible();
            }
        }
        return isAllowed;
    }

    public PlanElementRelation analyzePlanElementRelation(String startPlanElementType, String endElementType, ILineStartMarkerAppearanceRO lineStartMarkerAppearanceRO, ILineEndMarkerAppearanceRO lineEndMarkerAppearanceRO, ILineAppearanceRO lineAppearanceRO) {
        int direction = ACMPDPlanElementRelationsMatrix.getRelationDirection((ILineMarkerAppearanceRO)lineStartMarkerAppearanceRO, (ILineMarkerAppearanceRO)lineEndMarkerAppearanceRO);
        if (direction != -1 && ACMPDPlanElementRelationsMatrix.isCausality(startPlanElementType, endElementType)) {
            return new PlanElementRelation(1, direction);
        }
        return null;
    }

    public FlowType getFlowType() {
        return FlowType.HORIZONTAL;
    }
}

