/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planmodel.acm.pd.check;

import com.arcway.planagent.planmodel.access.readonly.IPMFigureRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.acm.pd.access.readonly.IPMPlanElementACMPDEdgeRO;
import com.arcway.planagent.planmodel.acm.pd.access.readonly.IPMPlanElementACMPDProcessStepRO;
import com.arcway.planagent.planmodel.acm.pd.access.readonly.IPMPlanElementACMPDStartProcessStepRO;
import com.arcway.planagent.planmodel.anchoring.IAnchoringDestinationFigure;
import com.arcway.planagent.planmodel.anchoring.IAnchoringSourcePoint;

public class ACMPDValidityMatrix {
    public static boolean isPointToFigureAnchoringPossible(IAnchoringSourcePoint source, IAnchoringDestinationFigure destination) {
        boolean anchoringIsPossible = false;
        IPMFigureRO sourceFigure = source.getAnchoringFigure();
        IPMFigureRO destinationFigure = destination.getAnchoringFigure();
        if (ACMPDValidityMatrix.isEdge(sourceFigure) && ACMPDValidityMatrix.isProcessStep(destinationFigure)) {
            anchoringIsPossible |= true;
        }
        return anchoringIsPossible &= source.getAnchoringFigure().getPlanElementRO() != destination.getAnchoringFigure().getPlanElementRO();
    }

    public static boolean isPointToPointAnchoringPossible() {
        return false;
    }

    public static boolean isTouchValid(IPMFigureRO figure1, IPMFigureRO figure2) {
        boolean touchIsValid = false;
        touchIsValid |= ACMPDValidityMatrix.isDirectedTouchValid(figure1, figure2);
        return touchIsValid |= ACMPDValidityMatrix.isDirectedTouchValid(figure2, figure1);
    }

    private static boolean isDirectedTouchValid(IPMFigureRO sourceFigure, IPMFigureRO destinationFigure) {
        boolean touchIsValid = true;
        touchIsValid = ACMPDValidityMatrix.isEdge(sourceFigure) && ACMPDValidityMatrix.isProcessStep(destinationFigure) ? (touchIsValid |= true) : (touchIsValid &= false);
        return touchIsValid;
    }

    private static boolean isEdge(IPMFigureRO figure) {
        boolean isEdge = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        return isEdge |= planElement instanceof IPMPlanElementACMPDEdgeRO;
    }

    private static boolean isProcessStep(IPMFigureRO figure) {
        boolean isProcessStep = false;
        IPMPlanElementRO planElement = figure.getPlanElementRO();
        if (planElement instanceof IPMPlanElementACMPDProcessStepRO) {
            IPMPlanElementACMPDProcessStepRO processStep = (IPMPlanElementACMPDProcessStepRO)planElement;
            isProcessStep |= processStep.getArrowFigureRO() == figure;
        } else if (planElement instanceof IPMPlanElementACMPDStartProcessStepRO) {
            IPMPlanElementACMPDStartProcessStepRO processStep = (IPMPlanElementACMPDStartProcessStepRO)planElement;
            isProcessStep |= processStep.getArrowFigureRO() == figure;
        }
        return isProcessStep;
    }
}

