/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.plans;

import com.arcway.lib.java.Assert;
import com.arcway.planagent.planimporterexporter.IDataElement;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import java.util.ArrayList;
import java.util.Collection;

public class Plans {
    private final Collection<Plan> plans = new ArrayList<Plan>();
    private final Collection<PlanDirectory> planSubDirectories = new ArrayList<PlanDirectory>();

    public void addPlan(Plan plan) {
        Assert.checkArgumentBeeingNotNull((Object)plan);
        this.plans.add(plan);
    }

    public void addPlanDirectory(PlanDirectory directory) {
        this.planSubDirectories.add(directory);
    }

    public void addPlans(Collection<Plan> plan) {
        Assert.checkArgumentBeeingNotNull(plan);
        this.plans.addAll(plan);
    }

    public Collection<Plan> getAllCheckedPlans() {
        ArrayList<Plan> allPlans = new ArrayList<Plan>();
        for (Plan plan : this.getPlans()) {
            if (!plan.isChecked()) continue;
            allPlans.add(plan);
        }
        for (PlanDirectory subDirectory : this.getPlanDirectories()) {
            if (!subDirectory.isChecked()) continue;
            allPlans.addAll(subDirectory.getAllCheckedPlans());
        }
        return allPlans;
    }

    public Collection<Plan> getAllPlans() {
        ArrayList<Plan> allPlans = new ArrayList<Plan>();
        for (Plan plan : this.plans) {
            allPlans.add(plan);
        }
        for (PlanDirectory subDirectory : this.planSubDirectories) {
            allPlans.addAll(subDirectory.getAllPlans());
        }
        return allPlans;
    }

    public Collection<Object> getAllPlansAndPlanDirectories() {
        ArrayList<Object> plansCollection = new ArrayList<Object>();
        for (Plan plan : this.plans) {
            plansCollection.add(plan);
        }
        for (IDataElement iDataElement : this.planSubDirectories) {
            plansCollection.add(iDataElement);
        }
        return plansCollection;
    }

    public Collection<Plan> getCheckedPlans() {
        Collection<Plan> allPlans = this.getAllPlans();
        ArrayList<Plan> checkedPlans = new ArrayList<Plan>();
        for (Plan plan : allPlans) {
            if (!plan.isChecked()) continue;
            checkedPlans.add(plan);
        }
        return checkedPlans;
    }

    public Collection<Object> getCheckedPlansAndDirectories() {
        ArrayList<Object> plansCollection = new ArrayList<Object>();
        for (Plan plan : this.plans) {
            Plan plan2 = plan;
            if (!plan2.isChecked()) continue;
            plansCollection.add(plan2);
        }
        for (IDataElement iDataElement : this.planSubDirectories) {
            PlanDirectory directory = (PlanDirectory)iDataElement;
            if (!directory.isChecked()) continue;
            plansCollection.add(directory);
        }
        return plansCollection;
    }

    public int getNumberOfCheckedPlansAndPlanDirectories() {
        int i = 0;
        for (Plan plan : this.getPlans()) {
            if (!plan.isChecked()) continue;
            ++i;
        }
        for (PlanDirectory subDirectory : this.getPlanDirectories()) {
            if (!subDirectory.isChecked()) continue;
            ++i;
            i += subDirectory.getNumberOfCheckedPlansAndPlanDirectories();
        }
        return i;
    }

    public Collection<PlanDirectory> getPlanDirectories() {
        return this.planSubDirectories;
    }

    public Collection<Plan> getPlans() {
        return this.plans;
    }

    public void removePlan(Plan plan) {
        this.plans.remove(plan);
    }

    public void removePlanDirectory(PlanDirectory directory) {
        this.planSubDirectories.remove(directory);
    }

    public void dispose() {
        this.plans.clear();
        this.planSubDirectories.clear();
    }
}

