/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.plans;

import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.planimporterexporter.DataElement;
import com.arcway.planagent.planimporterexporter.IDataElement;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.StructuredPlanElementModelWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Plan
extends DataElement {
    private final IPMPlanRO loadedPlan;
    private Map<String, IDataElement> planElementUID2dataElement = new HashMap<String, IDataElement>();
    private boolean checked;

    public Plan(IPMPlanRO plan, String name, String description, Map<String, IDataElement> planElementUID2dataElement, boolean checked) {
        super(name, description);
        this.loadedPlan = plan;
        if (planElementUID2dataElement != null) {
            this.planElementUID2dataElement = planElementUID2dataElement;
        }
        this.checked = checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        PMPlan plan = (PMPlan)this.loadedPlan;
        if (plan != null) {
            plan.setName(name);
        }
    }

    public IPMPlanRO getLoadedPlan() {
        return this.loadedPlan;
    }

    public Collection<IPlanAgentPlanElement> getPlanStructure() {
        ArrayList<IPlanAgentPlanElement> structuredPlanElements = new ArrayList<IPlanAgentPlanElement>();
        int i = 0;
        while (i < this.loadedPlan.getPlanElementCount()) {
            IPMPlanElementRO element = this.loadedPlan.getPlanElementRO(i);
            new StructuredPlanElementModelWrapper(element);
            structuredPlanElements.add((IPlanAgentPlanElement)new StructuredPlanElementModelWrapper(element));
            ++i;
        }
        return structuredPlanElements;
    }

    public Map<String, IDataElement> getPlanElement2DataElement() {
        return this.planElementUID2dataElement;
    }

    public IDataElement getDataElementForPlanElement(String planElementUID) {
        return this.planElementUID2dataElement.get(planElementUID);
    }
}

