/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.bpre.epc;

import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.EXSetupPlanException;
import com.arcway.planagent.planimporterexporter.bpre.epc.EPCPlanElementGeneratorControlFlow;
import com.arcway.planagent.planimporterexporter.bpre.epc.EPCPlanElementGeneratorEvent;
import com.arcway.planagent.planimporterexporter.bpre.epc.EPCPlanElementGeneratorFunction;
import com.arcway.planagent.planimporterexporter.bpre.epc.EPCPlanElementGeneratorStorage;
import com.arcway.planagent.planimporterexporter.bpre.epc.Messages;
import com.arcway.planagent.planimporterexporter.graphs.Graph;
import com.arcway.planagent.planimporterexporter.graphs.GraphDirectory;
import com.arcway.planagent.planimporterexporter.graphs.Graphs;
import com.arcway.planagent.planimporterexporter.graphs.Node;
import com.arcway.planagent.planimporterexporter.plangeneration.AbstractPlanElementGenerator;
import com.arcway.planagent.planimporterexporter.plangeneration.IPlanGenerator;
import com.arcway.planagent.planimporterexporter.plans.Plan;
import com.arcway.planagent.planimporterexporter.plans.PlanDirectory;
import com.arcway.planagent.planimporterexporter.plans.Plans;
import com.arcway.planagent.planmodel.PlanModelDirectAccessTool;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.access.readwrite.IPMPlanRW;
import com.arcway.planagent.planmodel.implementation.EXPlanModelObjectFactoryException;
import com.arcway.planagent.planmodel.implementation.PMPlan;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import de.plans.lib.eclipse.PlugInClassExtensionFactoryException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;

public class EPCPlanGenerator
implements IPlanGenerator {
    private static final ILogger logger = Logger.getLogger(EPCPlanGenerator.class);
    private static final double PLANELEMENT_WIDTH = 30.0;
    private static final double PLANELEMENT_HEIGHT = 15.0;
    private static final double CONTROLFLOW_HEIGHT = 10.0;
    private static final double START_X = 0.0;
    private static final double END_X = 30.0;
    private double startY;
    private double endY;

    public Plans generatePlans(Graphs graphs) throws EXSetupPlanException {
        Plans plans = new Plans();
        Collection subDirectories = graphs.getSubDirectories();
        for (GraphDirectory graphDirectory : subDirectories) {
            PlanDirectory planDirectory = this.generatePlanDirectory(graphDirectory);
            plans.addPlanDirectory(planDirectory);
        }
        Collection containedGraphs = graphs.getGraphs();
        for (Graph graph : containedGraphs) {
            Plan plan = this.generatePlan(graph);
            plans.addPlan(plan);
        }
        return plans;
    }

    public PlanDirectory generatePlanDirectory(GraphDirectory graphDirectory) throws EXSetupPlanException {
        PlanDirectory planDirectory = new PlanDirectory(graphDirectory.getName(), graphDirectory.getDescription(), true);
        Collection subDirectories = graphDirectory.getSubDirectories();
        for (GraphDirectory graphDirectory2 : subDirectories) {
            PlanDirectory subDirectory = this.generatePlanDirectory(graphDirectory2);
            planDirectory.addPlanDirectory(subDirectory);
        }
        Collection containedGraphs = graphDirectory.getGraphs();
        for (Graph graph : containedGraphs) {
            Plan plan = this.generatePlan(graph);
            planDirectory.addPlan(plan);
        }
        return planDirectory;
    }

    public Plan generatePlan(Graph graph) throws EXSetupPlanException {
        PMPlan pmPlan = null;
        String name = graph.getName();
        if (name == null) {
            name = "";
        }
        try {
            PlanModelMgr planManager = new PlanModelMgr();
            pmPlan = planManager.create("bpre.epc");
            ((IPMPlanRW)pmPlan).setName(name);
        }
        catch (EXPlanModelObjectFactoryException e) {
            logger.error("EXPlanModelObjectFactoryException", (Throwable)e);
        }
        catch (CoreException e) {
            logger.error("CoreException", (Throwable)e);
        }
        catch (PlugInClassExtensionFactoryException e) {
            logger.error("PlugInClassExtensionFactoryException", (Throwable)e);
        }
        Collection nodes = graph.getNodes();
        HashMap<String, Node> planElement2planElementDescription = new HashMap<String, Node>();
        this.startY = 0.0;
        this.endY = 15.0;
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            IPMPlanElementRO planElement = this.generatePlanElement(node, (IPMPlanRO)pmPlan);
            planElement2planElementDescription.put(planElement.getUid(), node);
            if (!it.hasNext()) continue;
            this.startY += 15.0;
            this.endY += 10.0;
            this.generateEdge((IPMPlanRO)pmPlan);
            this.startY += 10.0;
            this.endY += 15.0;
        }
        Plan plan = new Plan((IPMPlanRO)pmPlan, name, graph.getDescription(), planElement2planElementDescription, false);
        return plan;
    }

    public IPMPlanElementRO generatePlanElement(Node node, IPMPlanRO planRO) throws EXSetupPlanException {
        String nodeTypeID = node.getNodeTypeID();
        IPMPlanElementRO planElement = null;
        AbstractPlanElementGenerator planElementGenerator = null;
        String name = node.getName();
        if (nodeTypeID.equals("F") || nodeTypeID.equals("")) {
            if (name == null || name.equals("")) {
                name = Messages.getString("EPCPlanGenerator.unlabeledFunction", Locale.getDefault());
                node.setName(name);
            }
            planElementGenerator = new EPCPlanElementGeneratorFunction(name, 0.0, 30.0, this.startY, this.endY);
        } else if (nodeTypeID.equals("E")) {
            if (name == null || name.equals("")) {
                name = Messages.getString("EPCPlanGenerator.unlabeledEvent", Locale.getDefault());
                node.setName(name);
            }
            planElementGenerator = new EPCPlanElementGeneratorEvent(name, 0.0, 30.0, this.startY, this.endY);
        } else if (nodeTypeID.equals("I")) {
            if (name == null || name.equals("")) {
                name = Messages.getString("EPCPlanGenerator.unlabeledStorage", Locale.getDefault());
                node.setName(name);
            }
            planElementGenerator = new EPCPlanElementGeneratorStorage(name, 0.0, 30.0, this.startY, this.endY);
        } else {
            if (name == null || name.equals("")) {
                name = Messages.getString("EPCPlanGenerator.unlabeledPlanElement", Locale.getDefault());
                node.setName(name);
            }
            String message = String.valueOf(Messages.getString("EPCPlanGenerator.unknownPlanElementType1", Locale.getDefault())) + " " + name + " " + Messages.getString("EPCPlanGenerator.unknownPlanElementType2", Locale.getDefault());
            throw new EXSetupPlanException(message);
        }
        planElement = planElementGenerator.generatePlanElement(planRO);
        PlanModelDirectAccessTool.setPlanElementUID((IPMPlanElementRO)planElement, (String)UUIDGenerator.getUniqueID());
        return planElement;
    }

    public void generateEdge(IPMPlanRO planRO) {
        double xPos = 15.0;
        EPCPlanElementGeneratorControlFlow planElementGenerator = new EPCPlanElementGeneratorControlFlow(xPos, xPos, this.startY, this.endY);
        planElementGenerator.generatePlanElement(planRO);
    }
}

