/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.bpre.epc;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.FillColor;
import com.arcway.lib.graphics.fillstyles.FillStyle;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planimporterexporter.plangeneration.AbstractPlanElementGenerator;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.FillAppearance;
import com.arcway.planagent.planmodel.appearance.IFillAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.base.access.readonly.IPMPlanElementWithNameSupplementRO;
import com.arcway.planagent.planmodel.base.transactions.TACreateNameSupplement;
import com.arcway.planagent.planmodel.base.transactions.TASetPlanElementNameSupplement;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCFunctionRO;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCFunction;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class EPCPlanElementGeneratorFunction
extends AbstractPlanElementGenerator {
    private final Points txtPts = new Points();
    private final Points outlinePts = new Points();
    private final LineAppearance lineAppearance = new LineAppearance();
    private final FillAppearance fillAppearance = new FillAppearance();
    private final Point pt1;
    private final Point pt2;
    private final Point pt3;
    private final Point pt4;
    private final String name;

    public EPCPlanElementGeneratorFunction(String name, double startX, double endX, double startY, double endY) {
        this.name = name;
        this.pt1 = new Point(startX, startY);
        this.pt2 = new Point(endX, startY);
        this.pt3 = new Point(endX, endY);
        this.pt4 = new Point(startX, endY);
        this.outlinePts.add(this.pt1);
        this.outlinePts.add(this.pt2);
        this.outlinePts.add(this.pt3);
        this.outlinePts.add(this.pt4);
        this.txtPts.add(this.pt1);
        this.txtPts.add(this.pt2);
        this.txtPts.add(this.pt3);
        this.txtPts.add(this.pt4);
        this.lineAppearance.setLineColor(Color.BLACK);
        this.lineAppearance.setLineStyle(LineStyle.SOLID);
        this.lineAppearance.setLineThickness(0.5);
        this.fillAppearance.setFillStyle(FillStyle.SOLID);
        this.fillAppearance.setFillColor(new FillColor(224, 251, 193));
    }

    public IPMPlanElementRO generatePlanElement(IPMPlanRO plan) {
        TACreateBPREEPCFunction createFunctionTransaction = new TACreateBPREEPCFunction(plan, ActionParameters.DUMMY, this.outlinePts, (ILineAppearanceRO)this.lineAppearance, (IFillAppearanceRO)this.fillAppearance);
        this.executeTransaction((Transaction)createFunctionTransaction);
        IPMPlanElementBPREEPCFunctionRO planElement = createFunctionTransaction.getCreatedFunction();
        TACreateNameSupplement addNameSupplementTransaction = new TACreateNameSupplement((IPMPlanElementWithNameSupplementRO)planElement, ActionParameters.DUMMY, this.getTextAppearance(), this.txtPts);
        this.executeTransaction((Transaction)addNameSupplementTransaction);
        TASetPlanElementNameSupplement setNameSupplementTransaction = new TASetPlanElementNameSupplement((IPMPlanElementWithNameSupplementRO)planElement, ActionParameters.DUMMY, this.name);
        this.executeTransaction((Transaction)setNameSupplementTransaction);
        return planElement;
    }
}

