/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planimporterexporter.bpre.epc;

import com.arcway.lib.geometry.Point;
import com.arcway.lib.geometry.Points;
import com.arcway.lib.graphics.Color;
import com.arcway.lib.graphics.linemarkers.LineMarker;
import com.arcway.lib.graphics.linestyles.LineStyle;
import com.arcway.planagent.planimporterexporter.plangeneration.AbstractPlanElementGenerator;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanElementRO;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.actions.ActionParameters;
import com.arcway.planagent.planmodel.appearance.ILineAppearanceRO;
import com.arcway.planagent.planmodel.appearance.ILineMarkerAppearanceRO;
import com.arcway.planagent.planmodel.appearance.LineAppearance;
import com.arcway.planagent.planmodel.appearance.LineMarkerAppearance;
import com.arcway.planagent.planmodel.bpre.epc.access.readonly.IPMPlanElementBPREEPCControlFlowRO;
import com.arcway.planagent.planmodel.bpre.epc.transactions.TACreateBPREEPCControlFlow;
import com.arcway.planagent.planmodel.transactions.Transaction;

public class EPCPlanElementGeneratorControlFlow
extends AbstractPlanElementGenerator {
    private final Points outlinePts = new Points();
    private final LineAppearance lineAppearance = new LineAppearance();
    private final Point pt1;
    private final Point pt2;
    private final LineMarkerAppearance startMarkerAppearance = new LineMarkerAppearance();
    private final LineMarkerAppearance endMarkerAppearance = new LineMarkerAppearance();

    public EPCPlanElementGeneratorControlFlow(double startX, double endX, double startY, double endY) {
        this.pt1 = new Point(startX, startY);
        this.pt2 = new Point(endX, endY);
        this.outlinePts.add(this.pt1);
        this.outlinePts.add(this.pt2);
        this.lineAppearance.setCornerRadius(2.5);
        this.lineAppearance.setLineColor(Color.BLACK);
        this.lineAppearance.setLineStyle(LineStyle.SOLID);
        this.lineAppearance.setLineThickness(0.25);
        this.startMarkerAppearance.setLineMarkerStyle(LineMarker.NONE);
        this.endMarkerAppearance.setLineMarkerStyle(LineMarker.ROUNDED_ARC);
        this.endMarkerAppearance.setLineMarkerSize(0.75);
    }

    public IPMPlanElementRO generatePlanElement(IPMPlanRO plan) {
        TACreateBPREEPCControlFlow createCFTransaction = new TACreateBPREEPCControlFlow(plan, ActionParameters.DUMMY, this.outlinePts, (ILineAppearanceRO)this.lineAppearance, (ILineMarkerAppearanceRO)this.startMarkerAppearance, (ILineMarkerAppearanceRO)this.endMarkerAppearance);
        this.executeTransaction((Transaction)createCFTransaction);
        IPMPlanElementBPREEPCControlFlowRO planElement = createCFTransaction.getCreatedControlFlow();
        return planElement;
    }
}

