/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseButtonReleased;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.IRectangleFeedback;
import com.arcway.planagent.planeditor.tools.InputEvent;
import com.arcway.planagent.planeditor.tools.RectangleFeedbackFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Cursor;

public class IPSelectionByClickNDrag
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPSelectionByClickNDrag.class);
    private final IRectangleFeedback feedback;
    IFigure feedbackLayer = null;
    private final SelectionManager selectionManager;
    private final Request request;
    private boolean selectionInProgress = false;
    private Point startPoint = null;

    protected IPSelectionByClickNDrag(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        assert (selectionManager != null) : "selectionManager is null";
        this.selectionManager = selectionManager;
        this.request = new Request();
        this.request.setType((Object)"selection");
        this.feedback = RectangleFeedbackFactory.createRectangleFeedback();
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (this.doesUserWishToCancel(event)) {
            this.cancel();
            return 1;
        }
        if (this.selectionInProgress) {
            if (event instanceof IEMouseMove) {
                IEMouseMove moveEvent = (IEMouseMove)event;
                this.handleSelectionInProgress(moveEvent.getCurrentPosition());
            } else if (event instanceof IEMouseButtonReleased && !this.getTool().getState().isMouseButtonDown(1)) {
                IEMouseButtonReleased releaseEvent = (IEMouseButtonReleased)event;
                this.handleFinishSelection(releaseEvent.getCurrentPosition());
                return 1;
            }
            return 2;
        }
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            IInputState state = this.getTool().getState();
            if (clickEvent.getButton() != 1 || clickEvent.getTimes() > 1 || !clickEvent.isButtonStillPressed() || state.isMouseButtonDown(2) || state.isMouseButtonDown(3) || state.isShiftKeyDown()) {
                return 0;
            }
            Point position = clickEvent.getCurrentPosition();
            EditPart hit = this.getHit(position, false);
            IHandle handle = this.getHandle(position);
            if (hit != null && handle == null && (hit instanceof PEPlan || hit instanceof RootEditPart) || state.isAltKeyDown()) {
                this.handleStartSelection(position, state.isControlKeyDown());
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void cancel() {
        this.selectionInProgress = false;
        this.startPoint = null;
        if (this.feedbackLayer == null) {
            return;
        }
        this.feedback.hideFeedback(this.feedbackLayer);
        this.feedbackLayer = null;
        this.getTool().setCursor(null);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    private void handleStartSelection(Point position, boolean ctrlDown) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleStartSelection(Point position = " + position + ", boolean ctrlDown = " + ctrlDown + ") - start");
        }
        assert (position != null) : "position is null";
        this.selectionInProgress = true;
        this.startPoint = position.getCopy();
        if (!ctrlDown) {
            this.selectionManager.clearSelection(this.getTool().getCurrentViewer());
        }
        Point startPointCopy = new Point(this.startPoint);
        Point endPoint = new Point(position);
        this.feedback.translateToRelative(startPointCopy);
        this.feedback.translateToRelative(endPoint);
        this.feedback.updateFeedback(startPointCopy, endPoint);
        this.feedbackLayer = this.getFeedbackLayer();
        if (this.feedbackLayer != null) {
            this.feedback.showFeedback(this.feedbackLayer);
        }
        this.getTool().setCursor(Cursors.CROSS);
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleStartSelection() - end");
        }
    }

    private void handleSelectionInProgress(Point position) {
        assert (position != null) : "Position is null";
        Point startPointCopy = new Point(this.startPoint);
        Point endPoint = new Point(position);
        this.feedback.translateToRelative(startPointCopy);
        this.feedback.translateToRelative(endPoint);
        this.feedback.updateFeedback(startPointCopy, endPoint);
    }

    private void handleFinishSelection(Point position) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleFinishSelection(Point position = " + position + ") - start");
        }
        assert (position != null) : "Position is null";
        Rectangle selectionRectangle = new Rectangle(this.startPoint, position);
        ArrayList<EditPart> selectedItems = new ArrayList<EditPart>();
        List children = this.getAllPEPlanEditParts();
        int i = 0;
        while (i < children.size()) {
            EditPart child = (EditPart)children.get(i);
            if (child.isSelectable()) {
                IFigure figure = ((GraphicalEditPart)child).getFigure();
                Rectangle bounds = figure.getBounds().getCopy();
                figure.translateToAbsolute((Translatable)bounds);
                if (selectionRectangle.contains(bounds.getTopLeft()) && selectionRectangle.contains(bounds.getBottomRight()) && figure.isShowing() && child.getTargetEditPart(this.getRequest()) == child) {
                    selectedItems.add(child);
                }
            }
            ++i;
        }
        this.selectionManager.addItems(selectedItems, this.getTool().getCurrentViewer());
        this.cancel();
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleFinishSelection() - end");
        }
    }

    private void getAllPEPlanEditPartChildren(EditPart editPart, List allChildren) {
        assert (editPart != null) : "editPart is null";
        assert (allChildren != null) : "allChildren is null";
        List children = editPart.getChildren();
        int i = 0;
        while (i < children.size()) {
            GraphicalEditPart child = (GraphicalEditPart)children.get(i);
            if (child instanceof PEPlanEditPart) {
                allChildren.add(child);
            }
            this.getAllPEPlanEditPartChildren((EditPart)child, allChildren);
            ++i;
        }
    }

    private List getAllPEPlanEditParts() {
        ArrayList allChildren = new ArrayList();
        this.getAllPEPlanEditPartChildren((EditPart)this.getTool().getCurrentViewer().getRootEditPart(), allChildren);
        return allChildren;
    }

    @Override
    public Cursor getCursor() {
        Object cursor = this.getTool().getState().isAltKeyDown() ? Cursors.CROSS : null;
        return cursor;
    }
}

