/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.planagent.planeditor.commands.RQSelectionByClickHandle;
import com.arcway.planagent.planeditor.handles.HandlePointCreatePlanElementStructure;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPSelectionByClickHandle
extends AbstractInputProcessor {
    private RQSelectionByClickHandle request;

    public IPSelectionByClickHandle(GenericTool tool) {
        super(tool);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            IInputState state = this.getTool().getState();
            int index = 1;
            while (index <= 3) {
                if (index != clickEvent.getOSButton() && state.isMouseButtonDown(index)) {
                    return 0;
                }
                ++index;
            }
            if (state.isAltKeyDown()) {
                return 0;
            }
            if (state.isControlKeyDown() && !clickEvent.isButtonStillPressed()) {
                return 0;
            }
            if (clickEvent.isButtonStillPressed() || clickEvent.getButton() == 3) {
                return 0;
            }
            if (clickEvent.getTimes() == 2) {
                return 0;
            }
            IHandle handle = this.getHandle(clickEvent.getCurrentPosition());
            if (handle != null && handle instanceof HandlePointCreatePlanElementStructure) {
                this.request = new RQSelectionByClickHandle("fast draw handle");
                Command command = handle.getCommand(this.request);
                this.executeCommand(command);
                return 1;
            }
        }
        return 0;
    }
}

