/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.edit.Utilities;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.swt.graphics.Cursor;

public class IPSelectionByClick
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPSelectionByClick.class);
    private final SelectionManager selectionManager;
    private final Request request;

    public IPSelectionByClick(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        assert (selectionManager != null) : "selectionManager is null";
        this.selectionManager = selectionManager;
        this.request = new Request();
        this.request.setType((Object)"selection");
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            IInputState state = this.getTool().getState();
            int index = 1;
            while (index <= 3) {
                if (index != clickEvent.getOSButton() && state.isMouseButtonDown(index)) {
                    return 0;
                }
                ++index;
            }
            if (state.isAltKeyDown()) {
                return 0;
            }
            if (state.isControlKeyDown() && !clickEvent.isButtonStillPressed()) {
                EditPart hit = this.getHit(clickEvent.getCurrentPosition(), false);
                if (hit != null) {
                    this.handleSelectionWithCtrl(hit);
                }
            } else if (clickEvent.isButtonStillPressed() || clickEvent.getButton() == 3) {
                EditPart hit = this.getHit(clickEvent.getCurrentPosition(), true);
                if (hit != null) {
                    this.handleSelectionBeforeOperation(hit);
                }
            } else if (clickEvent.getTimes() == 2) {
                EditPart hit = this.getHit(clickEvent.getCurrentPosition(), false);
                if (hit != null && !(hit instanceof RootEditPart)) {
                    this.handleSelectionWithDoubleClick(hit);
                }
            } else {
                EditPart hit = this.getHit(clickEvent.getCurrentPosition(), false);
                if (hit != null) {
                    this.handleSimpleSelection(hit);
                }
            }
        }
        return 0;
    }

    @Override
    public void cancel() {
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    private void handleSelectionBeforeOperation(EditPart hit) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleSelectionBeforeOperation(EditPart hit = " + hit + ") - start");
        }
        if (hit instanceof PEPlanEditPart) {
            EditPart target = this.getTargetAscending(hit);
            assert (target != null) : "target is null";
            assert (target instanceof PEPlanEditPart) : "target is not a PEPlanEditPart";
            EditPart possiblySelectedEditPart = Utilities.getEditPartAtLevel(target, this.selectionManager.getSelectionLevel(this.getTool().getCurrentViewer()));
            if (possiblySelectedEditPart == null || possiblySelectedEditPart.getSelected() == 0) {
                this.handleSimpleSelection(hit);
            }
        } else if (!(hit instanceof RootEditPart)) assert (false) : "hit returned unknown object" + hit;
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleSelectionBeforeOperation(EditPart) - end");
        }
    }

    private void handleSimpleSelection(EditPart hit) {
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleSimpleSelection(EditPart hit = " + hit + ") - start");
        }
        if (hit instanceof PEPlanEditPart) {
            EditPart possiblySelectedEditPart;
            EditPart target = this.getTargetAscending(hit);
            assert (target != null) : "target is null";
            assert (target instanceof PEPlanEditPart) : "target is not a PEPlanEditPart";
            EditPart newSelection = Utilities.getEditPartAtLevel(target, 1);
            int selectionCount = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer()).size();
            if (selectionCount == 1 && (possiblySelectedEditPart = Utilities.getEditPartAtLevel(target, this.selectionManager.getSelectionLevel(this.getTool().getCurrentViewer()))) != null && possiblySelectedEditPart.getSelected() != 0) {
                newSelection = Utilities.getEditPartAtLevel(target, Math.min(Utilities.getLevelOfEditPart(target), this.selectionManager.getSelectionLevel(this.getTool().getCurrentViewer()) + 1));
            }
            if ((newSelection = Utilities.processSkipEditPart(newSelection, target)) != null && newSelection.isSelectable()) {
                this.selectionManager.replaceSelection(newSelection, this.getTool().getCurrentViewer());
                if (logger.isDebugEnabled()) {
                    logger.debug(68, "handleSimpleSelection(EditPart) - new Selection: Level " + Utilities.getLevelOfEditPart(newSelection) + ", " + newSelection);
                }
            } else {
                this.selectionManager.clearSelection(this.getTool().getCurrentViewer());
            }
        } else if (hit instanceof RootEditPart) {
            this.selectionManager.clearSelection(this.getTool().getCurrentViewer());
        } else assert (false) : "hit returned unknown object" + hit;
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleSimpleSelection(EditPart) - end");
        }
    }

    private void handleSelectionWithCtrl(EditPart hit) {
        if (logger.isDebugEnabled()) {
            logger.debug(68, "handleSelectionWithCtrl(EditPart hit = " + hit + ") - start");
        }
        if (hit instanceof PEPlanEditPart) {
            EditPart target = this.getTargetAscending(hit);
            assert (target != null) : "target is null";
            assert (target instanceof PEPlanEditPart) : "target is not a PEPlanEditPart";
            EditPart possiblySelectedEditPart = Utilities.getEditPartAtLevel(target, this.selectionManager.getSelectionLevel(this.getTool().getCurrentViewer()));
            if (possiblySelectedEditPart == null) {
                EditPart highestEditPart = Utilities.getEditPartAtLevel(target, 1);
                if (highestEditPart != null) {
                    this.selectionManager.replaceSelection(highestEditPart, this.getTool().getCurrentViewer());
                }
            } else if (possiblySelectedEditPart.isSelectable()) {
                if (possiblySelectedEditPart.getSelected() == 0) {
                    this.selectionManager.addItem(possiblySelectedEditPart, this.getTool().getCurrentViewer());
                } else {
                    this.selectionManager.removeItem(possiblySelectedEditPart, this.getTool().getCurrentViewer());
                }
            }
        } else if (!(hit instanceof RootEditPart)) assert (false) : "hit returned unknown object" + hit;
        if (logger.isDebugEnabled()) {
            logger.debug(67, "handleSelectionWithCtrl(EditPart) - end");
        }
    }

    private void handleSelectionWithDoubleClick(EditPart hit) {
        EditPart target = this.getTargetAscending(hit);
        EditPart newSelection = Utilities.getEditPartAtLevel(target, 1);
        List s = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
        if (!s.contains(newSelection)) {
            this.handleSimpleSelection(hit);
        } else if (s.size() > 1) {
            this.selectionManager.clearSelection(this.getTool().getCurrentViewer());
            this.handleSimpleSelection(hit);
        }
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

