/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IETrigger;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import com.arcway.planagent.planeditor.tools.PlaceTool;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPPlace
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPPlace.class);
    private Request request;
    private PEPlan plan;

    public IPPlace(GenericTool tool) {
        super(tool);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (this.doesUserWishToCancel(event)) {
            this.cancel();
            if (logger.isTraceEnabled()) {
                logger.trace("handleEvent(InputEvent) - end - return value = 1");
            }
            return 1;
        }
        IInputState state = this.getTool().getState();
        if (this.request == null) {
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "request is null --> update request");
            }
            this.request = ((PlaceTool)this.getTool()).getPlanPlacer().updateRequest(state.getMousePosition());
        }
        if (this.plan == null) {
            this.plan = (PEPlan)this.getTool().getCurrentViewer().getContents();
            this.showTargetFeedback();
        }
        if (event instanceof IETrigger) {
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "IETrigger --> update request");
            }
            Point eventPoint = this.getTool().getState().getMousePosition();
            this.request = ((PlaceTool)this.getTool()).getPlanPlacer().updateRequest(eventPoint);
            this.eraseTargetFeedback();
            this.showTargetFeedback();
            return 2;
        }
        if (event instanceof IEMouseMove) {
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "IEMouseMove --> update request");
            }
            IEMouseMove mouseEvent = (IEMouseMove)event;
            Point eventPoint = mouseEvent.getCurrentPosition();
            this.request = ((PlaceTool)this.getTool()).getPlanPlacer().updateRequest(eventPoint);
            this.eraseTargetFeedback();
            this.showTargetFeedback();
            return 2;
        }
        if (event instanceof IEMouseButtonClicked) {
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "IEMouseButtonClicked --> don't update request");
            }
            Command command = this.plan.getCommand(this.getRequest());
            this.executeCommand(command);
            this.cancel();
            return 1;
        }
        return 0;
    }

    @Override
    public void cancel() {
        this.eraseTargetFeedback();
        this.plan = null;
        this.request = null;
        this.getTool().setToolToSwitchTo((GenericTool)this.getTool().getCurrentViewer().getEditDomain().getDefaultTool(), false);
    }

    @Override
    public Cursor getCursor() {
        return null;
    }

    @Override
    protected boolean doesUserWishToCancel(InputEvent event) {
        IEMouseButtonClicked mouseEvent;
        boolean wantsToCancel = super.doesUserWishToCancel(event);
        if (event instanceof IEMouseButtonClicked && (mouseEvent = (IEMouseButtonClicked)event).getButton() == 3) {
            wantsToCancel = true;
        }
        return wantsToCancel;
    }
}

