/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.IEKeyUp;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import com.arcway.planagent.planeditor.tools.ZoomTool;
import org.eclipse.gef.Request;
import org.eclipse.swt.graphics.Cursor;

public class IPKeyDisableMagnify
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPKeyDisableMagnify.class);
    private Request request;

    public IPKeyDisableMagnify(GenericTool tool) {
        super(tool);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        if (this.doesUserWishToCancel(event)) {
            this.handleNoShiftCtrl();
            return 1;
        }
        if (((ZoomTool)this.getTool()).isKeyActivated()) {
            if (event instanceof IEKeyUp) {
                IInputState state = this.getTool().getState();
                if (!state.isShiftKeyDown() || !state.isControlKeyDown()) {
                    this.handleNoShiftCtrl();
                    return 1;
                }
            } else {
                boolean cfr_ignored_0 = event instanceof IEKeyDown;
            }
        }
        return 0;
    }

    private void handleNoShiftCtrl() {
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleShiftCtrl() - start");
        }
        this.getTool().setToolToSwitchTo((GenericTool)this.getTool().getCurrentViewer().getEditDomain().getDefaultTool(), false);
        if (logger.isDebugEnabled()) {
            logger.debug(61, "handleShiftCtrl() - end");
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

