/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.planagent.planeditor.commands.RQEdit;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPEdit
extends AbstractInputProcessor {
    private Request request;
    private final SelectionManager selectionManager;

    public IPEdit(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        this.selectionManager = selectionManager;
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    @Override
    public int handleEvent(InputEvent event) {
        IEMouseButtonClicked clickEvent;
        if (event instanceof IEKeyDown) {
            IEKeyDown keyEvent = (IEKeyDown)event;
            if (keyEvent.getPressedKey().keyCode == 0x100000B) {
                this.handleEdit(2);
                return 1;
            }
        } else if (event instanceof IEMouseButtonClicked && (clickEvent = (IEMouseButtonClicked)event).getTimes() == 2) {
            this.handleEdit(1);
            return 1;
        }
        return 0;
    }

    private void handleEdit(int editMode) {
        List selectedItems = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
        if (selectedItems.size() > 0) {
            EditPart item = (EditPart)selectedItems.get(0);
            assert (item instanceof PEPlanEditPart);
            this.request = new RQEdit(selectedItems, editMode);
            EditPart target = this.getTargetAscending(item);
            if (target != null && target.understandsRequest(this.getRequest())) {
                Command command = target.getCommand(this.getRequest());
                this.executeCommand(command);
            }
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public Cursor getCursor() {
        return null;
    }
}

