/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.planagent.planeditor.commands.RQDragNDropHandle;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.handles.IHandle;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKey;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseButtonReleased;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPDragNDropHandle
extends AbstractInputProcessor {
    private RQDragNDropHandle request;
    private boolean dragNDropInProgress = false;
    private IHandle handledHandle;
    private final SelectionManager selectionManager;

    protected IPDragNDropHandle(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        assert (selectionManager != null) : "selectionManager is null";
        this.selectionManager = selectionManager;
    }

    @Override
    public int handleEvent(InputEvent event) {
        IInputState state = this.getTool().getState();
        if (this.dragNDropInProgress) {
            if (this.doesUserWishToCancel(event)) {
                this.cancel();
                return 1;
            }
            if (event instanceof IEMouseMove || event instanceof IEKey) {
                this.handleDragNDropInProgress(state.getMousePosition(), state.isControlKeyDown());
            } else if (event instanceof IEMouseButtonReleased && !this.getTool().getState().isMouseButtonDown(1)) {
                IEMouseButtonReleased releaseEvent = (IEMouseButtonReleased)event;
                this.handleFinishDragNDrop(releaseEvent.getCurrentPosition(), state.isControlKeyDown());
                return 1;
            }
            return 2;
        }
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            if (clickEvent.getButton() != 1 || clickEvent.getTimes() > 1 || !clickEvent.isButtonStillPressed() || state.isMouseButtonDown(2) || state.isMouseButtonDown(3)) {
                return 0;
            }
            Point position = clickEvent.getCurrentPosition();
            IHandle handle = this.getHandle(position);
            if (handle != null) {
                this.handleStartDragNDrop(position, state.isControlKeyDown(), handle);
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void cancel() {
        this.handledHandle.eraseTargetFeedback(this.getRequest());
        this.dragNDropInProgress = false;
        this.handledHandle = null;
        this.request = null;
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    private void updateRequest(Point to, boolean copy) {
        assert (to != null) : "to is null";
        this.request.setTo(to);
        this.request.setCopy(copy);
    }

    private void createRequest(Point from, IHandle handle, List dragItems, boolean moveChildrenAlso, boolean copy) {
        this.request = new RQDragNDropHandle();
        this.request.setFrom(from);
        this.request.setTo(from);
        this.request.setElements(dragItems);
        this.request.setHandle(handle);
        this.request.setCopy(copy);
        this.request.setMoveChildrenAlso(moveChildrenAlso);
    }

    private String getRequestType() {
        String requestType = this.getTool().getState().isControlKeyDown() ? "copy handle" : "drag handle";
        return requestType;
    }

    private void handleStartDragNDrop(Point position, boolean copy, IHandle handle) {
        assert (position != null) : "position is null";
        assert (handle != null) : "handle is null";
        List dragItems = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
        this.createRequest(position, handle, dragItems, false, copy);
        this.dragNDropInProgress = true;
        this.handledHandle = handle;
    }

    private void handleDragNDropInProgress(Point position, boolean copy) {
        assert (position != null) : "Position is null";
        this.handledHandle.eraseTargetFeedback(this.getRequest());
        this.updateRequest(position, copy);
        this.handledHandle.showTargetFeedback(this.getRequest());
    }

    private void handleFinishDragNDrop(Point position, boolean copy) {
        assert (position != null) : "Position is null";
        this.updateRequest(position, copy);
        Command command = this.handledHandle.getCommand(this.getRequest());
        this.executeCommand(command);
        this.cancel();
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor = null;
        Point position = this.getTool().getState().getMousePosition();
        IHandle handle = this.getHandle(position);
        if (handle != null) {
            int commandType = handle.getCommandType(this.getRequestType());
            cursor = this.getCursorByCommandType(commandType);
        }
        return cursor;
    }
}

