/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.commands.RQMove;
import com.arcway.planagent.planeditor.edit.PEPlan;
import com.arcway.planagent.planeditor.edit.PEPlanEditPart;
import com.arcway.planagent.planeditor.edit.SelectionManager;
import com.arcway.planagent.planeditor.edit.Utilities;
import com.arcway.planagent.planeditor.tools.AbstractInputProcessor;
import com.arcway.planagent.planeditor.tools.GenericTool;
import com.arcway.planagent.planeditor.tools.IEKey;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseButtonReleased;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.InputEvent;
import de.plans.lib.util.LocalisationUtils;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Cursor;

public class IPDragNDrop
extends AbstractInputProcessor {
    private static final ILogger logger = Logger.getLogger(IPDragNDrop.class);
    private static final ProfileQueue profileQueue = new ProfileQueue();
    private PEPlan plan;
    private final SelectionManager selectionManager;
    private Request request;
    private boolean dragNDropInProgress = false;
    private Point startPoint = null;
    private List dragItems;

    protected IPDragNDrop(GenericTool tool, SelectionManager selectionManager) {
        super(tool);
        assert (selectionManager != null);
        this.selectionManager = selectionManager;
        this.request = new Request();
        this.request.setType((Object)"move");
    }

    @Override
    public int handleEvent(InputEvent event) {
        boolean moveChildrenAlso = this.getTool().getState().isShiftKeyDown();
        boolean createCopy = this.getTool().getState().isControlKeyDown();
        if (this.dragNDropInProgress) {
            if (this.doesUserWishToCancel(event)) {
                this.cancel();
                return 1;
            }
            if (event instanceof IEMouseMove) {
                IEMouseMove moveEvent = (IEMouseMove)event;
                this.handleDragNDropInProgress(moveEvent.getCurrentPosition(), moveChildrenAlso, createCopy);
            } else if (event instanceof IEKey) {
                this.handleDragNDropInProgress(null, moveChildrenAlso, createCopy);
            } else if (event instanceof IEMouseButtonReleased && !this.getTool().getState().isMouseButtonDown(1)) {
                IEMouseButtonReleased releaseEvent = (IEMouseButtonReleased)event;
                this.handleFinishDragNDrop(releaseEvent.getCurrentPosition(), moveChildrenAlso, createCopy);
                return 1;
            }
            return 2;
        }
        if (event instanceof IEMouseButtonClicked) {
            IEMouseButtonClicked clickEvent = (IEMouseButtonClicked)event;
            IInputState state = this.getTool().getState();
            if (clickEvent.getButton() != 1 || clickEvent.getTimes() > 1 || !clickEvent.isButtonStillPressed() || state.isMouseButtonDown(2) || state.isMouseButtonDown(3)) {
                return 0;
            }
            Point position = clickEvent.getCurrentPosition();
            EditPart hit = this.getHit(position, true);
            if (hit != null && hit instanceof PEPlanEditPart && !(hit instanceof PEPlan)) {
                EditPart lowest = Utilities.getEditPartAtLevel(hit, 1);
                if (this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer()).contains(lowest) || this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer()).contains(hit)) {
                    this.handleStartDragNDrop(position, moveChildrenAlso, createCopy);
                } else if (logger.isDebugEnabled(74)) {
                    logger.debug(74, "--------------------- move non selected object ----------------------");
                }
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void cancel() {
        this.dragNDropInProgress = false;
        this.startPoint = null;
        this.dragItems = null;
        this.eraseTargetFeedback();
        this.plan = null;
        this.request = new Request();
        this.request.setType((Object)"move");
        this.getTool().setCursor(null);
    }

    @Override
    protected Request getRequest() {
        return this.request;
    }

    private void updateRequest(Point currentPosition, boolean contentHasChanged, boolean moveChildrenAlso, boolean createCopy) {
        int viewPortWidth = this.getTool().getCurrentViewer().getControl().getSize().x;
        int viewPortHeight = this.getTool().getCurrentViewer().getControl().getSize().y;
        if (currentPosition != null && (currentPosition.x < 0 || currentPosition.y < 0 || currentPosition.x > viewPortWidth || currentPosition.y > viewPortHeight)) {
            this.request = new Request();
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "--------------------- ignore Request ----------------------");
            }
            return;
        }
        if (currentPosition != null || this.request instanceof RQMove) {
            boolean createNewRequest;
            int diffy;
            int diffx;
            if (currentPosition != null) {
                diffx = currentPosition.x - this.startPoint.x;
                diffy = currentPosition.y - this.startPoint.y;
            } else {
                RQMove moveRequest = (RQMove)this.request;
                diffx = moveRequest.getMoveX();
                diffy = moveRequest.getMoveY();
            }
            if (this.request instanceof RQMove) {
                RQMove moveRequest = (RQMove)this.request;
                boolean bl = createNewRequest = contentHasChanged || moveRequest.getMoveChildrenAlso() != moveChildrenAlso || moveRequest.getCreateCopy() != createCopy;
                if (!createNewRequest) {
                    moveRequest.setMoveX(diffx);
                    moveRequest.setMoveY(diffy);
                }
            } else {
                createNewRequest = true;
            }
            if (createNewRequest) {
                this.request = new RQMove(diffx, diffy, this.dragItems, moveChildrenAlso, createCopy);
            }
        } else {
            this.request = new Request();
        }
    }

    private void handleStartDragNDrop(Point position, boolean moveChildrenAlso, boolean createCopy) {
        assert (position != null);
        this.dragNDropInProgress = true;
        this.startPoint = position.getCopy();
        this.dragItems = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
        this.plan = (PEPlan)Utilities.getEditPartAtLevel(this.getHit(this.startPoint, false), 0);
        if (logger.isDebugEnabled(74)) {
            logger.debug(74, "handleStartDragNDrop() - dragItems = " + this.dragItems);
        }
        boolean contentHasChanged = true;
        this.updateRequest(position, contentHasChanged, moveChildrenAlso, createCopy);
        this.eraseTargetFeedback();
        this.showTargetFeedback();
        Cursor cursor = createCopy ? this.getCursorByCommandType(-2147483642) : this.getCursorByCommandType(6);
        this.getTool().setCursor(cursor);
    }

    private void handleDragNDropInProgress(Point position, boolean moveChildrenAlso, boolean createCopy) {
        boolean isOutsideWidget;
        assert (this.getTool().getState().isMouseButtonDown(1));
        ProfileSample profileSample = null;
        if (this.profile()) {
            profileSample = new ProfileSample();
            profileSample.eventHandlingStarted();
        }
        this.eraseTargetFeedback();
        if (this.profile()) {
            profileSample.feedbackRemoved();
        }
        if (logger.isDebugEnabled(74)) {
            logger.debug(74, "handleDragNDropInProgress() - dragItems = " + this.dragItems);
        }
        boolean contentHasChanged = false;
        this.updateRequest(position, contentHasChanged, moveChildrenAlso, createCopy);
        if (this.profile()) {
            profileSample.requestUpdated();
        }
        int viewPortWidth = this.getTool().getCurrentViewer().getControl().getSize().x;
        int viewPortHeight = this.getTool().getCurrentViewer().getControl().getSize().y;
        boolean bl = isOutsideWidget = position != null && (position.x < 0 || position.y < 0 || position.x > viewPortWidth || position.y > viewPortHeight);
        if (!isOutsideWidget) {
            this.getTool().setCursor(this.updateCursor(createCopy));
        } else {
            this.getTool().setCursor(Cursors.NO);
        }
        if (this.profile()) {
            profileSample.cursorUpdated();
        }
        this.showTargetFeedback();
        if (this.profile()) {
            profileSample.feedbackCreated();
            profileQueue.put(profileSample);
        }
    }

    private void handleFinishDragNDrop(Point position, boolean moveChildrenAlso, boolean createCopy) {
        assert (position != null);
        if (logger.isDebugEnabled(74)) {
            logger.debug(74, "handleFinishDragNDrop() - dragItems = " + this.dragItems);
        }
        boolean contentHasChanged = false;
        this.updateRequest(position, contentHasChanged, moveChildrenAlso, createCopy);
        Command command = this.plan.getCommand(this.getRequest());
        this.executeCommand(command);
        this.cancel();
    }

    @Override
    public Cursor getCursor() {
        Cursor cursor = null;
        Point position = this.getTool().getState().getMousePosition();
        EditPart hit = this.getHit(position, true);
        if (hit != null && hit instanceof PEPlanEditPart && !(hit instanceof PEPlan) && this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer()).contains(hit)) {
            boolean moveChildrenAlso = this.getTool().getState().isShiftKeyDown();
            boolean createCopy = this.getTool().getState().isControlKeyDown();
            this.startPoint = position.getCopy();
            this.dragItems = this.selectionManager.getSelectedItems(this.getTool().getCurrentViewer());
            if (logger.isDebugEnabled(74)) {
                logger.debug(74, "getCursor() - dragItems = " + this.dragItems);
            }
            RQMove newRequest = new RQMove(0, 0, this.dragItems, moveChildrenAlso, createCopy);
            PEPlan thePlanThatWasHit = (PEPlan)Utilities.getEditPartAtLevel(this.getHit(this.startPoint, false), 0);
            if (thePlanThatWasHit.understandsRequest(newRequest)) {
                cursor = this.updateCursor(createCopy);
            }
        }
        return cursor;
    }

    private Cursor updateCursor(boolean createCopy) {
        Cursor cursor = createCopy ? this.getCursorByCommandType(-2147483644) : this.getCursorByCommandType(4);
        return cursor;
    }

    private boolean profile() {
        return logger.isDebugEnabled(73);
    }

    public static class ProfileQueue {
        private static final long STATISTIC_OUTPUT_INTERVALL = 500L;
        private static final int RING_SIZE = 100;
        private static final ProfileSample[] RING_BUFFER = new ProfileSample[100];
        private int currentRingWriteEntry = -1;
        private int ringEntries = 0;
        private long timeOfNextReport = System.currentTimeMillis();
        private int samplesSinceLastReport = 0;

        public void put(ProfileSample sample) {
            if (this.currentRingWriteEntry > 0) {
                ProfileQueue.RING_BUFFER[this.currentRingWriteEntry].nextEventHandlingStarted = sample.eventHandlingStarted;
            }
            this.currentRingWriteEntry = (this.currentRingWriteEntry + 1) % 100;
            ProfileQueue.RING_BUFFER[this.currentRingWriteEntry] = sample;
            this.ringEntries = Math.max(this.ringEntries, this.currentRingWriteEntry);
            ++this.samplesSinceLastReport;
            long currentTime = System.currentTimeMillis();
            if (this.ringEntries == 0) {
                this.timeOfNextReport = currentTime + 500L;
            }
            if (currentTime >= this.timeOfNextReport) {
                this.printStatistics(this.samplesSinceLastReport);
                this.samplesSinceLastReport = 0;
                this.timeOfNextReport += 500L;
                if (currentTime >= this.timeOfNextReport) {
                    this.timeOfNextReport = currentTime + 500L;
                }
            }
        }

        private void printStatistics(int samplesSinceLastReport) {
            long removeFeedbackSum = 0L;
            long updateRequestSum = 0L;
            long updateCursorSum = 0L;
            long createFeedbackSum = 0L;
            long timeRemainingSum = 0L;
            long totalSum = 0L;
            int usableSamples = Math.min(samplesSinceLastReport, 100) - 1;
            int currentSample = this.currentRingWriteEntry;
            int i = 0;
            while (i < usableSamples) {
                currentSample = (currentSample - 1 + 100) % 100;
                removeFeedbackSum += RING_BUFFER[currentSample].getRemoveFeedbackTime();
                updateRequestSum += RING_BUFFER[currentSample].getUpdateRequestTime();
                updateCursorSum += RING_BUFFER[currentSample].getUpdateCursorTime();
                createFeedbackSum += RING_BUFFER[currentSample].getCreateFeedbackTime();
                timeRemainingSum += RING_BUFFER[currentSample].getRemainingTime();
                totalSum += RING_BUFFER[currentSample].getTotalTime();
                ++i;
            }
            String statistic = "Editor IPDND-Profiling: " + usableSamples + " Samples";
            if (totalSum > 0L) {
                statistic = String.valueOf(statistic) + ", " + LocalisationUtils.roundLocalized((double)(1000.0 * (double)usableSamples / (double)totalSum), (int)2, (boolean)true) + " Samples/sec";
            }
            logger.debug(73, statistic);
            if (totalSum > 0L) {
                statistic = "remove Feedback: " + LocalisationUtils.roundLocalized((double)(100.0 * (double)removeFeedbackSum / (double)totalSum), (int)0, (boolean)true) + " %";
                logger.debug(73, statistic);
                statistic = "update Request:  " + LocalisationUtils.roundLocalized((double)(100.0 * (double)updateRequestSum / (double)totalSum), (int)0, (boolean)true) + " %";
                logger.debug(73, statistic);
                statistic = "update Cursor:   " + LocalisationUtils.roundLocalized((double)(100.0 * (double)updateCursorSum / (double)totalSum), (int)0, (boolean)true) + " %";
                logger.debug(73, statistic);
                statistic = "create Feedback: " + LocalisationUtils.roundLocalized((double)(100.0 * (double)createFeedbackSum / (double)totalSum), (int)0, (boolean)true) + " %";
                logger.debug(73, statistic);
                statistic = "time remaining:  " + LocalisationUtils.roundLocalized((double)(100.0 * (double)timeRemainingSum / (double)totalSum), (int)0, (boolean)true) + " %";
                logger.debug(73, statistic);
            }
        }
    }

    private class ProfileSample {
        public long eventHandlingStarted;
        public long feedbackRemoved;
        public long requestUpdated;
        public long cursorUpdated;
        public long feedbackCreated;
        public long nextEventHandlingStarted;

        private ProfileSample() {
        }

        public void eventHandlingStarted() {
            this.eventHandlingStarted = System.currentTimeMillis();
        }

        public void feedbackRemoved() {
            this.feedbackRemoved = System.currentTimeMillis();
        }

        public void requestUpdated() {
            this.requestUpdated = System.currentTimeMillis();
        }

        public void cursorUpdated() {
            this.cursorUpdated = System.currentTimeMillis();
        }

        public void feedbackCreated() {
            this.feedbackCreated = System.currentTimeMillis();
        }

        public long getRemoveFeedbackTime() {
            return this.feedbackRemoved - this.eventHandlingStarted;
        }

        public long getUpdateRequestTime() {
            return this.requestUpdated - this.feedbackRemoved;
        }

        public long getUpdateCursorTime() {
            return this.cursorUpdated - this.requestUpdated;
        }

        public long getCreateFeedbackTime() {
            return this.feedbackCreated - this.cursorUpdated;
        }

        public long getRemainingTime() {
            return this.nextEventHandlingStarted - this.feedbackCreated;
        }

        public long getTotalTime() {
            return this.nextEventHandlingStarted - this.eventHandlingStarted;
        }
    }
}

