/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.tools;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.tools.IEKeyDown;
import com.arcway.planagent.planeditor.tools.IEKeyUp;
import com.arcway.planagent.planeditor.tools.IEMouseButtonClicked;
import com.arcway.planagent.planeditor.tools.IEMouseButtonReleased;
import com.arcway.planagent.planeditor.tools.IEMouseHover;
import com.arcway.planagent.planeditor.tools.IEMouseMove;
import com.arcway.planagent.planeditor.tools.IEMouseWheel;
import com.arcway.planagent.planeditor.tools.IETrigger;
import com.arcway.planagent.planeditor.tools.IInputProcessor;
import com.arcway.planagent.planeditor.tools.IInputState;
import com.arcway.planagent.planeditor.tools.IToolStateChangedListener;
import com.arcway.planagent.planeditor.tools.InputEvent;
import de.plans.lib.eclipse.TimeOutReceiver;
import de.plans.lib.eclipse.TimeOutTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Tool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class GenericTool
implements Tool,
TimeOutReceiver<Long> {
    private static final ILogger LOGGER = Logger.getLogger(GenericTool.class);
    private static final boolean isMacMouseButtonSwapWorkaroundEnabled = "macosx".equals(Platform.getOS());
    private final long DOUBLE_CLICK_SPEED = 200L;
    private EditPartViewer currentViewer;
    private InputState state;
    private final int[] clickMB = new int[3];
    private final ArrayList<Long> outstandingStamps = new ArrayList();
    private Long lastOutstandingStamp;
    private Point lastClickPosition;
    private final Timer timer;
    private final List<IInputProcessor> inputProcessors;
    private IInputProcessor activeInputProcessor;
    private Cursor activeCursor;
    private GenericTool toolToSwitchTo;
    private boolean refireEvent;
    private final Collection<IToolStateChangedListener> toolStateChangedListeners = new ArrayList<IToolStateChangedListener>();

    public GenericTool() {
        this.timer = new Timer();
        this.inputProcessors = new ArrayList<IInputProcessor>();
        this.configureInputProcessors(this.inputProcessors);
    }

    protected abstract void configureInputProcessors(List<IInputProcessor> var1);

    public IInputProcessor getActiveInputProcessor() {
        return this.activeInputProcessor;
    }

    private void fire(InputEvent event) {
        assert (event != null) : "event is null";
        IInputProcessor oldActiveInputProcessor = this.activeInputProcessor;
        try {
            boolean consumed = false;
            if (LOGGER.isDebugEnabled(68)) {
                LOGGER.debug(68, "==> Generic Tool, handle event: " + event);
            }
            if (this.activeInputProcessor != null) {
                if (LOGGER.isDebugEnabled(68)) {
                    LOGGER.debug(68, "  --> ask active Input Processor " + this.activeInputProcessor + "...");
                }
                int result = this.activeInputProcessor.handleEvent(event);
                switch (result) {
                    case 0: {
                        if (LOGGER.isDebugEnabled(68)) {
                            LOGGER.debug(68, "  --> ask active Input Processor " + this.activeInputProcessor + ": not consumed ");
                        }
                        this.activeInputProcessor = null;
                        break;
                    }
                    case 1: {
                        if (LOGGER.isDebugEnabled(68)) {
                            LOGGER.debug(68, "  --> ask active Input Processor " + this.activeInputProcessor + ": consumed completed");
                        }
                        consumed = true;
                        this.activeInputProcessor = null;
                        break;
                    }
                    case 2: {
                        if (LOGGER.isDebugEnabled(68)) {
                            LOGGER.debug(68, "  --> ask active Input Processor " + this.activeInputProcessor + ": consumed incomplete");
                        }
                        consumed = true;
                        break;
                    }
                    default: {
                        assert (false) : "unknown result " + result;
                        break;
                    }
                }
            }
            int index = 0;
            while (index < this.inputProcessors.size() && !consumed) {
                IInputProcessor inputProcessor = this.inputProcessors.get(index);
                if (LOGGER.isDebugEnabled(68)) {
                    LOGGER.debug(68, "  --> ask Input Processor " + inputProcessor + "...");
                }
                int result = inputProcessor.handleEvent(event);
                if (LOGGER.isDebugEnabled(68)) {
                    LOGGER.debug(68, "");
                }
                switch (result) {
                    case 0: {
                        if (!LOGGER.isDebugEnabled(68)) break;
                        LOGGER.debug(68, "  --> ask Input Processor " + inputProcessor + ": not consumed ");
                        break;
                    }
                    case 1: {
                        if (LOGGER.isDebugEnabled(68)) {
                            LOGGER.debug(68, "  --> ask Input Processor " + inputProcessor + ": consumed completed ");
                        }
                        consumed = true;
                        break;
                    }
                    case 2: {
                        if (LOGGER.isDebugEnabled(68)) {
                            LOGGER.debug(68, "  --> ask Input Processor " + inputProcessor + ": consumed incomplete ");
                        }
                        this.activeInputProcessor = inputProcessor;
                        consumed = true;
                        break;
                    }
                    default: {
                        assert (false) : "unknown result " + result;
                        break;
                    }
                }
                ++index;
            }
            this.chooseCursor();
            this.switchTool(event);
        }
        catch (Throwable e) {
            LOGGER.warn("Exception occured during processing of event = " + event, e);
            if (this.activeInputProcessor != null) {
                this.activeInputProcessor.cancel();
                this.activeInputProcessor = null;
            }
            this.setCursor(null);
        }
        if (this.activeInputProcessor != oldActiveInputProcessor) {
            this.fireToolStateChanged();
        }
    }

    protected void chooseCursor() {
        if (this.activeInputProcessor == null) {
            int index = 0;
            Cursor cursor = null;
            while (index < this.inputProcessors.size() && cursor == null) {
                IInputProcessor inputProcessor = this.inputProcessors.get(index);
                cursor = inputProcessor.getCursor();
                ++index;
            }
            this.setCursor(cursor);
        }
    }

    public void setToolToSwitchTo(GenericTool toolToSwitchTo, boolean refireEvent) {
        assert (toolToSwitchTo != null);
        this.toolToSwitchTo = toolToSwitchTo;
        this.refireEvent = refireEvent;
    }

    private void switchTool(InputEvent event) {
        if (this.toolToSwitchTo != null) {
            EditDomain domain = this.getCurrentViewer().getEditDomain();
            domain.setActiveTool((Tool)this.toolToSwitchTo);
            this.toolToSwitchTo.setViewer(this.getCurrentViewer());
            if (this.refireEvent) {
                this.toolToSwitchTo.fire(event);
            }
            this.toolToSwitchTo = null;
        }
    }

    public void activate() {
    }

    public void deactivate() {
        if (this.activeInputProcessor != null) {
            this.activeInputProcessor.cancel();
            this.activeInputProcessor = null;
            this.fireToolStateChanged();
        }
    }

    public void addToolStateChangedListener(IToolStateChangedListener toolStateChangedListener) {
        assert (toolStateChangedListener != null);
        assert (!this.toolStateChangedListeners.contains(toolStateChangedListener));
        this.toolStateChangedListeners.add(toolStateChangedListener);
    }

    public void removeToolStateChangedListener(IToolStateChangedListener toolStateChangedListener) {
        assert (toolStateChangedListener != null);
        assert (this.toolStateChangedListeners.contains(toolStateChangedListener));
        this.toolStateChangedListeners.remove(toolStateChangedListener);
    }

    private void fireToolStateChanged() {
        for (IToolStateChangedListener toolStateChangedListener : this.toolStateChangedListeners) {
            toolStateChangedListener.toolStateChanged(this.activeInputProcessor);
        }
    }

    public void focusGained(FocusEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
    }

    public void focusLost(FocusEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
    }

    public final void keyDown(KeyEvent keyEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
        int pressedModifiers = keyEvent.keyCode & SWT.MODIFIER_MASK;
        int activeModifiers = keyEvent.stateMask & SWT.MODIFIER_MASK;
        int currentState = this.state.getStateMask() & ~SWT.MODIFIER_MASK;
        if (LOGGER.isDebugEnabled(68)) {
            LOGGER.debug("Key-Down event on key " + Integer.toHexString(keyEvent.keyCode));
            LOGGER.debug("primary Modifiers     " + Integer.toHexString(pressedModifiers));
            LOGGER.debug("secondary Modifiers   " + Integer.toHexString(activeModifiers));
            LOGGER.debug("current State         " + Integer.toHexString(currentState));
        }
        int newState = currentState | pressedModifiers | activeModifiers;
        this.state.setStateMask(newState);
        IEKeyDown event = new IEKeyDown(keyEvent);
        this.fire(event);
    }

    public final void keyUp(KeyEvent keyEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
        int releasedModifiers = keyEvent.keyCode & SWT.MODIFIER_MASK;
        int activeModifiers = keyEvent.stateMask & SWT.MODIFIER_MASK;
        int currentState = this.state.getStateMask() & ~SWT.MODIFIER_MASK;
        if (LOGGER.isDebugEnabled(68)) {
            LOGGER.debug("Key-Up   event on key " + Integer.toHexString(keyEvent.keyCode));
            LOGGER.debug("primary Modifiers     " + Integer.toHexString(releasedModifiers));
            LOGGER.debug("secondary Modifiers   " + Integer.toHexString(activeModifiers));
            LOGGER.debug("current State         " + Integer.toHexString(currentState));
        }
        int newState = currentState | activeModifiers & ~releasedModifiers;
        this.state.setStateMask(newState);
        IEKeyUp event = new IEKeyUp(keyEvent);
        this.fire(event);
    }

    public final void mouseDoubleClick(MouseEvent mouseEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
    }

    public final void mouseDown(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (mouseEvent.button <= 3) {
            this.setViewer(viewer);
            this.state.copyState(mouseEvent);
            this.state.setMouseButtonPressed(mouseEvent.button, true);
            Long stamp = this.getUnusedStamp();
            this.enqueueStamp(stamp);
            this.lastOutstandingStamp = stamp;
            this.lastClickPosition = this.state.getMousePosition().getCopy();
            int n = mouseEvent.button - 1;
            this.clickMB[n] = this.clickMB[n] + 1;
            if (mouseEvent.button == 3) {
                this.timeOut(stamp);
            } else {
                this.timer.schedule((TimerTask)new TimeOutTask((TimeOutReceiver)this, (Object)stamp, this.currentViewer.getControl().getDisplay()), 200L);
            }
        }
    }

    public final void mouseDrag(MouseEvent mouseEvent, EditPartViewer viewer) {
        this.mouseMove(mouseEvent, viewer);
    }

    public final void mouseHover(MouseEvent mouseEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.state.copyState(mouseEvent);
        IEMouseHover event = new IEMouseHover(this.state.getMousePosition());
        this.fire(event);
    }

    public final void mouseMove(MouseEvent mouseEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
        Point newPosition = new Point(mouseEvent.x, mouseEvent.y);
        IEMouseMove event = new IEMouseMove(newPosition, this.state.getMousePosition());
        this.state.copyState(mouseEvent);
        this.fire(event);
    }

    public final void mouseUp(MouseEvent mouseEvent, EditPartViewer viewer) {
        if (mouseEvent.button <= 3) {
            this.setViewer(viewer);
            this.state.copyState(mouseEvent);
            this.state.setMouseButtonPressed(mouseEvent.button, false);
            if (this.lastOutstandingStamp == null) {
                IEMouseButtonReleased event = new IEMouseButtonReleased(this.state.getMousePosition(), mouseEvent.button);
                this.fire(event);
            }
        }
    }

    public final void triggerTools(EditPartViewer viewer) {
        this.setViewer(viewer);
        this.fire(new IETrigger());
    }

    public void nativeDragFinished(DragSourceEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        assert (false) : "This assertion was inserted to figure out, when the method is called. Please report to Peter Ihme! ";
        LOGGER.trace("Native Drag Finished");
    }

    public void nativeDragStarted(DragSourceEvent event, EditPartViewer viewer) {
        assert (false) : "This assertion was inserted to figure out, when the method is called. Please report to Peter Ihme!";
        LOGGER.trace("Native Drag Started");
    }

    public void setEditDomain(EditDomain domain) {
    }

    public void copyStateFrom(GenericTool otherTool) {
        assert (otherTool != null);
        this.state = otherTool.state != null ? (InputState)otherTool.state.getCopy() : new InputState(10, 10);
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.currentViewer) {
            return;
        }
        this.setCursor(null);
        this.currentViewer = viewer;
        if (this.currentViewer != null) {
            org.eclipse.swt.graphics.Point point = this.currentViewer.getControl().toControl(Display.getCurrent().getCursorLocation());
            this.state = new InputState(point.x, point.y);
            this.lastOutstandingStamp = null;
            this.lastClickPosition = null;
            this.outstandingStamps.clear();
            this.outstandingStamps.add(0L);
            this.clickMB[0] = 0;
            this.clickMB[1] = 0;
            this.clickMB[2] = 0;
        }
    }

    protected void setCursor(Cursor cursor) {
        if (this.activeCursor == cursor) {
            return;
        }
        this.activeCursor = cursor;
        this.getCurrentViewer().setCursor(this.activeCursor);
    }

    public void viewerEntered(MouseEvent mouseEvent, EditPartViewer viewer) {
    }

    public void viewerExited(MouseEvent mouseEvent, EditPartViewer viewer) {
    }

    public final void timeOut(Long timeOutStamp) {
        this.dequeueStamp(timeOutStamp);
        if (timeOutStamp == this.lastOutstandingStamp) {
            this.lastOutstandingStamp = null;
            Point position = this.lastClickPosition;
            this.lastClickPosition = null;
            int index = 0;
            while (index < 3) {
                if (this.clickMB[index] > 0) {
                    IEMouseButtonClicked event = isMacMouseButtonSwapWorkaroundEnabled && index == 0 && (this.state.stateMask & 0x40000) > 0 ? new IEMouseButtonClicked(position, 3, index + 1, this.clickMB[index], this.state.isMouseButtonDown(index + 1)) : new IEMouseButtonClicked(position, index + 1, index + 1, this.clickMB[index], this.state.isMouseButtonDown(index + 1));
                    this.clickMB[index] = 0;
                    this.fire(event);
                }
                ++index;
            }
        }
    }

    private final Long getUnusedStamp() {
        return this.outstandingStamps.get(this.outstandingStamps.size() - 1) + 1L;
    }

    private void enqueueStamp(Long stamp) {
        this.outstandingStamps.add(stamp);
    }

    private void dequeueStamp(Long stamp) {
        this.outstandingStamps.remove(stamp);
    }

    protected final IInputState getState() {
        return this.state;
    }

    protected final EditPartViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public void keyTraversed(TraverseEvent event, EditPartViewer viewer) {
    }

    public void mouseWheelScrolled(Event scrollEvent, EditPartViewer viewer) {
        this.setViewer(viewer);
        IEMouseWheel event = new IEMouseWheel(this.state.getMousePosition(), scrollEvent.count);
        this.state.copyState(scrollEvent);
        this.fire(event);
    }

    public void setProperties(Map properties) {
    }

    private static class InputState
    implements IInputState {
        private final Point mousePosition;
        private int stateMask = 0;

        protected InputState(int mouseX, int mouseY) {
            this.mousePosition = new Point(mouseX, mouseY);
        }

        protected InputState(Point mousePosition, int stateMask) {
            assert (mousePosition != null) : "mousePosition is null";
            this.mousePosition = new Point(mousePosition.x, mousePosition.y);
            this.stateMask = stateMask;
        }

        @Override
        public IInputState getCopy() {
            return new InputState(this.mousePosition, this.stateMask);
        }

        @Override
        public Point getMousePosition() {
            return this.mousePosition;
        }

        protected int getStateMask() {
            return this.stateMask;
        }

        protected void setMousePosition(int x, int y) {
            this.mousePosition.x = x;
            this.mousePosition.y = y;
        }

        protected void setMousePosition(Point p) {
            assert (p != null);
            this.mousePosition.x = p.x;
            this.mousePosition.y = p.y;
        }

        protected void setMouseButtonPressed(int which, boolean pressed) {
            switch (which) {
                case 1: {
                    if (pressed) {
                        this.stateMask |= 0x80000;
                        break;
                    }
                    this.stateMask ^= 0x80000;
                    break;
                }
                case 2: {
                    if (pressed) {
                        this.stateMask |= 0x200000;
                        break;
                    }
                    this.stateMask ^= 0x200000;
                    break;
                }
                case 3: {
                    if (pressed) {
                        this.stateMask |= 0x200000;
                        break;
                    }
                    this.stateMask ^= 0x200000;
                    break;
                }
                default: {
                    assert (false) : "unknown mouse button " + which;
                    break;
                }
            }
        }

        protected void setStateMask(int i) {
            this.stateMask = i;
        }

        @Override
        public boolean isShiftKeyDown() {
            return (this.stateMask & 0x20000) > 0;
        }

        @Override
        public boolean isAltKeyDown() {
            return (this.stateMask & 0x10000) > 0;
        }

        @Override
        public boolean isControlKeyDown() {
            return (this.stateMask & SWT.MOD1) > 0;
        }

        @Override
        public boolean isAnyMouseButtonBown() {
            return (this.stateMask & 0x80000) != 0 || (this.stateMask & 0x100000) != 0 || (this.stateMask & 0x200000) != 0;
        }

        @Override
        public boolean isMouseButtonDown(int which) {
            switch (which) {
                case 1: {
                    return (this.stateMask & 0x80000) != 0;
                }
                case 2: {
                    return (this.stateMask & 0x100000) != 0;
                }
                case 3: {
                    return (this.stateMask & 0x200000) != 0;
                }
            }
            assert (false) : "unknown mouse button: " + which;
            throw new RuntimeException();
        }

        protected void copyState(Event event) {
            assert (event != null) : "event is null";
            this.setMousePosition(event.x, event.y);
            this.setStateMask(event.stateMask);
        }

        protected void copyState(MouseEvent event) {
            assert (event != null) : "event is null";
            this.setMousePosition(event.x, event.y);
            this.setStateMask(event.stateMask);
        }
    }
}

