/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.standalone.wizards;

import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanFileFactoryDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import com.arcway.planagent.planeditor.Messages;
import de.plans.lib.eclipse.FileUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class CreatePlanWizardPage
extends WizardPage
implements KeyListener {
    private WizardNewFileCreationPage newFilePage = null;
    private List planDescriptions;
    Combo planTypeCombo;
    private boolean validPlan = false;
    private Map planIDNameMap;

    public CreatePlanWizardPage(String pageName) {
        super(pageName);
    }

    public CreatePlanWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setPageComplete(false);
    }

    public void setNewFilePage(WizardNewFileCreationPage newFilePage) {
        this.newFilePage = newFilePage;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label planTypeLabel = new Label(composite, 0);
        planTypeLabel.setText(Messages.getString("CreatePlanWizardPage.Plan_Type__5"));
        this.planTypeCombo = new Combo(composite, 2060);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.planTypeCombo.setLayoutData((Object)gridData);
        this.planTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreatePlanWizardPage.this.updateFileName();
                if (CreatePlanWizardPage.this.getContainer().getCurrentPage() != null) {
                    CreatePlanWizardPage.this.getContainer().updateButtons();
                }
            }
        });
        this.addPlanDescriptions();
        this.setControl((Control)composite);
        this.validPlan = true;
        this.updateFileName();
        this.setPageComplete(this.checkPageComplete());
    }

    private void addPlanDescriptions() {
        this.createPlanIDNameMap();
        this.planDescriptions = PlanAgentExtensionMgr.getDefault().getPlanFileFactoryDescriptions();
        for (PlanFileFactoryDescription planFileDesc : this.planDescriptions) {
            String name = (String)this.planIDNameMap.get(planFileDesc.getPlanTypeID());
            String templateName = planFileDesc.getTemplateName();
            this.planTypeCombo.add(String.valueOf(name) + " (" + templateName + ")");
        }
        this.planTypeCombo.select(0);
    }

    private void createPlanIDNameMap() {
        this.planIDNameMap = new HashMap();
        for (PlanTypeDescription desc : PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptions()) {
            this.planIDNameMap.put(desc.getPlanTypeID(), desc.getPlanTypeName(Locale.getDefault()));
        }
    }

    public String getSelectedPlanTypeID() {
        int index = this.planTypeCombo.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        PlanFileFactoryDescription planFileDescription = (PlanFileFactoryDescription)this.planDescriptions.get(index);
        return planFileDescription.getPlanTypeID();
    }

    public IPlanFileFactory getSelectedPlanFileFactory() {
        int index = this.planTypeCombo.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        return ((PlanFileFactoryDescription)this.planDescriptions.get(index)).getPlanFileFactory();
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.validPlan = true;
        this.setPageComplete(this.checkPageComplete());
    }

    private boolean checkPageComplete() {
        return this.validPlan && this.getSelectedPlanTypeID() != null;
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    public void updateFileName() {
        if (this.newFilePage != null) {
            String standardExtension = null;
            String planTypeID = this.getSelectedPlanTypeID();
            try {
                PlanTypeDescription planTypeDescription = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(planTypeID);
                standardExtension = planTypeDescription.getFileExtension();
                if ("".equals(standardExtension)) {
                    standardExtension = null;
                }
            }
            catch (EXPlanTypeUnknown eXPlanTypeUnknown) {
                // empty catch block
            }
            if (standardExtension != null) {
                String oldFileName = this.newFilePage.getFileName();
                String newFileName = FileUtils.forceExtension((String)oldFileName, (String)standardExtension);
                this.newFilePage.setFileName(newFileName);
            }
        }
    }
}

