/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.standalone.wizards;

import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import com.arcway.planagent.planeditor.Messages;
import com.arcway.planagent.planeditor.standalone.wizards.CreatePlanWizardPage;
import de.plans.lib.eclipse.FileUtils;
import de.plans.lib.util.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class CreatePlanWizard
extends Wizard
implements INewWizard {
    private static final Logger logger = Logger.getLogger(CreatePlanWizard.class);
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private String typedPlanName;

    public boolean performFinish() {
        CreatePlanWizardPage cpp = (CreatePlanWizardPage)this.getPage("CreatePlanPage");
        WizardNewFileCreationPage cfp = (WizardNewFileCreationPage)this.getPage("CreateFilePage");
        try {
            IFile file = cfp.createNewFile();
            IPlanFileFactory factory = cpp.getSelectedPlanFileFactory();
            factory.createPlan(file.getLocation().toFile(), this.typedPlanName, null);
            BasicNewResourceWizard.selectAndReveal((IResource)file, (IWorkbenchWindow)this.workbench.getActiveWorkbenchWindow());
            IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
            try {
                IWorkbenchPage page;
                if (dw != null && (page = dw.getActivePage()) != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException partInitException) {}
        }
        catch (IPlanFileFactory.EXCreatePlanException e) {
            logger.error((Object)"Plan creation failure", (Throwable)e);
            return false;
        }
        return true;
    }

    public void addPages() {
        this.setWindowTitle(Messages.getString("CreatePlanWizard.New_Plan_4"));
        CreatePlanWizardPage createPlanWizardPage = new CreatePlanWizardPage("CreatePlanPage", Messages.getString("CreatePlanWizard.Plan_2"), null);
        WizardNewFileCreationPage createFileWizardPage = new WizardNewFileCreationPage("CreateFilePage", this.selection){

            protected boolean validatePage() {
                boolean valid = super.validatePage();
                if (valid && this.getErrorMessage() == null) {
                    boolean nameIsEmpty;
                    String fileName = this.getFileName();
                    if (fileName == null) {
                        fileName = "";
                    }
                    if (nameIsEmpty = FileUtils.withoutExtension((String)fileName).equals("")) {
                        this.setErrorMessage(Messages.getString("CreatePlanWizard.FileNameShouldNotBeEmpty"));
                        valid = false;
                    }
                }
                return valid;
            }

            public boolean isPageComplete() {
                return super.isPageComplete();
            }

            public void setPageComplete(boolean complete) {
                super.setPageComplete(complete);
            }
        };
        createFileWizardPage.setDescription(Messages.getString("CreatePlanWizard.Create_a_new_Plan._5"));
        createFileWizardPage.setFileName(Messages.getString("CreatePlanWizard.NewPlan"));
        createPlanWizardPage.setNewFilePage(createFileWizardPage);
        createPlanWizardPage.setDescription(Messages.getString("CreatePlanWizard.Create_a_new_Plan._5"));
        this.addPage((IWizardPage)createPlanWizardPage);
        this.addPage((IWizardPage)createFileWizardPage);
    }

    public void setTypedPlanName(String planName) {
        this.typedPlanName = planName;
    }

    public void init(IWorkbench initWorkbench, IStructuredSelection initSelection) {
        this.selection = initSelection;
        this.workbench = initWorkbench;
    }
}

