/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.palette;

import com.arcway.lib.eclipse.plugins.EclipseUIPlugin;
import com.arcway.lib.eclipse.resources.ResourceLoader;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planeditor.IPaletteSection;
import com.arcway.planagent.planeditor.pagebooks.palette.PaletteItem;
import com.arcway.planagent.planmodel.PlanModelExtensionMgr;
import com.arcway.planagent.planmodel.access.readonly.IPMPlanRO;
import com.arcway.planagent.planmodel.implementation.PlanModelMgr;
import com.arcway.planagent.planmodel.persistent.EXPlanCreationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.swt.graphics.Image;

public class PaletteSection
implements IPaletteSection {
    private static final ILogger logger = Logger.getLogger(PaletteSection.class);
    private final String title;
    private final List<PaletteItem> items;

    public PaletteSection(String title) {
        this.title = title;
        this.items = new ArrayList<PaletteItem>();
    }

    public void addDefaultItem(String planTypeID, String planElementTypeID, String label, String description) {
        IPMPlanRO template = PlanModelExtensionMgr.getDefault().getFirstTemplate(planTypeID, planElementTypeID);
        if (template != null) {
            this.addPlanItem(template, label, description);
        } else {
            logger.error("No default palette item defined for " + planTypeID + "/" + planElementTypeID + ".");
        }
    }

    public void addDefaultItem(String planElementTypeID, String label, String description) {
        IPMPlanRO template = PlanModelExtensionMgr.getDefault().getFirstTemplate(planElementTypeID);
        if (template != null) {
            this.addPlanItem(template, label, description);
        } else {
            logger.error("No default palette item defined for " + planElementTypeID + ".");
        }
    }

    public void addFileItem(EclipseUIPlugin plugin, String fileName, String label, String description) {
        this.addFileItem(plugin, fileName, label, description, null);
    }

    public void addFileItem(EclipseUIPlugin plugin, String fileName, String label, String description, Image thumbnail) {
        PlanModelMgr pmmgr = new PlanModelMgr();
        try (InputStream planIs = null;){
            planIs = ResourceLoader.getURL((Plugin)plugin, (String)fileName).openStream();
            pmmgr.load(planIs);
            this.addPlanItem((IPMPlanRO)pmmgr.getPlan(), label, description, thumbnail);
        }
        catch (IOException e) {
            logger.error("Could not load palette item " + fileName + ".", (Throwable)e);
        }
        catch (EXPlanCreationException e) {
            logger.error("Could not load palette item " + fileName + ".", (Throwable)e);
        }
    }

    public void addPlanItem(IPMPlanRO template, String label, String description) {
        this.addPlanItem(template, label, description, null);
    }

    public void addPlanItem(IPMPlanRO template, String label, String description, Image thumbnail) {
        this.addItem(new PaletteItem(label, description, thumbnail, template));
    }

    public void addItem(PaletteItem item) {
        this.items.add(item);
    }

    public String getTitle() {
        return this.title;
    }

    public List<PaletteItem> getItems() {
        return this.items;
    }
}

