/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.overview;

import com.arcway.planagent.planeditor.pagebooks.overview.PATCHED_ScaledGraphics;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PATCHED_Thumbnail
extends Figure
implements UpdateListener {
    private boolean isDirty;
    private float scaleX;
    private float scaleY;
    private IFigure sourceFigure;
    Dimension targetSize = new Dimension(0, 0);
    private Image thumbnailImage;
    private Dimension thumbnailImageSize;
    private final ThumbnailUpdater updater = new ThumbnailUpdater();

    public PATCHED_Thumbnail() {
    }

    public PATCHED_Thumbnail(IFigure fig) {
        this();
        this.setSource(fig);
    }

    private Dimension adjustToAspectRatio(Dimension size, boolean adjustToMaxDimension) {
        int height;
        int width;
        Dimension sourceSize = this.getSourceRectangle().getSize();
        Dimension borderSize = new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight());
        size.expand(borderSize.getNegated());
        if (adjustToMaxDimension) {
            width = Math.max(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.max(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        } else {
            width = Math.min(size.width, (int)((double)((float)(size.height * sourceSize.width) / (float)sourceSize.height) + 0.5));
            height = Math.min(size.height, (int)((double)((float)(size.width * sourceSize.height) / (float)sourceSize.width) + 0.5));
        }
        size.width = width;
        size.height = height;
        return size.expand(borderSize);
    }

    public void deactivate() {
        this.sourceFigure.getUpdateManager().removeUpdateListener((UpdateListener)this);
        this.updater.deactivate();
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize == null) {
            return this.adjustToAspectRatio(this.getBounds().getSize(), false);
        }
        Dimension preferredSize = this.adjustToAspectRatio(this.prefSize.getCopy(), true);
        if (this.maxSize == null) {
            return preferredSize;
        }
        Dimension maximumSize = this.adjustToAspectRatio(this.maxSize.getCopy(), true);
        if (preferredSize.contains(maximumSize)) {
            return maximumSize;
        }
        return preferredSize;
    }

    protected float getScaleX() {
        return this.scaleX;
    }

    protected float getScaleY() {
        return this.scaleY;
    }

    protected IFigure getSource() {
        return this.sourceFigure;
    }

    protected Rectangle getSourceRectangle() {
        return this.sourceFigure.getBounds();
    }

    protected Image getThumbnailImage() {
        Dimension oldSize = this.targetSize;
        this.targetSize = this.getPreferredSize();
        this.targetSize.expand(new Dimension(this.getInsets().getWidth(), this.getInsets().getHeight()).negate());
        this.setScales((float)this.targetSize.width / (float)this.getSourceRectangle().width, (float)this.targetSize.height / (float)this.getSourceRectangle().height);
        if (this.isDirty() && !this.updater.isRunning()) {
            this.updater.start();
        } else if (oldSize != null && !this.targetSize.equals((Object)oldSize)) {
            this.revalidate();
            this.updater.restart();
        }
        return this.thumbnailImage;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    public void notifyPainting(Rectangle damage, Map dirtyRegions) {
        for (IFigure current : dirtyRegions.keySet()) {
            while (current != null) {
                if (current == this.getSource()) {
                    this.setDirty(true);
                    this.repaint();
                    return;
                }
                current = current.getParent();
            }
        }
    }

    public void notifyValidating() {
    }

    protected void paintFigure(Graphics graphics) {
        Image thumbnail = this.getThumbnailImage();
        if (thumbnail == null) {
            return;
        }
        graphics.drawImage(thumbnail, this.getClientArea().getLocation());
    }

    public void setDirty(boolean value) {
        this.isDirty = value;
    }

    protected void setScales(float x, float y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setSource(IFigure fig) {
        if (this.sourceFigure == fig) {
            return;
        }
        if (this.sourceFigure != null) {
            this.sourceFigure.getUpdateManager().removeUpdateListener((UpdateListener)this);
        }
        this.sourceFigure = fig;
        if (this.sourceFigure != null) {
            this.setScales((float)this.getSize().width / (float)this.getSourceRectangle().width, (float)this.getSize().height / (float)this.getSourceRectangle().height);
            this.sourceFigure.getUpdateManager().addUpdateListener((UpdateListener)this);
            this.repaint();
        }
    }

    class ThumbnailUpdater
    implements Runnable {
        static final int MAX_BUFFER_SIZE = 256;
        private int currentHTile;
        private int currentVTile;
        private int hTiles;
        private int vTiles;
        private boolean isActive = true;
        private boolean isRunning = false;
        private GC thumbnailGC;
        private PATCHED_ScaledGraphics thumbnailGraphics;
        private Dimension tileSize;
        private static final int TILES = 3;

        ThumbnailUpdater() {
        }

        public void deactivate() {
            this.setActive(false);
            this.stop();
            if (PATCHED_Thumbnail.this.thumbnailImage != null) {
                PATCHED_Thumbnail.this.thumbnailImage.dispose();
                PATCHED_Thumbnail.this.thumbnailImage = null;
                PATCHED_Thumbnail.this.thumbnailImageSize = null;
            }
        }

        protected int getCurrentHTile() {
            return this.currentHTile;
        }

        protected int getCurrentVTile() {
            return this.currentVTile;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public void resetTileValues() {
            this.hTiles = 3;
            this.vTiles = 3;
            this.tileSize = new Dimension((int)Math.ceil((float)PATCHED_Thumbnail.this.getSourceRectangle().width / (float)this.hTiles), (int)Math.ceil((float)PATCHED_Thumbnail.this.getSourceRectangle().height / (float)this.vTiles));
            this.currentHTile = 0;
            this.currentVTile = 0;
        }

        public void restart() {
            this.stop();
            this.start();
        }

        @Override
        public void run() {
            if (!this.isActive() || !this.isRunning() || this.thumbnailGraphics == null) {
                return;
            }
            int v = this.getCurrentVTile();
            int sy1 = v * this.tileSize.height;
            int sy2 = Math.min((v + 1) * this.tileSize.height, PATCHED_Thumbnail.this.getSourceRectangle().height);
            int h = this.getCurrentHTile();
            int sx1 = h * this.tileSize.width;
            int sx2 = Math.min((h + 1) * this.tileSize.width, PATCHED_Thumbnail.this.getSourceRectangle().width);
            Point p = PATCHED_Thumbnail.this.getSourceRectangle().getLocation();
            Rectangle rect = new Rectangle(sx1 + p.x, sy1 + p.y, sx2 - sx1, sy2 - sy1);
            this.thumbnailGraphics.pushState();
            this.thumbnailGraphics.setClip(rect);
            this.thumbnailGraphics.fillRectangle(rect);
            PATCHED_Thumbnail.this.sourceFigure.paint((Graphics)this.thumbnailGraphics);
            this.thumbnailGraphics.popState();
            if (this.getCurrentHTile() < this.hTiles - 1) {
                this.setCurrentHTile(this.getCurrentHTile() + 1);
            } else {
                this.setCurrentHTile(0);
                if (this.getCurrentVTile() < this.vTiles - 1) {
                    this.setCurrentVTile(this.getCurrentVTile() + 1);
                } else {
                    this.setCurrentVTile(0);
                }
            }
            if (this.getCurrentHTile() != 0 || this.getCurrentVTile() != 0) {
                Display.getCurrent().asyncExec((Runnable)this);
            } else if (PATCHED_Thumbnail.this.isDirty()) {
                PATCHED_Thumbnail.this.setDirty(false);
                Display.getCurrent().asyncExec((Runnable)this);
                PATCHED_Thumbnail.this.repaint();
            } else {
                this.stop();
                PATCHED_Thumbnail.this.repaint();
            }
        }

        public void setActive(boolean value) {
            this.isActive = value;
        }

        protected void setCurrentHTile(int count) {
            this.currentHTile = count;
        }

        protected void setCurrentVTile(int count) {
            this.currentVTile = count;
        }

        public void start() {
            if (!this.isActive() || this.isRunning()) {
                return;
            }
            this.isRunning = true;
            PATCHED_Thumbnail.this.setDirty(false);
            this.resetTileValues();
            if (!PATCHED_Thumbnail.this.targetSize.equals((Object)PATCHED_Thumbnail.this.thumbnailImageSize)) {
                this.resetThumbnailImage();
            }
            if (PATCHED_Thumbnail.this.targetSize.isEmpty()) {
                return;
            }
            this.thumbnailGC = new GC((Drawable)PATCHED_Thumbnail.this.thumbnailImage, PATCHED_Thumbnail.this.sourceFigure.isMirrored() ? 0x4000000 : 0);
            this.thumbnailGraphics = new PATCHED_ScaledGraphics((Graphics)new SWTGraphics(this.thumbnailGC));
            this.thumbnailGraphics.scale(PATCHED_Thumbnail.this.getScaleX());
            this.thumbnailGraphics.translate(PATCHED_Thumbnail.this.getSourceRectangle().getLocation().negate());
            Color color = PATCHED_Thumbnail.this.sourceFigure.getForegroundColor();
            if (color != null) {
                this.thumbnailGraphics.setForegroundColor(color);
            }
            if ((color = PATCHED_Thumbnail.this.sourceFigure.getBackgroundColor()) != null) {
                this.thumbnailGraphics.setBackgroundColor(color);
            }
            this.thumbnailGraphics.setFont(PATCHED_Thumbnail.this.sourceFigure.getFont());
            PATCHED_Thumbnail.this.setScales((float)PATCHED_Thumbnail.this.targetSize.width / (float)PATCHED_Thumbnail.this.getSourceRectangle().width, (float)PATCHED_Thumbnail.this.targetSize.height / (float)PATCHED_Thumbnail.this.getSourceRectangle().height);
            Display.getCurrent().asyncExec((Runnable)this);
        }

        private void resetThumbnailImage() {
            if (PATCHED_Thumbnail.this.thumbnailImage != null) {
                PATCHED_Thumbnail.this.thumbnailImage.dispose();
            }
            if (!PATCHED_Thumbnail.this.targetSize.isEmpty()) {
                PATCHED_Thumbnail.this.thumbnailImage = new Image((Device)Display.getDefault(), PATCHED_Thumbnail.this.targetSize.width, PATCHED_Thumbnail.this.targetSize.height);
                PATCHED_Thumbnail.this.thumbnailImageSize = new Dimension(PATCHED_Thumbnail.this.targetSize);
            } else {
                PATCHED_Thumbnail.this.thumbnailImage = null;
                PATCHED_Thumbnail.this.thumbnailImageSize = new Dimension(0, 0);
            }
        }

        public void stop() {
            this.isRunning = false;
            if (this.thumbnailGC != null) {
                this.thumbnailGC.dispose();
                this.thumbnailGC = null;
            }
            if (this.thumbnailGraphics != null) {
                this.thumbnailGraphics.dispose();
                this.thumbnailGraphics = null;
            }
        }
    }
}

