/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks.overview;

import com.arcway.planagent.planeditor.pagebooks.AbstractPageBookMgr;
import com.arcway.planagent.planeditor.pagebooks.IPageBookContentProvider;
import com.arcway.planagent.planeditor.pagebooks.overview.OverviewPageBookViewDescriptor;
import com.arcway.planagent.planeditor.pagebooks.overview.PATCHED_ScrollableThumbnail;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class OverviewMgr
extends AbstractPageBookMgr
implements IPageBookContentProvider {
    private static final Color OVERVIEW_BG_COLOR = ColorConstants.lightGray;
    private GraphicalViewer graphicalViewer = null;

    public OverviewMgr(IWorkbenchPart facade) {
        super(facade, OverviewPageBookViewDescriptor.INSTANCE);
    }

    public void setGraphicalView(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
        if (graphicalViewer != null) {
            this.setContentProvider(this);
        } else {
            this.setContentProvider(null);
        }
    }

    @Override
    public Control createControl(Composite parent) {
        Canvas overview = new Canvas(parent, 0);
        overview.setBackground(OVERVIEW_BG_COLOR);
        LightweightSystem lws = new LightweightSystem(overview);
        RootEditPart rep = this.graphicalViewer.getRootEditPart();
        if (rep instanceof ScalableFreeformRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            final PATCHED_ScrollableThumbnail thumbnail = new PATCHED_ScrollableThumbnail((Viewport)root.getFigure());
            thumbnail.setBorder((Border)new MarginBorder(3));
            thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            lws.setContents((IFigure)thumbnail);
            overview.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    thumbnail.deactivate();
                }
            });
        }
        return overview;
    }
}

