/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.planagent.planeditor.pagebooks;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.planeditor.pagebooks.IPageBookViewDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public abstract class AbstractPagebookView
extends PageBookView {
    private static final ILogger logger = Logger.getLogger(AbstractPagebookView.class);

    protected abstract IPageBookViewDescriptor getPageBookViewDescriptor();

    public AbstractPagebookView() {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Overview created.");
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Create default page ...");
        }
        MessagePage page = new MessagePage();
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        page.setMessage(this.getPageBookViewDescriptor().getNoPageDefinedMessage());
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Default page created ...");
        }
        return page;
    }

    protected IWorkbenchPart getBootstrapPart() {
        IEditorPart activeEditor;
        IWorkbenchPage page;
        IEditorPart bootstrapPart = null;
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Looking for a bootstrap part ...");
        }
        if ((page = this.getSite().getPage()) != null && (activeEditor = page.getActiveEditor()) != null && this.isImportant((IWorkbenchPart)activeEditor)) {
            bootstrapPart = activeEditor;
        }
        if (logger.isDebugEnabled(70)) {
            if (bootstrapPart != null) {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... bootstrap part found: " + bootstrapPart.getTitle() + " (" + bootstrapPart.getSite().getId() + ")");
            } else {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... no bootstrap part found.");
            }
        }
        return bootstrapPart;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Is important part " + part.getTitle() + " (" + part.getSite().getId() + ")? ...");
        }
        boolean isImportant = part instanceof IEditorPart && part.getAdapter(this.getPageBookViewDescriptor().getPageClass()) != null;
        if (logger.isDebugEnabled(70)) {
            if (isImportant) {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... part is important.");
            } else {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... part is not important.");
            }
        }
        return isImportant;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Create Page for workbench part " + part.getTitle() + " (" + part.getSite().getId() + ") ...");
        }
        PageBookView.PageRec pageRec = null;
        Object obj = part.getAdapter(this.getPageBookViewDescriptor().getPageClass());
        if (obj != null && this.getPageBookViewDescriptor().getPageClass().isInstance(obj)) {
            Page page = (Page)obj;
            this.initPage((IPageBookViewPage)page);
            page.createControl((Composite)this.getPageBook());
            pageRec = new PageBookView.PageRec(part, (IPage)page);
        }
        if (logger.isDebugEnabled(70)) {
            if (pageRec != null) {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... page record created.");
            } else {
                logger.debug(70, ".. [PAGEBOOKVIEW] ... page record not created.");
            }
        }
        if (pageRec == null) {
            logger.error("[PAGEBOOKVIEW] Unable to create page record for workbench part " + part.getTitle() + " (" + part.getSite().getId() + ")!");
        }
        return pageRec;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] Destroy Page for workbench part " + part.getTitle() + " (" + part.getSite().getId() + ") ...");
        }
        Page page = (Page)pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        if (logger.isDebugEnabled(70)) {
            logger.debug(70, ".. [PAGEBOOKVIEW] ... page destroyed.");
        }
    }
}

